/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.foundation.common.internal;

import com.ibm.team.foundation.common.IEventGroup;
import com.ibm.team.foundation.common.IEventType;
import com.ibm.team.foundation.common.IObjectType;
import com.ibm.team.foundation.common.IVerb;
import com.ibm.team.repository.common.feeds.IFeedEventGroup;
import com.ibm.team.repository.common.feeds.IFeedEventType;
import com.ibm.team.repository.common.feeds.IFeedObjectType;
import com.ibm.team.repository.common.feeds.IFeedVerb;
import java.net.URL;
import java.util.Collection;

public final class EventTypeAdapterFactory {
    public static IEventGroup createEventGroupAdapter(IFeedEventGroup evntGroup) {
        return new EventGroupAdapter(evntGroup);
    }

    public static IEventType createEventTypeAdapter(IFeedEventType eventType) {
        return new EventTypeAdapter(eventType);
    }

    public static IVerb createVerbAdapter(IFeedVerb verb) {
        return new VerbAdapter(verb);
    }

    public static IObjectType createObjectTypeAdapter(IFeedObjectType objectType) {
        return new ObjectTypeAdapter(objectType);
    }

    static class EventGroupAdapter
    implements IEventGroup {
        private IFeedEventGroup eventGroup;

        protected EventGroupAdapter(IFeedEventGroup obj) {
            if (obj == null) {
                throw new IllegalArgumentException();
            }
            this.eventGroup = obj;
        }

        public String getId() {
            return this.eventGroup.getId();
        }

        public URL getIconUrl() {
            return this.eventGroup.getIconUrl();
        }

        public String getName() {
            return this.eventGroup.getName();
        }

        public boolean isVisibleByDefault() {
            return this.eventGroup.isVisibleByDefault();
        }

        public Collection<String> getEventTypeIds() {
            return this.eventGroup.getEventTypeIds();
        }
    }

    static class EventTypeAdapter
    implements IEventType {
        private IFeedEventType eventType;

        protected EventTypeAdapter(IFeedEventType obj) {
            if (obj == null) {
                throw new IllegalArgumentException();
            }
            this.eventType = obj;
        }

        public String getCategoryId() {
            return this.eventType.getCategoryId();
        }

        public URL getIconUrl() {
            return this.eventType.getIconUrl();
        }

        public String getName() {
            return this.eventType.getName();
        }

        public String getVerb() {
            return this.eventType.getVerb();
        }

        public String getObjectType() {
            return this.eventType.getObjectType();
        }
    }

    static class ObjectTypeAdapter
    implements IObjectType {
        private IFeedObjectType objectType;

        protected ObjectTypeAdapter(IFeedObjectType obj) {
            if (obj == null) {
                throw new IllegalArgumentException();
            }
            this.objectType = obj;
        }

        public String getId() {
            return this.objectType.getId();
        }

        public String getLabel() {
            return this.objectType.getLabel();
        }

        public String[] getHypernyms() {
            return this.objectType.getHypernyms();
        }
    }

    static class VerbAdapter
    implements IVerb {
        private IFeedVerb verb;

        protected VerbAdapter(IFeedVerb obj) {
            if (obj == null) {
                throw new IllegalArgumentException();
            }
            this.verb = obj;
        }

        public String getId() {
            return this.verb.getId();
        }

        public String getLabel() {
            return this.verb.getLabel();
        }

        public String[] getHypernyms() {
            return this.verb.getHypernyms();
        }
    }
}

