/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.process.common.internal.setup.builders;

import com.ibm.team.process.common.IDevelopmentLine;
import com.ibm.team.process.common.IDevelopmentLineHandle;
import com.ibm.team.process.common.IIteration;
import com.ibm.team.process.common.IIterationHandle;
import com.ibm.team.process.common.IProcessItem;
import com.ibm.team.process.common.IProjectArea;
import com.ibm.team.process.common.internal.setup.builders.AbstractProcessBuilder;
import com.ibm.team.process.common.internal.setup.builders.DevelopmentLineBuilder;
import com.ibm.team.process.common.internal.setup.builders.IProcessBuilderContext;
import com.ibm.team.process.common.internal.setup.builders.ProjectAreaBuilder;
import com.ibm.team.process.internal.common.Iteration;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.rtc.common.internal.setup.builders.AbstractArtifactBuilder;
import com.ibm.team.rtc.common.internal.setup.builders.BuildContext;
import com.ibm.team.rtc.common.internal.setup.builders.IPostSaveHook;
import com.ibm.team.rtc.common.internal.setup.builders.ValueKey;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;

public class IterationBuilder
extends AbstractProcessBuilder<IIteration> {
    protected static final ValueKey<String> NAME_KEY = new ValueKey(String.valueOf(IterationBuilder.class.getName()) + ".name");
    protected static final ValueKey<Boolean> ARCHIVED_KEY = new ValueKey(String.valueOf(IterationBuilder.class.getName()) + ".archived");
    protected static final ValueKey<Date> START_DATE_KEY = new ValueKey(String.valueOf(IterationBuilder.class.getName()) + ".startDate");
    protected static final ValueKey<Date> END_DATE_KEY = new ValueKey(String.valueOf(IterationBuilder.class.getName()) + ".endDate");
    protected static final ValueKey<List<IIteration>> ITERATION_KEY = new ValueKey(String.valueOf(IterationBuilder.class.getName()) + ".iteration");
    protected static final ValueKey<IIterationHandle> PARENT_KEY = new ValueKey(String.valueOf(IterationBuilder.class.getName()) + ".parent");
    protected static final ValueKey<Boolean> HAS_DELIVERABLE_KEY = new ValueKey(String.valueOf(IterationBuilder.class.getName()) + ".hasDeliverable");
    protected static final ValueKey<String> ID_KEY = new ValueKey(String.valueOf(IterationBuilder.class.getName()) + ".id");
    protected static final ValueKey<UUID> CONTEXT_ID = new ValueKey(String.valueOf(IterationBuilder.class.getName()) + ".contextId");
    protected static final ValueKey<IIterationHandle> CURRENT_ITERATION_KEY = new ValueKey(String.valueOf(IterationBuilder.class.getName()) + ".currentIteration");
    protected static final ValueKey<IDevelopmentLine> DEVELOPMENT_LINE_KEY = new ValueKey(String.valueOf(IterationBuilder.class.getName()) + ".developmentLine");
    protected static final ValueKey<DevelopmentLineBuilder> DEVELOPMENT_LINE_BUILDER = new ValueKey(String.valueOf(IterationBuilder.class.getName()) + ".developmentLineBuilder");
    private static final ValueKey<ProjectAreaBuilder> PROJECT_AREA_BUILDER = new ValueKey(String.valueOf(IterationBuilder.class.getName()) + ".projectAreaBuilder");

    public IterationBuilder(IProcessBuilderContext buildContext) {
        super(buildContext);
        this.setBuilderValue(ITERATION_KEY, new ArrayList());
    }

    public IterationBuilder id(String id) {
        this.setBuilderValue(ID_KEY, id);
        return this;
    }

    public IterationBuilder contextId(UUID contextId) {
        this.setBuilderValue(CONTEXT_ID, contextId);
        return this;
    }

    public IterationBuilder name(String name) {
        this.setBuilderValue(NAME_KEY, name);
        return this;
    }

    public IterationBuilder projectArea(ProjectAreaBuilder projectArea) {
        this.setBuilderValue(PROJECT_AREA_BUILDER, projectArea);
        return this;
    }

    public IterationBuilder developmentLine(IDevelopmentLine developmentLine) {
        this.setBuilderValue(DEVELOPMENT_LINE_KEY, developmentLine);
        return this;
    }

    public IterationBuilder developmentLine(DevelopmentLineBuilder developmentLine) {
        this.setBuilderValue(DEVELOPMENT_LINE_BUILDER, developmentLine);
        return this;
    }

    public IterationBuilder child(IIteration ... iteration) {
        this.getBuilderValue(ITERATION_KEY).addAll(Arrays.asList(iteration));
        return this;
    }

    public IterationBuilder child(IterationBuilder ... builder) {
        this.addChildBuilder(builder);
        return this;
    }

    public IterationBuilder archived(boolean isArchived) {
        this.setBuilderValue(ARCHIVED_KEY, isArchived);
        return this;
    }

    public IterationBuilder currentIteration(IterationBuilder currentIteration) {
        this.addChildBuilder(currentIteration);
        currentIteration.addPostSaveHook(new IPostSaveHook<IIteration>(){

            @Override
            public void itemSaved(AbstractArtifactBuilder.ArtifactSavedEvent<IIteration> saveEvent) {
                IterationBuilder.this.currentIteration((IIteration)saveEvent.fArtifact);
            }
        });
        return this;
    }

    public IterationBuilder currentIteration(IIteration currentIteration) {
        this.setBuilderValue(CURRENT_ITERATION_KEY, currentIteration);
        return this;
    }

    public IterationBuilder startDate(Date date) {
        this.setBuilderValue(START_DATE_KEY, date);
        return this;
    }

    public IterationBuilder endDate(Date date) {
        this.setBuilderValue(END_DATE_KEY, date);
        return this;
    }

    public IterationBuilder parent(IIterationHandle iteration) {
        this.setBuilderValue(PARENT_KEY, iteration);
        return this;
    }

    public IterationBuilder parent(IterationBuilder iteration) {
        this.setBuilderValue(PARENT_KEY, (IIterationHandle)iteration.build());
        return this;
    }

    public IterationBuilder hasDeliverable(boolean deliverable) {
        this.setBuilderValue(HAS_DELIVERABLE_KEY, deliverable);
        return this;
    }

    @Override
    protected BuildContext contributeToContext(IIteration artifact, BuildContext context) {
        BuildContext result = super.contributeToContext(artifact, context);
        result.setProperty(BuildContext.ITERATION, artifact);
        return result;
    }

    @Override
    protected IIteration doArtifactBuild(BuildContext buildContext) {
        IIteration iteration = (IIteration)this.artifact(IIteration.ITEM_TYPE);
        iteration.setId(this.chooseValue(ID_KEY, iteration.getId(), UUID.generate().getUuidValue()));
        ((Iteration)iteration).setArchived(this.chooseValue(ARCHIVED_KEY, iteration.isArchived(), false).booleanValue());
        iteration.setContextId(this.chooseValue(CONTEXT_ID, iteration.getContextId(), UUID.generate()));
        iteration.setName(this.chooseValue(NAME_KEY, iteration.getName(), UUID.generate().getUuidValue()));
        iteration.setStartDate(this.chooseValue(START_DATE_KEY, iteration.getStartDate(), new GregorianCalendar().getTime()));
        iteration.setEndDate((Date)this.chooseValue(END_DATE_KEY, iteration.getEndDate(), null));
        iteration.setHasDeliverable(this.chooseValue(HAS_DELIVERABLE_KEY, iteration.hasDeliverable(), true).booleanValue());
        this.setParentIteration(iteration, buildContext);
        this.setDevelopmentLine(iteration, buildContext);
        for (IIteration child : this.getBuilderValue(ITERATION_KEY)) {
            iteration.addChild((IIterationHandle)child);
            child.setParent((IIterationHandle)iteration);
            if (!buildContext.isPropertySet(BuildContext.BULK_PROCESS_SAVE)) continue;
            buildContext.getProperty(BuildContext.BULK_PROCESS_SAVE).put(child, null);
        }
        return iteration;
    }

    private void setParentIteration(IIteration iteration, BuildContext buildContext) {
        IIterationHandle parentHandle = this.chooseValue(buildContext, PARENT_KEY, BuildContext.ITERATION, iteration.getParent());
        if (parentHandle != null) {
            IIteration parent = (IIteration)parentHandle;
            parent.addChild((IIterationHandle)iteration);
            iteration.setParent((IIterationHandle)parent);
            try {
                buildContext.setProperty(BuildContext.DEVELOPMENT_LINE, (IDevelopmentLine)this.resolve((IItemHandle)((IIteration)this.resolve((IItemHandle)parentHandle)).getDevelopmentLine()));
            }
            catch (TeamRepositoryException e) {
                throw new RuntimeException(e.getMessage());
            }
        }
    }

    private void setDevelopmentLine(IIteration iteration, BuildContext context) {
        IDevelopmentLine developmentLine = this.getBuilderValue(DEVELOPMENT_LINE_KEY);
        if (developmentLine == null && this.isBuilderValueSet(DEVELOPMENT_LINE_BUILDER)) {
            developmentLine = (IDevelopmentLine)this.getBuilderValue(DEVELOPMENT_LINE_BUILDER).build();
        }
        if (developmentLine == null) {
            developmentLine = context.getProperty(BuildContext.DEVELOPMENT_LINE);
        }
        if (developmentLine == null) {
            developmentLine = new DevelopmentLineBuilder(this.getContext()).createArtifact(context);
        }
        if (iteration.getParent() == null) {
            developmentLine = (IDevelopmentLine)developmentLine.getWorkingCopy();
            developmentLine.addIteration((IIterationHandle)iteration);
            context.updateItem((IItem)developmentLine);
        }
        iteration.setDevelopmentLine((IDevelopmentLineHandle)developmentLine);
    }

    @Override
    protected IIteration doArtifactSave(BuildContext context) throws TeamRepositoryException {
        if (context.getProperty(BuildContext.DEVELOPMENT_LINE) == null && this.getBuilderValue(DEVELOPMENT_LINE_KEY) == null) {
            DevelopmentLineBuilder builder = this.getBuilderValue(DEVELOPMENT_LINE_BUILDER);
            if (builder == null) {
                builder = new DevelopmentLineBuilder(this.getContext());
            }
            IProjectArea projectArea = this.saveProjectArea(context);
            IDevelopmentLine developmentLine = (IDevelopmentLine)builder.projectArea(projectArea).build();
            this.setBuilderValue(DEVELOPMENT_LINE_KEY, developmentLine);
            if (projectArea.getProjectDevelopmentLine() == null) {
                projectArea.setProjectDevelopmentLine((IDevelopmentLineHandle)developmentLine);
            }
            projectArea.addDevelopmentLine((IDevelopmentLineHandle)developmentLine);
            context.addToBulkSave(projectArea, this.getBuilderValue(PROJECT_AREA_BUILDER));
            context.addToBulkSave((IProcessItem)developmentLine);
        }
        return this.doArtifactBuild(context);
    }

    private IProjectArea saveProjectArea(BuildContext context) throws TeamRepositoryException {
        IProjectArea result = context.getProperty(BuildContext.PROJECT_AREA);
        if (result == null) {
            result = (IProjectArea)this.getBuilderValue(PROJECT_AREA_BUILDER, new ProjectAreaBuilder(this.getContext())).save();
        }
        return (IProjectArea)result.getWorkingCopy();
    }

    @Override
    protected void postSaveChildren(BuildContext saveContext, IIteration iteration) throws TeamRepositoryException {
        IDevelopmentLine devLine = saveContext.getProperty(BuildContext.DEVELOPMENT_LINE);
        if (devLine == null && this.isBuilderValueSet(CURRENT_ITERATION_KEY)) {
            throw new RuntimeException("Attempt to save current iteration with no DevelopmentLine in build context failed.");
        }
        if (devLine != null) {
            devLine.setCurrentIteration(this.chooseValue(CURRENT_ITERATION_KEY, devLine.getCurrentIteration()));
        }
    }

    @Override
    protected IProcessItem getParentArtifact(IIteration iteration) {
        return (IProcessItem)iteration.getParent();
    }
}

