/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.common.json;

import com.ibm.team.repository.common.json.IJSONSerializable;
import com.ibm.team.repository.common.json.JSONArray;
import com.ibm.team.repository.common.json.internal.Parser;
import com.ibm.team.repository.common.json.internal.Serializer;
import com.ibm.team.repository.common.json.internal.SerializerVerbose;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.text.MessageFormat;
import java.util.HashMap;

public class JSONObject
extends HashMap
implements IJSONSerializable {
    private static final long serialVersionUID = -3269263069889337298L;

    public static boolean isValidObject(Object object) {
        if (object == null) {
            return true;
        }
        return JSONObject.isValidType(object.getClass());
    }

    public static boolean isValidType(Class clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException();
        }
        if (String.class == clazz) {
            return true;
        }
        if (Boolean.class == clazz) {
            return true;
        }
        if (JSONObject.class == clazz) {
            return true;
        }
        if (JSONArray.class == clazz) {
            return true;
        }
        return Number.class.isAssignableFrom(clazz);
    }

    public static JSONObject parse(Reader reader) throws IOException {
        Object obj = new Parser(reader = new BufferedReader(reader)).parse();
        if (!(obj instanceof JSONObject)) {
            String msg = MessageFormat.format("The type \"{0}\" was encountered, rather than the expected type \"JSONObject\"", obj.getClass());
            throw new IOException(msg);
        }
        return (JSONObject)obj;
    }

    public static Object parseAny(Reader reader) throws IOException {
        reader = new BufferedReader(reader);
        return new Parser(reader).parse();
    }

    @Override
    public void serialize(Writer writer) throws IOException {
        this.serialize(writer, false);
    }

    @Override
    public void serialize(Writer writer, boolean verbose) throws IOException {
        writer = new BufferedWriter(writer);
        Serializer serializer = verbose ? new SerializerVerbose(writer) : new Serializer(writer);
        serializer.writeObject(this).flush();
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean verbose) {
        StringWriter writer = new StringWriter();
        try {
            this.serialize(writer, verbose);
        }
        catch (IOException e) {
            return MessageFormat.format("Error serializing JSON object - exception message: {0}", e.getMessage());
        }
        return writer.toString();
    }

    @Override
    public Object put(Object key, Object value) {
        if (key == null) {
            throw new IllegalArgumentException("key must not be null");
        }
        if (!(key instanceof String)) {
            throw new IllegalArgumentException("key must be a String");
        }
        if (!JSONObject.isValidObject(value)) {
            throw new IllegalArgumentException("invalid type of element: " + value.getClass().getName());
        }
        return super.put(key, value);
    }
}

