/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.calm.foundation.common.internal.linking;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.NodeIterator;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.RSIterator;
import com.hp.hpl.jena.rdf.model.ReifiedStatement;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.shared.JenaException;
import com.ibm.team.calm.foundation.common.CustomNamespaceContext;
import com.ibm.team.calm.foundation.common.UnsupportedVersionException;
import com.ibm.team.calm.foundation.common.internal.OSLCResource;
import com.ibm.team.calm.foundation.common.internal.linking.CALMBackLink;
import com.ibm.team.calm.foundation.common.internal.linking.CALMBackLinkOperation;
import com.ibm.team.calm.foundation.common.internal.linking.Messages;
import com.ibm.team.calm.foundation.common.oslc.DublinCoreIdentifiers;
import com.ibm.team.repository.common.TeamRepositoryException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.osgi.util.NLS;

public class CoreBackLinkOperationV2
extends CALMBackLinkOperation {
    private Model fDocument;

    @Override
    public List<CALMBackLink> loadExistingLinks() throws TeamRepositoryException, UnsupportedVersionException {
        ArrayList<CALMBackLink> result = new ArrayList<CALMBackLink>();
        OSLCResource resource = super.loadResource(this.getBackLink().getSourceURL());
        try {
            this.fDocument = ModelFactory.createDefaultModel().read(resource.getContentStream(), resource.getURL());
            Resource source = this.fDocument.getResource(this.getBackLink().getSourceURL());
            Property linkProp = this.fDocument.getProperty(this.getBackLinkElement().getNamespaceURI(), this.getBackLinkElement().getTypeId());
            NodeIterator targets = this.fDocument.listObjectsOfProperty(linkProp);
            try {
                while (targets.hasNext()) {
                    RDFNode cur = targets.next();
                    if (!cur.isResource()) continue;
                    Resource curTarget = cur.asResource();
                    String curLabelText = this.getLinkLabel(source, linkProp, curTarget);
                    result.add(new CALMBackLink(this.getBackLink().getLinkType(), this.getBackLink().getSourceURL(), curTarget.getURI(), curLabelText));
                }
            }
            finally {
                targets.close();
            }
            return result;
        }
        catch (JenaException ex) {
            String message = NLS.bind((String)Messages.getString("CoreBackLinkOperationV2_ERROR_PARSE"), (Object)resource.getURL(), (Object)ex.getMessage());
            throw new TeamRepositoryException(message, (Throwable)ex);
        }
    }

    @Override
    public void storeLinks(List<CALMBackLink> newLinks) throws TeamRepositoryException {
        if (this.fDocument != null && newLinks != null) {
            Property linkProperty = this.fDocument.createProperty(this.getBackLinkElement().getNamespaceURI(), this.getBackLinkElement().getTypeId());
            Resource source = this.fDocument.getResource(this.getBackLink().getSourceURL());
            this.prepareResource(source, linkProperty);
            for (CALMBackLink cur : newLinks) {
                Resource target = this.fDocument.createResource(cur.getTargetURL());
                source.addProperty(linkProperty, (RDFNode)target);
                Statement curLink = this.fDocument.createStatement(source, this.createProperty(this.getBackLinkElement().getNamespaceURI(), this.getBackLinkElement().getTypeId()), (RDFNode)target);
                String labelText = cur.getLinkComment();
                if (labelText == null || labelText.length() <= 0) continue;
                ReifiedStatement curLabel = curLink.createReifiedStatement();
                curLabel.addProperty(this.createProperty(DublinCoreIdentifiers.TITLE.getNamespaceURI(), DublinCoreIdentifiers.TITLE.getName()), labelText);
            }
            this.store(this.fDocument);
        }
    }

    protected void prepareResource(Resource source, Property linkProperty) {
        StmtIterator propIt = source.listProperties(linkProperty);
        try {
            while (propIt.hasNext()) {
                Statement curProp = (Statement)propIt.next();
                RSIterator reifiedIt = curProp.listReifiedStatements();
                try {
                    while (reifiedIt.hasNext()) {
                        ReifiedStatement curReified = (ReifiedStatement)reifiedIt.next();
                        curReified.removeProperties();
                    }
                }
                finally {
                    reifiedIt.close();
                }
                curProp.removeReification();
                propIt.remove();
            }
        }
        finally {
            propIt.close();
        }
    }

    protected void store(Model document) throws TeamRepositoryException {
        super.storeResource(this.writeToString(document));
    }

    /*
     * Exception decompiling
     */
    private String getLinkLabel(Resource source, Property linkProperty, Resource target) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 7[DOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private Property createProperty(String nsUri, String localName) {
        CustomNamespaceContext nsContext = this.getNamespaces();
        if (this.fDocument.getNsURIPrefix(nsUri) == null && nsContext.contains(nsUri)) {
            this.fDocument.setNsPrefix(nsContext.getPrefix(nsUri), nsUri);
        }
        return this.fDocument.createProperty(nsUri, localName);
    }

    private String writeToString(Model document) {
        StringWriter result = new StringWriter();
        document.write((Writer)result);
        return result.getBuffer().toString();
    }

    @Override
    public CALMBackLinkOperation clone() {
        CoreBackLinkOperationV2 result = new CoreBackLinkOperationV2();
        result.setVersion(this.getVersion());
        result.setContentType(this.getContentType());
        result.setElementName(this.getElementName());
        result.setHttpHeaders(this.getHttpHeaders());
        return result;
    }
}

