/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.calm.foundation.common.linking;

import com.ibm.team.calm.foundation.common.CALMDocument;
import com.ibm.team.calm.foundation.common.HttpHeaders;
import com.ibm.team.calm.foundation.common.IHttpClient;
import com.ibm.team.calm.foundation.common.ServiceProvider;
import com.ibm.team.calm.foundation.common.internal.Messages;
import com.ibm.team.calm.foundation.common.linking.CALMLinkTypeInformation;
import com.ibm.team.calm.foundation.common.linking.FilterDescription;
import com.ibm.team.calm.foundation.common.linking.IProjectLinkingContext;
import com.ibm.team.calm.foundation.common.linking.OSLCResourceDescription;
import com.ibm.team.repository.common.InternalRepositoryException;
import com.ibm.team.repository.common.NotLoggedInException;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.transport.HttpUtil;
import com.ibm.team.repository.common.transport.UriUtil;
import java.io.IOException;
import java.io.Reader;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public final class CALMFilterOperation {
    private final IHttpClient fHttpClient;
    private final IProjectLinkingContext fLinkingContext;

    public static final CALMFilterOperation create(IHttpClient client, IProjectLinkingContext linkingContext) {
        return new CALMFilterOperation(client, linkingContext);
    }

    private CALMFilterOperation(IHttpClient client, IProjectLinkingContext linkingContext) {
        this.fHttpClient = client;
        this.fLinkingContext = linkingContext;
    }

    private List<FilterDescription> getFilterURLs(CALMLinkTypeInformation linkType, String filterId, Collection<String> resource, MultiStatus status) throws TeamRepositoryException {
        Collection<ServiceProvider> serviceProviders = linkType.getServiceProviders(this.fLinkingContext);
        ArrayList<FilterDescription> result = new ArrayList<FilterDescription>(serviceProviders.size());
        for (ServiceProvider serviceProvider : serviceProviders) {
            String message;
            String serviceURL = serviceProvider.getProviderServiceUrl();
            try {
                OSLCResourceDescription resourceDescription = serviceProvider.getLinkTypeInfo().getTargetResourceDescription();
                OSLCResourceDescription.ServiceDocument serviceDocument = resourceDescription.loadServiceDocument(serviceURL, this.fHttpClient);
                List<FilterDescription> filterDescription = serviceDocument.getFilterDescription(filterId);
                if (!filterDescription.isEmpty()) {
                    result.add(filterDescription.get(0));
                    continue;
                }
                throw new InternalRepositoryException(MessageFormat.format(Messages.getString("CALMFilterOperation.error_no_filter"), filterId, serviceURL));
            }
            catch (CALMDocument.DocumentParseException e) {
                message = Messages.getString("CALMFilterOperation.error_reading_filter_url");
                status.add((IStatus)new Status(4, "com.ibm.team.calm.foundation.common", message, (Throwable)((Object)e)));
            }
            catch (NotLoggedInException e) {
                throw e;
            }
            catch (TeamRepositoryException e) {
                message = NLS.bind((String)Messages.getString("CALMFilterOperation.error_access_service_document"), (Object)serviceURL);
                status.add((IStatus)new Status(4, "com.ibm.team.calm.foundation.common", message, (Throwable)e));
            }
        }
        return result;
    }

    public Collection<String> performCalmFilter(CALMLinkTypeInformation linkType, String filterId, Collection<String> inputResourceURLs, MultiStatus status) throws TeamRepositoryException {
        List<FilterDescription> filterDescriptions = this.getFilterURLs(linkType, filterId, inputResourceURLs, status);
        StringBuilder params = new StringBuilder("oslc_cm.properties=x");
        for (String resourceURL : inputResourceURLs) {
            params.append("&item=").append(UriUtil.encode((String)resourceURL));
        }
        HashSet<String> result = new HashSet<String>();
        for (FilterDescription filterDescription : filterDescriptions) {
            try {
                Reader reader;
                HttpHeaders headers = new HttpHeaders();
                headers.addHeader("Accept", HttpUtil.MediaType.APP.toString());
                IHttpClient.IResponse response = this.fHttpClient.performGetWithExtraParameters(filterDescription.getFilterURL(), params.toString(), HttpUtil.MediaType.FORM_URLENCODED.toString(), headers);
                if (response == null || (reader = response.getResponseReader()) == null) continue;
                this.parseAtomFeed(reader, result);
            }
            catch (NotLoggedInException e) {
                throw e;
            }
            catch (TeamRepositoryException e) {
                String message = NLS.bind((String)Messages.getString("CALMFilterOperation.error_accessing_filter"), (Object)filterDescription.getFilterURL());
                status.add((IStatus)new Status(4, "com.ibm.team.calm.foundation.common", message, (Throwable)e));
            }
        }
        return result;
    }

    private void parseAtomFeed(Reader reader, final Collection<String> result) throws TeamRepositoryException {
        try {
            try {
                DefaultHandler handler = new DefaultHandler(){

                    @Override
                    public void startElement(String uri, String localName, String qName, Attributes attributes) {
                        if ("link".equals(localName) && "via".equals(attributes.getValue("rel"))) {
                            String value = attributes.getValue("href");
                            result.add(value);
                        }
                    }
                };
                SAXParserFactory factory = SAXParserFactory.newInstance();
                factory.setNamespaceAware(true);
                SAXParser saxParser = factory.newSAXParser();
                saxParser.getXMLReader().setContentHandler(handler);
                saxParser.getXMLReader().setErrorHandler(handler);
                XMLReader xmlReader = saxParser.getXMLReader();
                xmlReader.parse(new InputSource(reader));
            }
            catch (IOException e) {
                throw new InternalRepositoryException(Messages.getString("CALMFilterOperation.error_parsing_filter_result"), (Throwable)e);
            }
            catch (SAXException e) {
                throw new InternalRepositoryException(Messages.getString("CALMFilterOperation.error_parsing_filter_result"), (Throwable)e);
            }
            catch (ParserConfigurationException e) {
                throw new InternalRepositoryException(Messages.getString("CALMFilterOperation.error_parsing_filter_result"), (Throwable)e);
            }
        }
        catch (Throwable throwable) {
            try {
                reader.close();
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            reader.close();
        }
        catch (IOException iOException) {}
    }

    public boolean hasServiceProvider(CALMLinkTypeInformation linkType) throws TeamRepositoryException {
        return !linkType.getServiceProviders(this.fLinkingContext).isEmpty();
    }
}

