/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.nio.params;

import org.apache.http.nio.params.NIOReactorPNames;
import org.apache.http.params.HttpParams;

public final class NIOReactorParams
implements NIOReactorPNames {
    private NIOReactorParams() {
    }

    public static int getContentBufferSize(HttpParams params) {
        if (params == null) {
            throw new IllegalArgumentException("HTTP parameters may not be null");
        }
        return params.getIntParameter("http.nio.content-buffer-size", 4096);
    }

    public static void setContentBufferSize(HttpParams params, int size) {
        if (params == null) {
            throw new IllegalArgumentException("HTTP parameters may not be null");
        }
        params.setIntParameter("http.nio.content-buffer-size", size);
    }

    public static long getSelectInterval(HttpParams params) {
        if (params == null) {
            throw new IllegalArgumentException("HTTP parameters may not be null");
        }
        return params.getLongParameter("http.nio.select-interval", 1000L);
    }

    public static void setSelectInterval(HttpParams params, long ms) {
        if (params == null) {
            throw new IllegalArgumentException("HTTP parameters may not be null");
        }
        params.setLongParameter("http.nio.select-interval", ms);
    }

    public static long getGracePeriod(HttpParams params) {
        if (params == null) {
            throw new IllegalArgumentException("HTTP parameters may not be null");
        }
        return params.getLongParameter("http.nio.grace-period", 500L);
    }

    public static void setGracePeriod(HttpParams params, long ms) {
        if (params == null) {
            throw new IllegalArgumentException("HTTP parameters may not be null");
        }
        params.setLongParameter("http.nio.grace-period", ms);
    }

    public static boolean getInterestOpsQueueing(HttpParams params) {
        if (params == null) {
            throw new IllegalArgumentException("HTTP parameters may not be null");
        }
        return params.getBooleanParameter("http.nio.interest-ops-queueing", false);
    }

    public static void setInterestOpsQueueing(HttpParams params, boolean interestOpsQueueing) {
        if (params == null) {
            throw new IllegalArgumentException("HTTP parameters may not be null");
        }
        params.setBooleanParameter("http.nio.interest-ops-queueing", interestOpsQueueing);
    }
}

