/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wink.common.internal.providers.header;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Pattern;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.ext.RuntimeDelegate;
import org.apache.wink.common.internal.i18n.Messages;
import org.apache.wink.common.internal.utils.SoftConcurrentMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MediaTypeHeaderDelegate
implements RuntimeDelegate.HeaderDelegate<MediaType> {
    private static final Logger logger = LoggerFactory.getLogger(MediaTypeHeaderDelegate.class);
    private static final Pattern EQUALS = Pattern.compile("=");
    private static final Pattern SEMICOLON = Pattern.compile(";");
    private static final Pattern SLASH = Pattern.compile("/");
    private static final SoftConcurrentMap<String, MediaType> cache = new SoftConcurrentMap();

    @Override
    public MediaType fromString(String value) throws IllegalArgumentException {
        if (value == null) {
            throw new IllegalArgumentException(Messages.getMessage("mediaTypeHeaderNull"));
        }
        MediaType cached = cache.get(value);
        if (cached != null) {
            return cached;
        }
        String type = "*";
        String subType = "*";
        LinkedHashMap<String, String> paramsMap = null;
        String[] all = SEMICOLON.split(value);
        try {
            String main = all[0];
            String[] mainArray = SLASH.split(main);
            type = mainArray[0];
            if ("".equals(type)) {
                String errMsg = Messages.getMessage("mediaTypeWrongFormat", value);
                logger.error(errMsg);
                throw new IllegalArgumentException(errMsg);
            }
            subType = mainArray.length == 1 && "*".equals(type) ? "*" : mainArray[1];
            if (all.length > 1) {
                paramsMap = new LinkedHashMap<String, String>();
                for (int i = 1; i < all.length; ++i) {
                    String[] param;
                    if (all[i] == null || all[i].trim().length() <= 0 || (param = EQUALS.split(all[i])).length != 2) continue;
                    paramsMap.put(param[0].trim(), param[1].trim());
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            String errMsg = Messages.getMessage("mediaTypeWrongFormat", value);
            logger.error(errMsg, e);
            throw new IllegalArgumentException(errMsg, e);
        }
        return cache.put(value, new MediaType(type, subType, paramsMap));
    }

    @Override
    public String toString(MediaType value) {
        if (value == null) {
            throw new IllegalArgumentException(Messages.getMessage("mediaTypeHeaderNull"));
        }
        StringBuilder result = new StringBuilder();
        result.append(value.getType()).append("/").append(value.getSubtype());
        Map<String, String> params = value.getParameters();
        for (String key : params.keySet()) {
            result.append(";").append(key).append("=").append(params.get(key));
        }
        return result.toString();
    }
}

