/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.common.expression;

import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.json.JSONObject;
import com.ibm.team.workitem.common.expression.Expression;
import com.ibm.team.workitem.common.expression.ExpressionVisitor;
import com.ibm.team.workitem.common.expression.ProgressExpressionVisitor;
import com.ibm.team.workitem.common.expression.SerializationException;
import com.ibm.team.workitem.common.internal.expression.AbstractSimilarityExpression;
import com.ibm.team.workitem.common.internal.expression.IPersistableElement;
import com.ibm.team.workitem.common.internal.expression.ISerializationContext;
import com.ibm.team.workitem.common.model.IWorkItemHandle;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;

public class WorkItemExpression
extends AbstractSimilarityExpression {
    private static final long serialVersionUID = 1L;
    private IWorkItemHandle fWorkItem;

    public WorkItemExpression(IWorkItemHandle workItem) {
        Assert.isNotNull((Object)workItem);
        this.fWorkItem = workItem;
    }

    public WorkItemExpression() {
    }

    public IItemHandle getItemHandle() {
        return this.fWorkItem;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof WorkItemExpression)) {
            return false;
        }
        WorkItemExpression expr = (WorkItemExpression)obj;
        return this.fWorkItem.getItemId().equals((Object)expr.fWorkItem.getItemId());
    }

    public int hashCode() {
        return this.fWorkItem.getItemId().hashCode();
    }

    @Override
    public void init(IPersistableElement element, ISerializationContext context) throws SerializationException {
        UUID itemId = UUID.valueOf((String)element.getAttribute("itemId"));
        this.fWorkItem = this.createHandle(context, itemId);
    }

    @Override
    public void saveState(IPersistableElement element) throws SerializationException {
        IPersistableElement similarItem = element.createChild("similarItem");
        similarItem.setAttribute("itemId", this.fWorkItem.getItemId().getUuidValue());
    }

    @Override
    public void accept(ExpressionVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public void accept(ProgressExpressionVisitor visitor, IProgressMonitor monitor) throws TeamRepositoryException {
        visitor.visit(this, monitor);
    }

    @Override
    public Expression copy() {
        return new WorkItemExpression(this.fWorkItem);
    }

    @Override
    public JSONObject toJson() {
        JSONObject result = new JSONObject();
        if (this.fWorkItem != null) {
            result.put((Object)AbstractSimilarityExpression.Identifiers.itemId.name(), (Object)this.fWorkItem.getItemId().getUuidValue());
        }
        return result;
    }
}

