/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.common.internal;

import com.ibm.team.foundation.common.util.IMemento;
import com.ibm.team.process.common.IProcessConfigurationData;
import com.ibm.team.process.common.IProcessConfigurationElement;
import com.ibm.team.process.common.ModelElement;
import com.ibm.team.workitem.common.model.AttributeIdentifiers;
import java.util.HashMap;
import java.util.Map;

public class Compatibility {
    public static String CONFIGURATION_DATA_POINT = "com.ibm.team.workitem.configuration.compatibility";
    private static final String FEATURE_SET_30 = "featureSet30";
    private static final String ENABLED = "enabled";
    private final Map<String, Boolean> fCompatibilityMap = new HashMap<String, Boolean>();

    public Compatibility(ModelElement element) {
        if (element != null) {
            for (ModelElement child : element.getChildElements()) {
                this.fCompatibilityMap.put(child.getName(), Boolean.valueOf(child.getAttribute(ENABLED)));
            }
        }
    }

    public Compatibility(IProcessConfigurationData element) {
        if (element != null) {
            IProcessConfigurationElement[] iProcessConfigurationElementArray = element.getElements();
            int n = iProcessConfigurationElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                IProcessConfigurationElement child = iProcessConfigurationElementArray[n2];
                this.fCompatibilityMap.put(child.getName(), Boolean.valueOf(child.getAttribute(ENABLED)));
                ++n2;
            }
        }
    }

    public boolean isFeatureSet30Enabled() {
        Boolean enabled = this.fCompatibilityMap.get(FEATURE_SET_30);
        return enabled != null ? enabled : false;
    }

    public void setFeatureSet30Enabled(boolean enabled) {
        this.fCompatibilityMap.put(FEATURE_SET_30, enabled);
    }

    public void saveState(IMemento memento) {
        for (Map.Entry<String, Boolean> entry : this.fCompatibilityMap.entrySet()) {
            IMemento child = memento.createChild(entry.getKey());
            child.putBoolean(ENABLED, entry.getValue().booleanValue());
        }
    }

    public boolean isAttributeSupported(String identifier) {
        if (AttributeIdentifiers.BUILT_IN_3_0.contains(identifier)) {
            return this.isFeatureSet30Enabled();
        }
        return true;
    }
}

