/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.common.internal.attributeValueProviders;

import com.ibm.team.process.common.IProcessArea;
import com.ibm.team.process.common.IProcessAreaHandle;
import com.ibm.team.process.common.IProjectArea;
import com.ibm.team.repository.common.IAuditableHandle;
import com.ibm.team.repository.common.IContributor;
import com.ibm.team.repository.common.IContributorHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.workitem.common.IAuditableCommon;
import com.ibm.team.workitem.common.IAuditableCommonProcess;
import com.ibm.team.workitem.common.IWorkItemCommon;
import com.ibm.team.workitem.common.internal.attributeValueProviders.IConfiguration;
import com.ibm.team.workitem.common.internal.attributeValueProviders.IValueSetProvider;
import com.ibm.team.workitem.common.internal.attributeValueProviders.Messages;
import com.ibm.team.workitem.common.internal.util.ItemHandleAwareHashMap;
import com.ibm.team.workitem.common.internal.util.ItemHandleAwareHashSet;
import com.ibm.team.workitem.common.model.IAttribute;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.common.model.ItemProfile;
import com.ibm.team.workitem.common.model.ItemURI;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;

public class RoleBasedUserProvider
implements IValueSetProvider<IContributor> {
    public static final String PROJECT_AREA = "projectArea";
    public static final String TEAM_AREA = "teamArea";
    public static final String PATH = "path";
    public static final String ROLE = "role";
    public static final String CURRENT_VARIABLE = "${current}";

    @Override
    public List<? extends IContributor> getValueSet(IAttribute attribute, IWorkItem workItem, IWorkItemCommon workItemCommon, IConfiguration configuration, IProgressMonitor monitor) throws TeamRepositoryException {
        ItemHandleAwareHashSet<IContributorHandle> collector = new ItemHandleAwareHashSet<IContributorHandle>();
        IAuditableCommon auditableCommon = workItemCommon.getAuditableCommon();
        IProjectArea projectArea = workItemCommon.getAuditableCommon().resolveAuditable((IAuditableHandle)attribute.getProjectArea(), ItemProfile.PROJECT_AREA_DEFAULT, monitor);
        IAuditableCommonProcess auditableCommonProcess = workItemCommon.getAuditableCommon().getProcess((IProcessAreaHandle)projectArea, monitor);
        ItemHandleAwareHashMap requestedProcessAreaRolesMap = new ItemHandleAwareHashMap();
        List<IConfiguration> projectConfigurations = configuration.getChildren(PROJECT_AREA);
        if (projectConfigurations != null && !projectConfigurations.isEmpty()) {
            HashSet<String> projectAreaRoles = new HashSet<String>();
            requestedProcessAreaRolesMap.put(projectArea, projectAreaRoles);
            for (IConfiguration projectConfiguration : projectConfigurations) {
                projectAreaRoles.add(projectConfiguration.getString(ROLE));
            }
        }
        HashMap<String, IProcessArea> processAreas = new HashMap<String, IProcessArea>();
        for (IConfiguration teamConfiguration : configuration.getChildren(TEAM_AREA)) {
            HashSet<String> processAreaRoles;
            IProcessArea processArea;
            String roleId;
            block12: {
                String processURI = teamConfiguration.getString(PATH);
                roleId = teamConfiguration.getString(ROLE);
                if (CURRENT_VARIABLE.equals(processURI)) {
                    if (workItem == null) continue;
                    IProcessAreaHandle currentProcessAreaHandle = workItemCommon.findProcessArea(workItem, monitor);
                    HashSet<String> currentProcessAreaRoles = (HashSet<String>)requestedProcessAreaRolesMap.get(currentProcessAreaHandle);
                    if (currentProcessAreaRoles == null) {
                        currentProcessAreaRoles = new HashSet<String>();
                        IProcessArea currentProcessArea = auditableCommon.resolveAuditable((IAuditableHandle)currentProcessAreaHandle, ItemProfile.PROCESS_AREA_DEFAULT, monitor);
                        requestedProcessAreaRolesMap.put(currentProcessArea, currentProcessAreaRoles);
                    }
                    currentProcessAreaRoles.add(roleId);
                    continue;
                }
                processArea = (IProcessArea)processAreas.get(processURI);
                if (processArea == null) {
                    try {
                        URI uri = this.createURI(processURI);
                        processArea = auditableCommon.findProcessAreaByURI(uri, ItemProfile.PROCESS_AREA_DEFAULT, monitor);
                        if (processArea != null) {
                            processAreas.put(processURI, processArea);
                            break block12;
                        }
                        throw new IllegalArgumentException(NLS.bind((String)Messages.getString("RoleBasedUserProvider.PROCESS_URI_NOT_FOUND"), (Object)configuration.getIdentifier(), (Object[])new Object[]{attribute.getIdentifier(), processURI}));
                    }
                    catch (URISyntaxException e) {
                        throw new IllegalArgumentException(NLS.bind((String)Messages.getString("RoleBasedUserProvider.INVALID_PROCESS_URI"), (Object)configuration.getIdentifier(), (Object[])new Object[]{attribute.getIdentifier(), processURI}), e);
                    }
                }
            }
            if ((processAreaRoles = (HashSet<String>)requestedProcessAreaRolesMap.get(processArea)) == null) {
                processAreaRoles = new HashSet<String>();
                requestedProcessAreaRolesMap.put(processArea, processAreaRoles);
            }
            processAreaRoles.add(roleId);
        }
        for (IProcessArea processArea : requestedProcessAreaRolesMap.keySet()) {
            this.collectRoles(collector, processArea, (Collection)requestedProcessAreaRolesMap.get(processArea), auditableCommonProcess, monitor);
        }
        if (collector.isEmpty()) {
            return Collections.emptyList();
        }
        return auditableCommon.resolveAuditables(collector.toList(), ItemProfile.CONTRIBUTOR_DEFAULT, monitor);
    }

    private URI createURI(String processURI) throws URISyntaxException {
        Path path = new Path(processURI);
        StringBuilder escaped = new StringBuilder();
        int i = 0;
        while (i < path.segmentCount()) {
            escaped.append(ItemURI.encode(path.segment(i)));
            if (i < path.segmentCount() - 1) {
                escaped.append('/');
            }
            ++i;
        }
        return new URI(escaped.toString());
    }

    private void collectRoles(Collection<IContributorHandle> collector, IProcessArea processArea, Collection<String> roleIds, IAuditableCommonProcess auditableCommonProcess, IProgressMonitor monitor) throws TeamRepositoryException {
        IContributorHandle[] users = auditableCommonProcess.getContributorsWithRole(processArea.getMembers(), processArea, roleIds.toArray(new String[roleIds.size()]), monitor);
        if (users != null && users.length > 0) {
            collector.addAll(Arrays.asList(users));
        }
    }
}

