/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.common.internal.attributeValueProviders;

import com.ibm.team.process.common.IAccessGroup;
import com.ibm.team.process.common.IProcessArea;
import com.ibm.team.process.common.IProcessAreaHandle;
import com.ibm.team.process.common.IProjectArea;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.process.internal.common.query.BaseProjectAreaQueryModel;
import com.ibm.team.repository.common.IAuditableHandle;
import com.ibm.team.repository.common.IContext;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.query.IItemQuery;
import com.ibm.team.repository.common.query.ast.IPredicate;
import com.ibm.team.repository.common.query.ast.IQueryModel;
import com.ibm.team.workitem.common.IAuditableCommon;
import com.ibm.team.workitem.common.IWorkItemCommon;
import com.ibm.team.workitem.common.QueryIterator;
import com.ibm.team.workitem.common.internal.attributeValueProviders.IConfiguration;
import com.ibm.team.workitem.common.internal.attributeValueProviders.IDefaultValueProvider;
import com.ibm.team.workitem.common.internal.attributeValueProviders.IValueSetProvider;
import com.ibm.team.workitem.common.internal.util.AuditablesHelper;
import com.ibm.team.workitem.common.model.IAttribute;
import com.ibm.team.workitem.common.model.ICategory;
import com.ibm.team.workitem.common.model.ICategoryHandle;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.common.model.ItemProfile;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;

public class SecurityContextProvider
implements IValueSetProvider<Object>,
IDefaultValueProvider<UUID> {
    private static final ItemProfile<IProcessArea> PROCESS_AREA_SMALL = ItemProfile.createProfile(IProcessArea.ITEM_TYPE, AuditablesHelper.AUDITABLE_SMALL_PROFILE).createExtension(AuditablesHelper.getProcessPropertiesFromIds(IProjectArea.class, "name", "archived"));
    private static final int MAX_NUM_OF_PROJECT_AREAS = 10;
    private static final int MAX_NUM_OF_ACCESS_CONTEXTS = 5;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<? extends Object> getValueSet(IAttribute attribute, IWorkItem workItem, IWorkItemCommon workItemCommon, IConfiguration configuration, IProgressMonitor monitor) throws TeamRepositoryException {
        IAccessGroup[] groups;
        IAuditableCommon auditableCommon = workItemCommon.getAuditableCommon();
        ArrayList<Object> contexts = new ArrayList<Object>();
        boolean currentContextFound = false;
        UUID currentContext = null;
        IProcessArea processArea = null;
        if (workItem != null) {
            currentContext = workItem.getContextId();
            IProcessAreaHandle defaultContext = this.getDefaultContext(workItem, workItemCommon, monitor);
            processArea = auditableCommon.resolveAuditable((IAuditableHandle)defaultContext, PROCESS_AREA_SMALL, null);
            contexts.add(processArea);
            currentContextFound |= processArea.getItemId().equals((Object)currentContext);
        }
        contexts.add(IContext.PUBLIC);
        currentContextFound |= IContext.PUBLIC.equals((Object)currentContext);
        BaseProjectAreaQueryModel.ProjectAreaQueryModel model = BaseProjectAreaQueryModel.ProjectAreaQueryModel.ROOT;
        IItemQuery query = (IItemQuery)IItemQuery.FACTORY.newInstance((IQueryModel)model);
        IPredicate predicate = model.archived()._isFalse()._and(model.isInitialized()._isTrue());
        query.filter(predicate);
        query.setResultLimit(10);
        QueryIterator queryIterator = auditableCommon.getItemQueryIterator(query, null, null, null);
        ArrayList<IProjectAreaHandle> projectAreaHandles = new ArrayList<IProjectAreaHandle>();
        int i = 10;
        try {
            while (i > 0 && queryIterator.hasNext(monitor)) {
                IProjectAreaHandle handle = (IProjectAreaHandle)queryIterator.next(monitor);
                if (processArea != null && handle.getItemId().equals((Object)processArea.getItemId())) continue;
                projectAreaHandles.add(handle);
                --i;
            }
        }
        finally {
            queryIterator.close();
        }
        List<IProcessArea> projectAreas = auditableCommon.resolveAuditables(projectAreaHandles, PROCESS_AREA_SMALL, null);
        for (IProcessArea projectArea : projectAreas) {
            contexts.add(projectArea);
            currentContextFound |= projectArea.getItemId().equals((Object)currentContext);
        }
        IAccessGroup[] iAccessGroupArray = groups = auditableCommon.getAccessGroups(null, 5, monitor);
        int n = groups.length;
        int n2 = 0;
        while (n2 < n) {
            IAccessGroup group = iAccessGroupArray[n2];
            contexts.add(group);
            currentContextFound |= group.getContextId().equals((Object)currentContext);
            ++n2;
        }
        if (!currentContextFound && currentContext != null) {
            contexts.add(auditableCommon.resolveAccessContext(currentContext, monitor));
        }
        return contexts;
    }

    @Override
    public UUID getDefaultValue(IAttribute attribute, IWorkItem workItem, IWorkItemCommon workItemCommon, IConfiguration configuration, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.getDefaultContext(workItem, workItemCommon, monitor).getItemId();
    }

    private IProcessAreaHandle getDefaultContext(IWorkItem workItem, IWorkItemCommon workItemCommon, IProgressMonitor monitor) throws TeamRepositoryException {
        IProcessAreaHandle processAreaHandle;
        ICategory category;
        ICategoryHandle categoryHandle;
        ItemProfile profile = ItemProfile.createProfile(IWorkItem.ITEM_TYPE, IWorkItem.CATEGORY_PROPERTY, IWorkItem.PROJECT_AREA_PROPERTY);
        if (!profile.isMatched(workItem)) {
            workItem = (IWorkItem)workItemCommon.getAuditableCommon().resolveAuditable(workItem, profile, null);
        }
        if ((categoryHandle = workItem.getCategory()) != null && (category = workItemCommon.getAuditableCommon().resolveAuditable(categoryHandle, ICategory.DEFAULT_PROFILE, null)).isReadAccessEnabled() && (processAreaHandle = workItemCommon.findProcessArea(workItem, null)) != null) {
            return processAreaHandle;
        }
        return workItem.getProjectArea();
    }
}

