/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.common.internal.emailtemplates;

import com.ibm.team.repository.common.IContributorHandle;
import com.ibm.team.workitem.common.internal.emailtemplates.Recipient;
import com.ibm.team.workitem.common.internal.rcp.dto.MailTemplateTestDTO;
import com.ibm.team.workitem.common.internal.rcp.dto.RcpFactory;
import com.ibm.team.workitem.common.internal.util.EMFHelper;
import com.ibm.team.workitem.common.model.IWorkItemHandle;

public class TemplateTestInstance {
    private IWorkItemHandle fWorkItem;
    private IContributorHandle fRecipient;
    private Recipient.Relation fRecipientRelation;
    private IContributorHandle fModifier;
    private String fTemplateID;
    private String fTemplate;
    private ChangeEventType fChangeEvent;
    private boolean fHTML;

    public IWorkItemHandle getWorkItem() {
        return this.fWorkItem;
    }

    public void setWorkItem(IWorkItemHandle workItem) {
        this.fWorkItem = workItem;
    }

    public IContributorHandle getRecipient() {
        return this.fRecipient;
    }

    public void setRecipient(IContributorHandle recipient) {
        this.fRecipient = recipient;
    }

    public Recipient.Relation getRecipientRelation() {
        return this.fRecipientRelation;
    }

    public void setRecipientRelation(Recipient.Relation recipientRelation) {
        this.fRecipientRelation = recipientRelation;
    }

    public IContributorHandle getModifier() {
        return this.fModifier;
    }

    public void setModifier(IContributorHandle modifier) {
        this.fModifier = modifier;
    }

    public String getTemplateID() {
        return this.fTemplateID;
    }

    public void setTemplateID(String templateID) {
        this.fTemplateID = templateID;
    }

    public String getTemplate() {
        return this.fTemplate;
    }

    public void setTemplate(String template) {
        this.fTemplate = template;
    }

    public ChangeEventType getChangeEvent() {
        return this.fChangeEvent;
    }

    public void setChangeEvent(ChangeEventType changeEvent) {
        this.fChangeEvent = changeEvent;
    }

    public boolean isHTML() {
        return this.fHTML;
    }

    public void setHTML(boolean hTML) {
        this.fHTML = hTML;
    }

    public MailTemplateTestDTO toDTO() {
        MailTemplateTestDTO dto = RcpFactory.eINSTANCE.createMailTemplateTestDTO();
        dto.setWorkItem((IWorkItemHandle)EMFHelper.copy(this.fWorkItem));
        dto.setModifier((IContributorHandle)EMFHelper.copy(this.fModifier));
        dto.setRecipient((IContributorHandle)EMFHelper.copy(this.fRecipient));
        dto.setRecipientRelation(this.fRecipientRelation.name());
        if (this.fChangeEvent != null) {
            dto.setChangeEventType(this.fChangeEvent.name());
        }
        dto.setTemplateID(this.fTemplateID);
        dto.setTemplate(this.fTemplate);
        dto.setHTML(this.fHTML);
        return dto;
    }

    public static TemplateTestInstance fromDTO(MailTemplateTestDTO dto) {
        TemplateTestInstance testInstance = new TemplateTestInstance();
        testInstance.fWorkItem = dto.getWorkItem();
        testInstance.fRecipient = dto.getRecipient();
        testInstance.fRecipientRelation = Recipient.Relation.valueOf(Recipient.Relation.class, dto.getRecipientRelation());
        testInstance.fModifier = dto.getModifier();
        testInstance.fTemplateID = dto.getTemplateID();
        testInstance.fTemplate = dto.getTemplate();
        testInstance.fHTML = dto.isHTML();
        if (dto.getChangeEventType() != null) {
            testInstance.fChangeEvent = ChangeEventType.valueOf(ChangeEventType.class, dto.getChangeEventType());
        }
        return testInstance;
    }

    public static enum ChangeEventType {
        WORKITEM_CREATION,
        WORKITEM_CHANGED,
        WORKITEM_NEW_COMMENTS;

    }
}

