/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.common.internal.expression;

import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.workitem.common.expression.AttributeExpression;
import com.ibm.team.workitem.common.expression.Expression;
import com.ibm.team.workitem.common.expression.IQueryableAttribute;
import com.ibm.team.workitem.common.expression.IQueryableAttributeFactory;
import com.ibm.team.workitem.common.expression.ProgressExpressionVisitor;
import com.ibm.team.workitem.common.expression.QueryableAttributes;
import com.ibm.team.workitem.common.expression.SelectClause;
import com.ibm.team.workitem.common.expression.SortCriteria;
import com.ibm.team.workitem.common.expression.Term;
import com.ibm.team.workitem.common.expression.variables.IEvaluationContext;
import com.ibm.team.workitem.common.internal.expression.EditableAttributeExpression;
import com.ibm.team.workitem.common.internal.expression.EditableExpression;
import com.ibm.team.workitem.common.internal.expression.EditableSortColumn;
import com.ibm.team.workitem.common.internal.expression.EditableStatement;
import com.ibm.team.workitem.common.internal.expression.EditableTerm;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;

public class CreateEditableStatementVisitor
extends ProgressExpressionVisitor {
    private final IEvaluationContext fContext;
    private EditableStatement fEditableStatement;
    private EditableTerm fCurrentTerm;
    private List<IQueryableAttribute> fColumns;
    private List<EditableSortColumn> fSortColumns;

    public CreateEditableStatementVisitor(IEvaluationContext context) {
        this.fContext = context;
        this.fColumns = new ArrayList<IQueryableAttribute>();
        this.fSortColumns = new ArrayList<EditableSortColumn>();
    }

    public EditableStatement getEditableStatement() {
        if (this.fEditableStatement == null && this.fCurrentTerm != null) {
            this.fEditableStatement = new EditableStatement(this.fCurrentTerm);
            if (this.fEditableStatement.getLogicalRoot() == null) {
                EditableTerm logicalRoot = new EditableTerm(Term.Operator.AND);
                this.fEditableStatement.getRoot().add(logicalRoot);
            }
            this.fEditableStatement.addColumns(this.fColumns);
            this.fEditableStatement.addSortColumns(this.fSortColumns);
        }
        return this.fEditableStatement;
    }

    private IQueryableAttribute resolveAttribute(AttributeExpression expression, IProgressMonitor monitor) throws TeamRepositoryException {
        return expression.getAttribute(this.fContext, monitor);
    }

    @Override
    public boolean visit(Term term, IProgressMonitor monitor) throws TeamRepositoryException {
        CandidateHelper helper = new CandidateHelper();
        for (Expression expression : term.getExpressions()) {
            if (!(expression instanceof AttributeExpression)) continue;
            helper.addCandidate((AttributeExpression)expression);
        }
        ArrayList<EditableAttributeExpression> editableExpressions = new ArrayList<EditableAttributeExpression>();
        for (List<AttributeExpression> candidateList : helper.getAttributeCandidates()) {
            if (candidateList.isEmpty()) continue;
            AttributeExpression attributeExpression = candidateList.get(0);
            IQueryableAttribute attribute = this.resolveAttribute(attributeExpression, monitor);
            EditableAttributeExpression editableAttributeExpression = new EditableAttributeExpression(attribute, attributeExpression.getOperation());
            for (AttributeExpression candidate : candidateList) {
                editableAttributeExpression.addValue(candidate.getValue());
            }
            editableExpressions.add(editableAttributeExpression);
        }
        EditableTerm oldTerm = this.fCurrentTerm;
        if (this.isMultiValueTerm(term, editableExpressions) && !this.isLogicalRootContainer(oldTerm)) {
            Assert.isNotNull((Object)oldTerm);
            oldTerm.add(editableExpressions.get(0));
        } else {
            EditableTerm newTerm = new EditableTerm(term.getOperator());
            newTerm.setInternal(term.isInternal());
            for (EditableExpression editableExpression : editableExpressions) {
                newTerm.add(editableExpression);
            }
            if (oldTerm == null) {
                oldTerm = newTerm;
            } else {
                oldTerm.add(newTerm);
            }
            this.fCurrentTerm = newTerm;
        }
        for (Expression expression : term.getExpressions()) {
            expression.accept(this, monitor);
        }
        this.fCurrentTerm = oldTerm;
        return false;
    }

    private boolean isLogicalRootContainer(EditableTerm term) {
        if (term == null) {
            return true;
        }
        return term.getParent() == null;
    }

    @Override
    public boolean visit(SelectClause selectClause, IProgressMonitor monitor) throws TeamRepositoryException {
        IQueryableAttributeFactory factory = QueryableAttributes.getFactory(selectClause.getItemType());
        for (String identifier : selectClause.getColumnIdentifiers()) {
            IQueryableAttribute attribute = factory.findAttribute(this.fContext.getProjectArea(), identifier, this.fContext.getAuditableCommon(), monitor);
            if (attribute == null) continue;
            this.fColumns.add(attribute);
        }
        return super.visit(selectClause, monitor);
    }

    @Override
    public boolean visit(SortCriteria sortCriteria, IProgressMonitor monitor) throws TeamRepositoryException {
        IQueryableAttribute attribute = sortCriteria.getAttribute(this.fContext, monitor);
        if (attribute != null) {
            EditableSortColumn.Direction direction = sortCriteria.isAscending() ? EditableSortColumn.Direction.ASCENDING : EditableSortColumn.Direction.DESCENDING;
            this.fSortColumns.add(new EditableSortColumn(attribute, direction));
        }
        return super.visit(sortCriteria, monitor);
    }

    private boolean isMultiValueTerm(Term term, ArrayList<EditableAttributeExpression> editableExpressions) {
        return editableExpressions.size() == 1 && editableExpressions.get(0).getValues().size() == term.getExpressions().size();
    }

    private class CandidateHelper {
        private HashMap<String, List<AttributeExpression>> fAttributeCandidates = new HashMap();

        private CandidateHelper() {
        }

        public void addCandidate(AttributeExpression expression) throws TeamRepositoryException {
            this.addToAttributeCandidates(expression);
        }

        public Collection<List<AttributeExpression>> getAttributeCandidates() {
            return this.fAttributeCandidates.values();
        }

        private void addToAttributeCandidates(AttributeExpression expression) {
            String key = this.getAttributeKey(expression);
            List<AttributeExpression> attributeCandidates = this.fAttributeCandidates.get(key);
            if (attributeCandidates == null) {
                attributeCandidates = new ArrayList<AttributeExpression>(1);
                this.fAttributeCandidates.put(key, attributeCandidates);
            }
            attributeCandidates.add(expression);
        }

        private String getAttributeKey(AttributeExpression expression) {
            return String.valueOf(expression.getAttributeIdentifier()) + " " + expression.getOperation().getIdentifier();
        }
    }
}

