/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.common.internal.expression;

import com.ibm.team.workitem.common.expression.Expression;
import com.ibm.team.workitem.common.expression.ExpressionChangeEvent;
import com.ibm.team.workitem.common.expression.Term;
import com.ibm.team.workitem.common.internal.expression.EditableExpression;
import com.ibm.team.workitem.common.internal.expression.EditableStatement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class EditableTerm
extends EditableExpression {
    private Term.Operator fOperator;
    private ArrayList<EditableExpression> fExpressions;

    public EditableTerm(Term.Operator operator) {
        this.fOperator = operator;
        this.fExpressions = new ArrayList();
    }

    public void setOperator(Term.Operator operator) {
        this.fOperator = operator;
        this.notify(ExpressionChangeEvent.Type.TERM_OPERATOR_CHANGED);
    }

    public Term.Operator getOperator() {
        return this.fOperator;
    }

    public List<EditableExpression> getExpressions() {
        return Collections.unmodifiableList(this.fExpressions);
    }

    public void add(EditableExpression expression) {
        this.initialize(expression);
        this.fExpressions.add(expression);
        this.notify(ExpressionChangeEvent.Type.TERM_CONDITION_ADDED, expression);
    }

    public void add(EditableExpression expression, EditableExpression afterExpression) {
        int index = this.fExpressions.indexOf(afterExpression);
        if (index == -1) {
            this.add(expression);
            return;
        }
        this.initialize(expression);
        this.fExpressions.add(index + 1, expression);
        this.notify(ExpressionChangeEvent.Type.TERM_CONDITION_ADDED, expression);
    }

    private void initialize(EditableExpression expression) {
        if (expression.getParent() != this) {
            expression.remove();
            expression.addToTree(this, this.getStatement());
        }
    }

    public void remove(EditableExpression expression) {
        this.fExpressions.remove(expression);
        this.notify(ExpressionChangeEvent.Type.TERM_CONDITION_REMOVED, expression);
        expression.removeFromTree();
    }

    public void removeAllExpressions() {
        this.fExpressions.clear();
        this.notify(ExpressionChangeEvent.Type.TERM_CLEARED);
        for (EditableExpression expression : this.fExpressions) {
            expression.removeFromTree();
        }
    }

    public EditableExpression getPredecessor(EditableExpression expression) {
        EditableExpression predecessor = null;
        for (EditableExpression child : this.fExpressions) {
            if (expression == child) break;
            predecessor = child;
        }
        return predecessor;
    }

    @Override
    void addToTree(EditableTerm parent, EditableStatement statement) {
        super.addToTree(parent, statement);
        for (EditableExpression child : this.getExpressions()) {
            child.addToTree(this, statement);
        }
    }

    @Override
    public Expression createExpression() {
        Term term = new Term(this.getOperator(), null);
        term.setInternal(this.isInternal());
        for (EditableExpression editable : this.fExpressions) {
            Expression expression = editable.createExpression();
            if (expression == null) continue;
            term.add(expression);
        }
        return term.getExpressions().isEmpty() ? null : term;
    }
}

