/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.common.internal.expression;

import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.UUID;
import java.util.HashMap;
import java.util.Map;

public class Scores {
    private final Map<UUID, Double> fScores = new HashMap<UUID, Double>();
    private int fRawTotal = -1;

    public void add(IItemHandle handle, double score) {
        UUID itemId = handle.getItemId();
        Double existing = this.fScores.get(itemId);
        if (existing != null) {
            this.fScores.put(itemId, Math.max(existing, score));
        } else {
            this.fScores.put(itemId, score);
        }
    }

    public boolean hasScore(IItemHandle handle) {
        return this.fScores.containsKey(handle.getItemId());
    }

    public double getScore(IItemHandle handle) {
        Double score = this.fScores.get(handle.getItemId());
        if (score == null) {
            return 1.0;
        }
        return score;
    }

    public boolean isEmpty() {
        return this.fScores.isEmpty();
    }

    public int getRawTotal() {
        return this.fRawTotal;
    }

    public void setRawTotal(int rawTotal) {
        if (rawTotal > this.fRawTotal) {
            this.fRawTotal = rawTotal;
        }
    }
}

