/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.common.internal.expression;

import com.ibm.team.calm.foundation.common.linking.CALMLinkTypeInformation;
import com.ibm.team.calm.foundation.common.linking.CALMLinkTypeInformationRegistry;
import com.ibm.team.links.common.registry.IEndPointDescriptor;
import com.ibm.team.links.common.registry.ILinkType;
import com.ibm.team.links.common.registry.ILinkTypeRegistry;
import com.ibm.team.process.common.IProjectArea;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.process.common.IProjectLink;
import com.ibm.team.repository.common.IAuditableHandle;
import com.ibm.team.repository.common.IContributor;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.workitem.common.IAuditableCommon;
import com.ibm.team.workitem.common.IWorkItemCommon;
import com.ibm.team.workitem.common.expression.IQueryableAttribute;
import com.ibm.team.workitem.common.expression.IQueryableAttributeFactory;
import com.ibm.team.workitem.common.expression.QueryableAttributes;
import com.ibm.team.workitem.common.internal.expression.AbstractQueryableAttribute;
import com.ibm.team.workitem.common.internal.expression.ApprovalDescriptorAttributeDescriptor;
import com.ibm.team.workitem.common.internal.expression.Messages;
import com.ibm.team.workitem.common.internal.expression.QueryableAttribute;
import com.ibm.team.workitem.common.internal.expression.QueryableAttributeDescriptor;
import com.ibm.team.workitem.common.internal.expression.QueryableLinkAttribute;
import com.ibm.team.workitem.common.internal.expression.QueryableWorkItemAttribute;
import com.ibm.team.workitem.common.internal.expression.StateGroupAttributeDescriptor;
import com.ibm.team.workitem.common.internal.expression.TopLevelStateGroupAttributeDescriptor;
import com.ibm.team.workitem.common.internal.model.ModelPackage;
import com.ibm.team.workitem.common.internal.model.WorkItem;
import com.ibm.team.workitem.common.internal.query.util.QueryUtils;
import com.ibm.team.workitem.common.internal.util.AuditablesHelper;
import com.ibm.team.workitem.common.internal.util.CacheHelper;
import com.ibm.team.workitem.common.internal.util.CacheState;
import com.ibm.team.workitem.common.internal.util.ItemHandleAwareHashSet;
import com.ibm.team.workitem.common.internal.util.IterationsHelper;
import com.ibm.team.workitem.common.internal.util.LocalizationContext;
import com.ibm.team.workitem.common.internal.util.PublicAttributeHelper;
import com.ibm.team.workitem.common.internal.util.QueryableAttributePath;
import com.ibm.team.workitem.common.model.AttributeOperation;
import com.ibm.team.workitem.common.model.AttributeType;
import com.ibm.team.workitem.common.model.AttributeTypes;
import com.ibm.team.workitem.common.model.IAttribute;
import com.ibm.team.workitem.common.model.IAttributeHandle;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.common.model.IWorkItemType;
import com.ibm.team.workitem.common.model.ItemProfile;
import com.ibm.team.workitem.common.model.WorkItemLinkTypes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;

public class WorkItemQueryAttributeFactory
extends CacheHelper
implements IQueryableAttributeFactory {
    public static final String COMMENT_CREATOR_PROPERTY = ModelPackage.eINSTANCE.getComment_Creator().getName();
    public static final String APPROVAL_DESC_TYPE_IDENTIFIER_PROPERTY = ModelPackage.eINSTANCE.getApprovalDescriptor_TypeIdentifier().getName();
    public static final String APPROVAL_DESC_CUMULATIVE_STATE_IDENTIFIER_PROPERTY = ModelPackage.eINSTANCE.getApprovalDescriptor_CumulativeStateIdentifier().getName();
    public static final String APPROVAL_DESC_DUE_DATE_PROPERTY = ModelPackage.eINSTANCE.getApprovalDescriptor_DueDate().getName();
    public static final String APPROVAL_DESC_NAME_PROPERTY = ModelPackage.eINSTANCE.getApprovalDescriptor_Name().getName();
    public static final String APPROVAL_STATE_IDENTIFIER_PROPERTY = ModelPackage.eINSTANCE.getApproval_StateIdentifier().getName();
    public static final String APPROVAL_APPROVER_PROPERTY = ModelPackage.eINSTANCE.getApproval_Approver().getName();
    private static Map<String, IItemType> fgItemTypeMap = new HashMap<String, IItemType>();
    private final Map<UUID, Entry> fCache = Collections.synchronizedMap(new HashMap());
    private Set<String> fCacheCustomAttributeIdentifiers = new HashSet<String>();

    static {
        fgItemTypeMap.put("contributor", IContributor.ITEM_TYPE);
        fgItemTypeMap.put("workItem", IWorkItem.ITEM_TYPE);
    }

    public WorkItemQueryAttributeFactory() {
        super(null);
    }

    @Override
    protected CacheState getCacheState(IProjectAreaHandle projectAreaHandle, IAuditableCommon auditableCommon, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.getCombinedCacheState(this.getCacheStateForProcessConfiguration(projectAreaHandle, auditableCommon, monitor), this.getCacheStateForItemType(IAttribute.ITEM_TYPE, projectAreaHandle, auditableCommon, monitor));
    }

    @Override
    public IQueryableAttribute findAttribute(IProjectAreaHandle projectArea, String attributeIdentifier, IAuditableCommon auditableCommon, IProgressMonitor monitor) throws TeamRepositoryException {
        this.checkCache(projectArea, auditableCommon, monitor);
        Entry entry = this.fCache.get(projectArea.getItemId());
        IQueryableAttribute cached = entry.attributeMap.get(attributeIdentifier);
        if (cached == null) {
            String[] path = QueryableAttributePath.createPath(attributeIdentifier);
            IWorkItemCommon workItemCommon = auditableCommon.getPeer(IWorkItemCommon.class);
            IAttribute attribute = workItemCommon.findAttribute(projectArea, path[0], monitor);
            if (attribute != null && PublicAttributeHelper.isPublic(attribute)) {
                QueryableWorkItemAttribute workItemAttribute = new QueryableWorkItemAttribute(attribute);
                workItemAttribute.setNullValue(this.getNullValue(auditableCommon, monitor, attribute));
                LocalizationContext projectContext = LocalizationContext.createProjectAreaContext(auditableCommon, projectArea, monitor);
                this.createChildAttributes(projectArea, (AbstractQueryableAttribute)workItemAttribute, auditableCommon, projectContext, monitor);
                entry.attributeMap.put(attributeIdentifier, workItemAttribute);
                cached = path.length > 1 ? QueryableAttributePath.getAttribute(workItemAttribute, QueryableAttributePath.removeFirstSegment(path)) : workItemAttribute;
            }
        }
        return cached;
    }

    @Override
    public List<IQueryableAttribute> findAllAttributes(IProjectAreaHandle projectArea, IAuditableCommon auditableCommon, IProgressMonitor monitor) throws TeamRepositoryException {
        this.checkCache(projectArea, auditableCommon, monitor);
        Entry entry = this.fCache.get(projectArea.getItemId());
        return new ArrayList<IQueryableAttribute>(entry.attributes);
    }

    @Override
    protected void updateCache(IProjectAreaHandle projectAreaHandle, IAuditableCommon auditableCommon, IProgressMonitor monitor) throws TeamRepositoryException {
        this.cacheCustomAttributesFromWorkitemTypes(projectAreaHandle, auditableCommon);
        IProjectArea projectArea = auditableCommon.resolveAuditable((IAuditableHandle)projectAreaHandle, ItemProfile.PROJECT_AREA_FULL, monitor);
        LocalizationContext projectContext = LocalizationContext.createProjectAreaContext(auditableCommon, projectArea);
        List<IQueryableAttribute> attributes = this.findNonLinkAttributes(projectAreaHandle, auditableCommon, projectContext, monitor);
        List<IProjectLink> activeProjectLinks = auditableCommon.resolveAuditables(Arrays.asList(projectArea.getProjectLinks()), ItemProfile.PROJECT_LINK_DEFAULT, monitor);
        Collection links = ILinkTypeRegistry.INSTANCE.allEntries();
        for (ILinkType linkType : links) {
            IEndPointDescriptor target;
            CALMLinkTypeInformation calmLinkType = CALMLinkTypeInformationRegistry.getLinkTypeInformation((ILinkType)linkType);
            if (calmLinkType != null && !calmLinkType.hasServiceProviders(activeProjectLinks)) continue;
            IEndPointDescriptor source = linkType.getSourceEndPointDescriptor();
            if (this.isSupported(source, target = linkType.getTargetEndPointDescriptor())) {
                attributes.add(new QueryableLinkAttribute(target));
            }
            if (WorkItemLinkTypes.isSymmetric(source) || !this.isSupported(target, source)) continue;
            attributes.add(new QueryableLinkAttribute(source));
        }
        for (IQueryableAttribute attribute : attributes) {
            List<IQueryableAttribute> childAttributes;
            if ("workItem".equals(attribute.getAttributeType())) {
                childAttributes = this.findNonLinkAttributes((IProjectAreaHandle)projectArea, auditableCommon, projectContext, monitor);
                ((AbstractQueryableAttribute)attribute).setChildAttributes(childAttributes);
                continue;
            }
            if (!(attribute instanceof QueryableLinkAttribute)) continue;
            QueryableLinkAttribute linkAttribute = (QueryableLinkAttribute)attribute;
            childAttributes = linkAttribute.getEndPointDescriptor().getReferencedItemType() == IWorkItem.ITEM_TYPE ? this.findNonLinkAttributes((IProjectAreaHandle)projectArea, auditableCommon, projectContext, monitor) : this.createChildAttributes((IProjectAreaHandle)projectArea, (AbstractQueryableAttribute)linkAttribute, linkAttribute.getEndPointDescriptor().getReferencedItemType(), auditableCommon, monitor);
            linkAttribute.setChildAttributes(childAttributes);
        }
        Entry entry = new Entry();
        entry.attributes = attributes;
        entry.attributeMap = this.buildMap(attributes);
        this.fCache.put(projectArea.getItemId(), entry);
    }

    private List<IQueryableAttribute> findNonLinkAttributes(IProjectAreaHandle projectArea, IAuditableCommon auditableCommon, LocalizationContext projectContext, IProgressMonitor monitor) throws TeamRepositoryException {
        ArrayList<IQueryableAttribute> attributes = new ArrayList<IQueryableAttribute>();
        List<IAttribute> workItemAttributes = this.findAttributes(auditableCommon, projectArea, monitor);
        for (IAttribute attribute : workItemAttributes) {
            if (!PublicAttributeHelper.isPublic(attribute)) continue;
            QueryableWorkItemAttribute queryAttribute = new QueryableWorkItemAttribute(attribute);
            queryAttribute.setNullValue(this.getNullValue(auditableCommon, monitor, attribute));
            this.setAttributeArchiveFlag(queryAttribute);
            this.createChildAttributes(projectArea, (AbstractQueryableAttribute)queryAttribute, auditableCommon, projectContext, monitor);
            boolean hasValueSet = false;
            if (AttributeTypes.STRING_TYPES.contains(attribute.getAttributeType()) || attribute.getAttributeType().equals("stringList")) {
                hasValueSet = attribute.hasValueSet(auditableCommon, monitor);
            }
            queryAttribute.setHasValueSet(hasValueSet);
            attributes.add(queryAttribute);
        }
        QueryableAttributeDescriptor[] queryableAttributeDescriptorArray = this.getSyntheticWorkItemAttributesDescriptors(projectContext);
        int n = queryableAttributeDescriptorArray.length;
        int n2 = 0;
        while (n2 < n) {
            QueryableAttributeDescriptor descriptor = queryableAttributeDescriptorArray[n2];
            QueryableAttribute queryAttribute = this.createQueryAttribute(descriptor, auditableCommon, monitor);
            attributes.add(queryAttribute);
            ++n2;
        }
        return attributes;
    }

    private Map<String, IQueryableAttribute> buildMap(List<IQueryableAttribute> attributes) {
        HashMap<String, IQueryableAttribute> map = new HashMap<String, IQueryableAttribute>();
        for (IQueryableAttribute attribute : attributes) {
            this.addToMap(map, attribute);
        }
        return map;
    }

    private void addToMap(Map<String, IQueryableAttribute> map, IQueryableAttribute attribute) {
        String identifier = QueryableAttributePath.createPathString(attribute);
        map.put(identifier, attribute);
        for (IQueryableAttribute child : attribute.getChildAttributes()) {
            Assert.isTrue((child.getParent() == attribute ? 1 : 0) != 0);
            this.addToMap(map, child);
        }
    }

    private Object getNullValue(IAuditableCommon auditableCommon, IProgressMonitor monitor, IAttribute attribute) throws TeamRepositoryException {
        if ("tags".equals(attribute.getAttributeType())) {
            return "";
        }
        return attribute.getNullValue(auditableCommon, monitor);
    }

    private boolean isSupported(IEndPointDescriptor source, IEndPointDescriptor target) {
        return source.getReferencedItemType() == IWorkItem.ITEM_TYPE;
    }

    private List<IAttribute> findAttributes(IAuditableCommon auditableCommon, IProjectAreaHandle projectArea, IProgressMonitor monitor) throws TeamRepositoryException {
        IWorkItemCommon workItemCommon = auditableCommon.getPeer(IWorkItemCommon.class);
        if (projectArea != null) {
            return workItemCommon.findAttributes(projectArea, monitor);
        }
        projectArea = QueryUtils.findSomeProjectArea(auditableCommon, monitor);
        List<IAttributeHandle> attributeHandles = workItemCommon.findBuiltInAttributes(projectArea, monitor);
        return auditableCommon.resolveAuditablesPermissionAware(attributeHandles, IAttribute.FULL_PROFILE, monitor);
    }

    private void createChildAttributes(IProjectAreaHandle projectArea, AbstractQueryableAttribute parent, IAuditableCommon auditableCommon, LocalizationContext projectContext, IProgressMonitor monitor) throws TeamRepositoryException {
        if (parent == null || parent.getAttributeType() == null) {
            return;
        }
        ArrayList<IQueryableAttribute> children = new ArrayList<IQueryableAttribute>();
        QueryableAttributeDescriptor[] descriptors = this.getQueryableAttributeDescriptors(parent.getAttributeType(), projectContext);
        if (descriptors != null) {
            QueryableAttributeDescriptor[] queryableAttributeDescriptorArray = descriptors;
            int n = descriptors.length;
            int n2 = 0;
            while (n2 < n) {
                QueryableAttributeDescriptor descriptor = queryableAttributeDescriptorArray[n2];
                QueryableAttribute childAttribute = this.createQueryAttribute(descriptor, auditableCommon, monitor);
                this.createChildAttributes(projectArea, (AbstractQueryableAttribute)childAttribute, auditableCommon, projectContext, monitor);
                children.add(childAttribute);
                ++n2;
            }
        }
        IItemType itemType = fgItemTypeMap.get(parent.getAttributeType());
        children.addAll(this.createChildAttributes(projectArea, parent, itemType, auditableCommon, monitor));
        parent.setChildAttributes(children);
    }

    private List<IQueryableAttribute> createChildAttributes(IProjectAreaHandle projectArea, AbstractQueryableAttribute parent, IItemType itemType, IAuditableCommon auditableCommon, IProgressMonitor monitor) throws TeamRepositoryException {
        if (parent == null || itemType == null || itemType == IWorkItem.ITEM_TYPE || this.getRecursionCount(parent) > 0) {
            return Collections.emptyList();
        }
        ArrayList<IQueryableAttribute> children = new ArrayList<IQueryableAttribute>();
        IQueryableAttributeFactory factory = QueryableAttributes.getFactory(itemType);
        List<IQueryableAttribute> attributes = factory.findAllAttributes(projectArea, auditableCommon, monitor);
        children.addAll(attributes);
        return children;
    }

    private QueryableAttributeDescriptor[] getSyntheticWorkItemAttributesDescriptors(LocalizationContext projectContext) {
        return new QueryableAttributeDescriptor[]{new QueryableAttributeDescriptor("all", Messages.getString(projectContext, "WorkItemQueryAttributeFactory.FULL_TEXT_PROPERTY"), "string", true, false, new AttributeOperation[]{AttributeOperation.CONTAINS}), new QueryableAttributeDescriptor("score", Messages.getString(projectContext, "WorkItemQueryAttributeFactory.SCORE_PROPERTY"), "float", true, false), new QueryableAttributeDescriptor("teamArea", Messages.getString(projectContext, "WorkItemQueryAttributeFactory.TEAM_AREA_PROPERTY"), "teamArea", true, false), new TopLevelStateGroupAttributeDescriptor("stateGroup", Messages.getString(projectContext, "WorkItemQueryAttributeFactory.STATE_GROUP_PROPERTY")), new StateGroupAttributeDescriptor("stateGroup2", Messages.getString(projectContext, "WorkItemQueryAttributeFactory.STATE_GROUP_PROPERTY2")), new QueryableAttributeDescriptor("com.ibm.team.workitem.internal.categoryRoot", Messages.getString(projectContext, "WorkItemQueryAttributeFactory.CATEGORY_ROOT"), "category", true, false)};
    }

    private QueryableAttributeDescriptor[] getApprovalAttributesDescriptors(LocalizationContext projectContext) {
        return new QueryableAttributeDescriptor[]{new QueryableAttributeDescriptor(APPROVAL_APPROVER_PROPERTY, Messages.getString(projectContext, "WorkItemQueryAttributeFactory.APPROVAL_APPROVER_PROPERTY"), "contributor", false, true), new QueryableAttributeDescriptor(APPROVAL_STATE_IDENTIFIER_PROPERTY, Messages.getString(projectContext, "WorkItemQueryAttributeFactory.APPROVAL_STATE_PROPERTY"), "approvalState")};
    }

    private QueryableAttributeDescriptor[] getApprovalDescriptorAttributesDescriptors(LocalizationContext projectContext) {
        return new QueryableAttributeDescriptor[]{new ApprovalDescriptorAttributeDescriptor(APPROVAL_DESC_CUMULATIVE_STATE_IDENTIFIER_PROPERTY, Messages.getString(projectContext, "WorkItemQueryAttributeFactory.AD_CUMULATIVE_STATE_PROPERTY"), "approvalState"), new ApprovalDescriptorAttributeDescriptor(APPROVAL_DESC_DUE_DATE_PROPERTY, Messages.getString(projectContext, "WorkItemQueryAttributeFactory.AD_DUE_DATE_PROPERTY"), "timestamp", false, true), new ApprovalDescriptorAttributeDescriptor(APPROVAL_DESC_TYPE_IDENTIFIER_PROPERTY, Messages.getString(projectContext, "WorkItemQueryAttributeFactory.AD_TYPE_PROPERTY"), "approvalType"), new ApprovalDescriptorAttributeDescriptor(APPROVAL_DESC_NAME_PROPERTY, Messages.getString(projectContext, "WorkItemQueryAttributeFactory.AD_NAME_PROPERTY"), "smallString")};
    }

    private QueryableAttributeDescriptor[] getCommentsAttributesDescriptors(LocalizationContext projectContext) {
        return new QueryableAttributeDescriptor[]{new QueryableAttributeDescriptor(COMMENT_CREATOR_PROPERTY, Messages.getString(projectContext, "WorkItemQueryAttributeFactory.COMMENT_CREATED_BY_PROPERTY"), "contributor")};
    }

    private QueryableAttributeDescriptor[] getIterationAttributesDescriptors(LocalizationContext projectContext) {
        return new QueryableAttributeDescriptor[]{new QueryableAttributeDescriptor(IterationsHelper.ITERATION_NAME_PROPERTY, Messages.getString(projectContext, "WorkItemQueryAttributeFactory.ITERATION_NAME_PROPERTY"), "smallString"), new QueryableAttributeDescriptor(IterationsHelper.ITERATION_START_DATE_PROPERTY, Messages.getString(projectContext, "WorkItemQueryAttributeFactory.ITERATION_START_DATE_PROPERTY"), "timestamp", false, true), new QueryableAttributeDescriptor(IterationsHelper.ITERATION_END_DATE_PROPERTY, Messages.getString(projectContext, "WorkItemQueryAttributeFactory.ITERATION_END_DATE_PROPERTY"), "timestamp", false, true)};
    }

    private QueryableAttributeDescriptor[] getQueryableAttributeDescriptors(String attributeType, LocalizationContext context) {
        if ("approvals".equals(attributeType)) {
            return this.getApprovalAttributesDescriptors(context);
        }
        if ("approvalDescriptors".equals(attributeType)) {
            return this.getApprovalDescriptorAttributesDescriptors(context);
        }
        if ("comments".equals(attributeType)) {
            return this.getCommentsAttributesDescriptors(context);
        }
        if ("interval".equals(attributeType)) {
            return this.getIterationAttributesDescriptors(context);
        }
        return null;
    }

    private int getRecursionCount(IQueryableAttribute attribute) {
        int count = 0;
        String attributeType = attribute.getAttributeType();
        IQueryableAttribute parent = attribute.getParent();
        while (parent != null) {
            if (parent.getAttributeType().equals(attributeType)) {
                ++count;
            }
            parent = parent.getParent();
        }
        return count;
    }

    private QueryableAttribute createQueryAttribute(QueryableAttributeDescriptor descriptor, IAuditableCommon auditableCommon, IProgressMonitor monitor) throws TeamRepositoryException {
        QueryableAttribute attribute = this.createQueryAttribute(descriptor);
        if (attribute.hasNullValue()) {
            AttributeType type = AttributeTypes.getAttributeType(attribute.getAttributeType());
            attribute.setNullValue(type.getNullValue(auditableCommon, monitor));
        }
        return attribute;
    }

    protected QueryableAttribute createQueryAttribute(QueryableAttributeDescriptor descriptor) {
        return new QueryableAttribute(descriptor);
    }

    public ItemProfile<IWorkItem> computeProfile(List<IQueryableAttribute> attributes) {
        HashSet<String> properties = new HashSet<String>(AuditablesHelper.AUDITABLE_SMALL_PROFILE);
        properties.add(IWorkItem.PROJECT_AREA_PROPERTY);
        properties.add(IWorkItem.WORKFLOW_SURROGATE_PROPERTY);
        properties.add(IWorkItem.ID_PROPERTY);
        properties.add(IWorkItem.STATE_PROPERTY);
        properties.add(IWorkItem.TYPE_PROPERTY);
        properties.add(IWorkItem.DURATION_PROPERTY);
        properties.add(WorkItem.CORRECTED_ESTIMATE_PROPERTY);
        properties.add(WorkItem.TIME_SPENT_PROPERTY);
        boolean hasCustomAttributes = false;
        for (IQueryableAttribute attribute : attributes) {
            if (attribute.isStateExtension()) {
                hasCustomAttributes = true;
            } else if (!attribute.isSynthetic()) {
                properties.add(attribute.getIdentifier());
            }
            if (!attribute.getAttributeType().equals("approvals")) continue;
            properties.add(IWorkItem.APPROVAL_DESCRIPTORS_PROPERTY);
        }
        if (hasCustomAttributes) {
            properties.addAll(IWorkItem.CUSTOM_ATTRIBUTE_PROPERTIES);
        }
        return ItemProfile.createProfile(IWorkItem.ITEM_TYPE, properties);
    }

    @Override
    public List<String> getDefaultAttributeSet(IQueryableAttributeFactory.AttributeSet set) {
        return Arrays.asList(IWorkItem.TYPE_PROPERTY, IWorkItem.ID_PROPERTY, IWorkItem.STATE_PROPERTY, IWorkItem.PRIORITY_PROPERTY, IWorkItem.SEVERITY_PROPERTY, IWorkItem.SUMMARY_PROPERTY, IWorkItem.OWNER_PROPERTY, IWorkItem.CREATOR_PROPERTY);
    }

    private void setAttributeArchiveFlag(QueryableWorkItemAttribute attribute) {
        if (attribute.isStateExtension() && !this.fCacheCustomAttributeIdentifiers.contains(attribute.getIdentifier())) {
            attribute.setArchived(true);
        }
    }

    private void cacheCustomAttributesFromWorkitemTypes(IProjectAreaHandle projectArea, IAuditableCommon auditableCommon) throws TeamRepositoryException {
        IWorkItemCommon workItemCommon = auditableCommon.getPeer(IWorkItemCommon.class);
        List<IWorkItemType> workItemTypes = workItemCommon.findWorkItemTypes(projectArea, null);
        ItemHandleAwareHashSet<IAttributeHandle> configuredCustomAttributes = new ItemHandleAwareHashSet<IAttributeHandle>();
        for (IWorkItemType t : workItemTypes) {
            configuredCustomAttributes.addAll(t.getCustomAttributes());
        }
        List<IAttribute> resolvedAttributes = auditableCommon.resolveAuditables(configuredCustomAttributes.toList(), IAttribute.SMALL_PROFILE, null);
        this.fCacheCustomAttributeIdentifiers.clear();
        this.fCacheCustomAttributeIdentifiers.add("com.ibm.team.apt.estimate.minimal");
        this.fCacheCustomAttributeIdentifiers.add("com.ibm.team.apt.estimate.maximal");
        for (IAttribute r : resolvedAttributes) {
            this.fCacheCustomAttributeIdentifiers.add(r.getIdentifier());
        }
    }

    private static class Entry {
        List<IQueryableAttribute> attributes;
        Map<String, IQueryableAttribute> attributeMap;

        private Entry() {
        }
    }
}

