/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.common.internal.presentations;

import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.workitem.common.internal.presentations.AbstractPresentationDescriptor;
import com.ibm.team.workitem.common.internal.presentations.EditorPresentationManager;
import com.ibm.team.workitem.common.internal.presentations.PresentationDescriptor;
import com.ibm.team.workitem.common.internal.presentations.TabDescriptor;
import com.ibm.team.workitem.common.model.IWorkItem;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;

public class EditorPresentation {
    private Map<String, List<AbstractPresentationDescriptor>> fPresentationsMap;
    private Map<String, String> fTabLayouts;
    private String fPresentationId;
    private String fBindingElementType;
    private final String fTarget;
    private final IProjectAreaHandle fProjectArea;
    private final String fWorkItemType;
    private Map<String, String> fTabAttributeMap;

    public EditorPresentation(String target, IWorkItem workItem) {
        this(target, workItem.getProjectArea(), workItem.getWorkItemType());
    }

    public EditorPresentation(String target, IProjectAreaHandle projectArea, String workItemType) {
        this.fTarget = target;
        this.fProjectArea = projectArea;
        this.fWorkItemType = workItemType;
        this.fTabAttributeMap = null;
    }

    public void resolve(EditorPresentationManager manager, IProgressMonitor monitor) throws TeamRepositoryException {
        this.fPresentationsMap = manager.getPresentationsMap(this.fProjectArea, monitor);
        this.fTabLayouts = manager.getTabLayouts(this.fProjectArea, monitor);
        this.fPresentationId = manager.getPresentationId(this.fTarget, this.fProjectArea, this.fWorkItemType, monitor);
        this.fBindingElementType = EditorPresentationManager.getBindingElementType(this.fTarget);
        this.fTabAttributeMap = null;
    }

    public Map<String, List<AbstractPresentationDescriptor>> getPresentationsMap() {
        return this.fPresentationsMap;
    }

    public Map<String, String> getTabLayouts() {
        return this.fTabLayouts;
    }

    public String getTabForElementId(String elementId) {
        if (this.fTabAttributeMap == null) {
            this.fTabAttributeMap = new HashMap<String, String>();
            for (AbstractPresentationDescriptor tab : this.fPresentationsMap.get(this.fPresentationId)) {
                String tabId;
                List<AbstractPresentationDescriptor> sections;
                if (!(tab instanceof TabDescriptor) || (sections = this.fPresentationsMap.get(tabId = tab.getElementId())) == null) continue;
                for (AbstractPresentationDescriptor section : sections) {
                    String sectionId = section.getElementId();
                    List<AbstractPresentationDescriptor> presentations = this.fPresentationsMap.get(sectionId);
                    if (presentations == null) continue;
                    for (AbstractPresentationDescriptor cur : presentations) {
                        String targetId;
                        if (!(cur instanceof PresentationDescriptor)) continue;
                        PresentationDescriptor presentation = (PresentationDescriptor)cur;
                        String string = targetId = presentation.getAttributeId() != null ? presentation.getAttributeId().getScopedIdentifier() : presentation.getId();
                        if (targetId == null || this.fTabAttributeMap.containsKey(targetId)) continue;
                        this.fTabAttributeMap.put(targetId, tabId);
                    }
                }
            }
        }
        return this.fTabAttributeMap.get(elementId);
    }

    public String getEditorLayout() {
        return this.fPresentationId;
    }

    public String getPresentationId() {
        return this.fPresentationId;
    }

    public String getBindingElementType() {
        return this.fBindingElementType;
    }
}

