/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.common.internal.setup.builders;

import com.ibm.team.process.common.IProjectArea;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.process.common.internal.setup.builders.ProjectAreaBuilder;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.rtc.common.internal.setup.builders.AbstractArtifactBuilder;
import com.ibm.team.rtc.common.internal.setup.builders.BuildContext;
import com.ibm.team.rtc.common.internal.setup.builders.IArtifactBuilderContext;
import com.ibm.team.rtc.common.internal.setup.builders.ValueKey;
import com.ibm.team.workitem.common.internal.model.WorkItemCommonPlugin;
import com.ibm.team.workitem.common.internal.model.WorkItemType;
import com.ibm.team.workitem.common.internal.setup.builders.AttributeBuilder;
import com.ibm.team.workitem.common.model.IAttribute;
import com.ibm.team.workitem.common.model.IAttributeHandle;
import com.ibm.team.workitem.common.model.IWorkItemType;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class WorkItemTypeBuilder
extends AbstractArtifactBuilder<IWorkItemType> {
    protected static final ValueKey<IProjectArea> PROJECT_AREA = new ValueKey(String.valueOf(WorkItemTypeBuilder.class.getName()) + ".projectArea");
    protected static final ValueKey<String> IDENTIFIER = new ValueKey(String.valueOf(WorkItemTypeBuilder.class.getName()) + ".identifier");
    protected static final ValueKey<String> CATEGORY = new ValueKey(String.valueOf(WorkItemTypeBuilder.class.getName()) + ".category");
    protected static final ValueKey<String> DISPLAY_NAME = new ValueKey(String.valueOf(WorkItemTypeBuilder.class.getName()) + ".displayName");
    protected static final ValueKey<List<String>> ALIASES = new ValueKey(String.valueOf(WorkItemTypeBuilder.class.getName()) + ".aliases");
    protected static final ValueKey<URL> ICON_URL = new ValueKey(String.valueOf(WorkItemTypeBuilder.class.getName()) + ".iconUrl");
    protected static final ValueKey<URL> DIMMED_ICON_URL = new ValueKey(String.valueOf(WorkItemTypeBuilder.class.getName()) + ".dimmedIconUrl");
    protected static final ValueKey<List<IAttributeHandle>> CUSTOM_ATTRIBUTES = new ValueKey(String.valueOf(WorkItemTypeBuilder.class.getName()) + ".customAttributes");
    private URL defaultIcon;

    public WorkItemTypeBuilder(IArtifactBuilderContext buildContext) {
        super(buildContext);
        try {
            this.defaultIcon = new URL("");
        }
        catch (MalformedURLException x) {
            WorkItemCommonPlugin.log(x.getMessage(), x);
        }
    }

    protected IWorkItemType doSave(BuildContext context) throws TeamRepositoryException {
        throw new UnsupportedOperationException();
    }

    protected IWorkItemType doBuild(BuildContext context) {
        IProjectArea projectArea = (IProjectArea)this.chooseValue(context, PROJECT_AREA, PROJECT_AREA, null, null);
        String identifier = (String)this.chooseValue(IDENTIFIER, "testType");
        String category = (String)this.chooseValue(CATEGORY, "com.ibm.team.workitem.workItemType.testType");
        String dispName = (String)this.chooseValue(DISPLAY_NAME, "Test Item Type");
        List aliases = (List)this.chooseValue(ALIASES, Collections.emptyList());
        List customAttrs = (List)this.chooseValue(CUSTOM_ATTRIBUTES, Collections.emptyList());
        URL iconUrl = (URL)this.chooseValue(ICON_URL, this.defaultIcon);
        URL dimmedIconUrl = (URL)this.chooseValue(DIMMED_ICON_URL, null);
        return new WorkItemType((IProjectAreaHandle)projectArea, identifier, category, customAttrs, dispName, aliases, iconUrl, dimmedIconUrl, 0);
    }

    public WorkItemTypeBuilder projectArea(ProjectAreaBuilder projectAreaBuilder) {
        IProjectArea projectArea = (IProjectArea)projectAreaBuilder.build();
        return this.projectArea(projectArea);
    }

    public WorkItemTypeBuilder projectArea(IProjectArea projectArea) {
        this.setBuilderValue(PROJECT_AREA, projectArea);
        return this;
    }

    public WorkItemTypeBuilder identifier(String id) {
        this.setBuilderValue(IDENTIFIER, id);
        return this;
    }

    public WorkItemTypeBuilder category(String category) {
        this.setBuilderValue(CATEGORY, category);
        return this;
    }

    public WorkItemTypeBuilder displayName(String name) {
        this.setBuilderValue(DISPLAY_NAME, name);
        return this;
    }

    public WorkItemTypeBuilder aliases(String ... aliases) {
        this.setBuilderValue(ALIASES, Arrays.asList(aliases));
        return this;
    }

    public WorkItemTypeBuilder iconUrl(URL url) {
        this.setBuilderValue(ICON_URL, url);
        return this;
    }

    public WorkItemTypeBuilder dimmedIconUrl(URL url) {
        this.setBuilderValue(DIMMED_ICON_URL, url);
        return this;
    }

    public WorkItemTypeBuilder customAttributes(IAttribute ... attributes) {
        this.setBuilderValue(CUSTOM_ATTRIBUTES, Arrays.asList(attributes));
        return this;
    }

    public WorkItemTypeBuilder customAttributes(AttributeBuilder ... attributeBuilders) {
        ArrayList<IAttributeHandle> list = new ArrayList<IAttributeHandle>();
        AttributeBuilder[] attributeBuilderArray = attributeBuilders;
        int n = attributeBuilders.length;
        int n2 = 0;
        while (n2 < n) {
            AttributeBuilder builder = attributeBuilderArray[n2];
            list.add((IAttributeHandle)((IAttribute)builder.build()).getItemHandle());
            ++n2;
        }
        this.setBuilderValue(CUSTOM_ATTRIBUTES, list);
        return this;
    }
}

