/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.common.internal.util;

import com.ibm.team.process.common.IProjectArea;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.process.internal.common.ProcessPackage;
import com.ibm.team.process.internal.common.ProjectArea;
import com.ibm.team.repository.common.IAuditableHandle;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.workitem.common.IAuditableCommon;
import com.ibm.team.workitem.common.internal.model.WorkItemCommonPlugin;
import com.ibm.team.workitem.common.internal.util.AuditablesHelper;
import com.ibm.team.workitem.common.internal.util.CacheState;
import com.ibm.team.workitem.common.model.ItemProfile;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;

public abstract class CacheHelper {
    public static long EXPIRATION = 10000L;
    public static final ItemProfile<IProjectArea> PROJECT_CHECK_PROFILE = ItemProfile.createProfile(IProjectArea.ITEM_TYPE, AuditablesHelper.AUDITABLE_SMALL_PROFILE).createExtension(ProcessPackage.eINSTANCE.getProjectArea_IsInitialized().getName(), ProcessPackage.eINSTANCE.getProjectArea_InternalProcessProvider().getName());
    private final IAuditableCommon fAuditableCommon;
    private final ConcurrentHashMap<UUID, CacheState> fLastSeenStates = new ConcurrentHashMap(8, 0.9f, 1);
    private final ConcurrentHashMap<UUID, Object> fUpdateLocks = new ConcurrentHashMap(8, 0.9f, 1);

    public CacheHelper(IAuditableCommon auditableCommon) {
        this.fAuditableCommon = auditableCommon;
    }

    protected long getCacheExpiration() {
        return EXPIRATION;
    }

    public void invalidateCache(IProjectAreaHandle projectArea) {
        this.fLastSeenStates.remove(projectArea.getItemId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flushCache(IProjectAreaHandle projectArea) {
        if (this.fLastSeenStates.get(projectArea.getItemId()) != null) {
            Object lock;
            Object object = lock = this.getUpdateLock(projectArea);
            synchronized (object) {
                this.invalidateCache(projectArea);
                this.doFlushCache(projectArea);
            }
        }
    }

    public void checkCache(IProjectAreaHandle projectAreaHandle, IProgressMonitor monitor) throws TeamRepositoryException {
        this.checkCache(projectAreaHandle, this.getAuditableCommon(), monitor);
    }

    protected void checkCache(IProjectAreaHandle projectAreaHandle, IAuditableCommon auditableCommon, IProgressMonitor monitor) throws TeamRepositoryException {
        if (AuditablesHelper.ENFORCE_PROJECT_AREA_NOT_NULL) {
            Assert.isTrue((projectAreaHandle != null ? 1 : 0) != 0);
        }
        try {
            this.internalCheckCache(projectAreaHandle, auditableCommon, monitor);
        }
        catch (TeamRepositoryException x) {
            if (this.fLastSeenStates.get(projectAreaHandle.getItemId()) == null) {
                throw x;
            }
            WorkItemCommonPlugin.log("Exception while updating cache", (Exception)((Object)x));
        }
    }

    protected String printProjectState(IProjectAreaHandle projectAreaHandle) {
        CacheState state = this.fLastSeenStates.get(projectAreaHandle.getItemId());
        if (state != null) {
            return state.toString();
        }
        return "No state";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void internalCheckCache(IProjectAreaHandle projectAreaHandle, IAuditableCommon auditableCommon, IProgressMonitor monitor) throws TeamRepositoryException {
        Object lock;
        CacheState state = this.fLastSeenStates.get(projectAreaHandle.getItemId());
        if (state != null && !state.needsRefresh(projectAreaHandle, auditableCommon, monitor)) {
            return;
        }
        Object object = lock = this.getUpdateLock(projectAreaHandle);
        synchronized (object) {
            CacheState state2 = this.fLastSeenStates.get(projectAreaHandle.getItemId());
            if (state == null && state2 != null || state != null && state2 != state) {
                return;
            }
            CacheState newState = this.getCacheState(projectAreaHandle, auditableCommon, monitor);
            this.updateCache(projectAreaHandle, auditableCommon, monitor);
            if (newState != null) {
                this.fLastSeenStates.put(projectAreaHandle.getItemId(), newState);
            } else {
                this.fLastSeenStates.remove(projectAreaHandle.getItemId());
            }
        }
    }

    protected Object getUpdateLock(IProjectAreaHandle projectAreaHandle) {
        Object updateLock = this.fUpdateLocks.get(projectAreaHandle.getItemId());
        if (updateLock == null && (updateLock = this.fUpdateLocks.putIfAbsent(projectAreaHandle.getItemId(), new Object())) == null) {
            updateLock = this.fUpdateLocks.get(projectAreaHandle.getItemId());
        }
        return updateLock;
    }

    protected CacheState getCacheState(IProjectAreaHandle projectAreaHandle, IAuditableCommon auditableCommon, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.getCacheStateForProcessConfiguration(projectAreaHandle, auditableCommon, monitor);
    }

    protected CacheState getCacheStateForProcessConfiguration(IProjectAreaHandle projectAreaHandle, IAuditableCommon auditableCommon, IProgressMonitor monitor) throws TeamRepositoryException {
        IProjectArea projectArea = auditableCommon.resolveAuditable((IAuditableHandle)projectAreaHandle, PROJECT_CHECK_PROFILE, monitor);
        if (!projectArea.isInitialized()) {
            return null;
        }
        UUID lastSeenState = projectArea.getStateId();
        UUID lastSeenProviderState = null;
        IProjectAreaHandle processProviderHandle = ((ProjectArea)projectArea).getProcessProvider();
        if (processProviderHandle != null) {
            IProjectAreaHandle processProvider = (IProjectAreaHandle)auditableCommon.resolveAuditable((IAuditableHandle)processProviderHandle, PROJECT_CHECK_PROFILE, monitor);
            lastSeenProviderState = processProvider.getStateId();
        }
        return new CacheState.ProcessConfigurationState(this.getCacheExpiration(), lastSeenState, lastSeenProviderState, auditableCommon);
    }

    protected CacheState getCacheStateForItemType(IItemType itemType, IProjectAreaHandle projectAreaHandle, IAuditableCommon auditableCommon, IProgressMonitor monitor) throws TeamRepositoryException {
        IProjectArea projectArea = auditableCommon.resolveAuditable((IAuditableHandle)projectAreaHandle, PROJECT_CHECK_PROFILE, monitor);
        if (!projectArea.isInitialized()) {
            return null;
        }
        return new CacheState.ProcessItemState(this.getCacheExpiration(), itemType, projectAreaHandle, auditableCommon, monitor);
    }

    protected CacheState getCombinedCacheState(CacheState ... states) throws TeamRepositoryException {
        CacheState[] cacheStateArray = states;
        int n = states.length;
        int n2 = 0;
        while (n2 < n) {
            CacheState state = cacheStateArray[n2];
            if (state == null) {
                return null;
            }
            ++n2;
        }
        return new CacheState.CombinedState(states);
    }

    protected CacheState getPessimisticCacheState() {
        return new CacheState.PessimisticState(this.getCacheExpiration());
    }

    protected IAuditableCommon getAuditableCommon() {
        return this.fAuditableCommon;
    }

    protected abstract void updateCache(IProjectAreaHandle var1, IAuditableCommon var2, IProgressMonitor var3) throws TeamRepositoryException;

    protected void doFlushCache(IProjectAreaHandle projectArea) {
    }
}

