/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.common.internal.util;

import com.ibm.team.process.common.IProjectArea;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.process.internal.common.ProjectArea;
import com.ibm.team.repository.common.IAuditableHandle;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.model.query.BaseItemQueryModel;
import com.ibm.team.repository.common.query.IDataQuery;
import com.ibm.team.repository.common.query.IDataQueryPage;
import com.ibm.team.repository.common.query.ast.IField;
import com.ibm.team.repository.common.query.ast.IItemQueryModel;
import com.ibm.team.repository.common.query.ast.IPredicate;
import com.ibm.team.repository.common.query.ast.IQueryModel;
import com.ibm.team.repository.common.query.ast.ISelectionElement;
import com.ibm.team.workitem.common.IAuditableCommon;
import com.ibm.team.workitem.common.IWorkItemCommon;
import com.ibm.team.workitem.common.internal.WorkItemCommon;
import com.ibm.team.workitem.common.internal.model.query.BaseAttributeQueryModel;
import com.ibm.team.workitem.common.internal.model.query.BaseCategoryQueryModel;
import com.ibm.team.workitem.common.internal.model.query.BaseDeliverableQueryModel;
import com.ibm.team.workitem.common.internal.util.CacheHelper;
import com.ibm.team.workitem.common.model.IAttribute;
import com.ibm.team.workitem.common.model.ICategory;
import com.ibm.team.workitem.common.model.IDeliverable;
import java.sql.Timestamp;
import org.eclipse.core.runtime.IProgressMonitor;

public abstract class CacheState {
    private long fCacheExpiration;
    private long fExpiryTime;

    public CacheState(long cacheExpiration) {
        this.fCacheExpiration = cacheExpiration;
        this.updateExpiryTime();
    }

    private void updateExpiryTime() {
        this.fExpiryTime = System.currentTimeMillis() + this.fCacheExpiration;
    }

    public boolean needsRefresh(IProjectAreaHandle projectAreaHandle, IAuditableCommon auditableCommon, IProgressMonitor monitor) throws TeamRepositoryException {
        if (this.getExpiryTime() > System.currentTimeMillis()) {
            return false;
        }
        if (this.stateChanged(projectAreaHandle, auditableCommon, monitor)) {
            return true;
        }
        this.updateExpiryTime();
        return false;
    }

    protected long getExpiryTime() {
        return this.fExpiryTime;
    }

    protected abstract boolean stateChanged(IProjectAreaHandle var1, IAuditableCommon var2, IProgressMonitor var3) throws TeamRepositoryException;

    public static class CombinedState
    extends CacheState {
        private final CacheState[] fStates;

        CombinedState(CacheState ... states) {
            super(-1L);
            this.fStates = states;
        }

        @Override
        protected boolean stateChanged(IProjectAreaHandle projectAreaHandle, IAuditableCommon auditableCommon, IProgressMonitor monitor) throws TeamRepositoryException {
            CacheState[] cacheStateArray = this.fStates;
            int n = this.fStates.length;
            int n2 = 0;
            while (n2 < n) {
                CacheState state = cacheStateArray[n2];
                if (state.needsRefresh(projectAreaHandle, auditableCommon, monitor)) {
                    return true;
                }
                ++n2;
            }
            return false;
        }

        public String toString() {
            String toString = "";
            CacheState[] cacheStateArray = this.fStates;
            int n = this.fStates.length;
            int n2 = 0;
            while (n2 < n) {
                CacheState state = cacheStateArray[n2];
                toString = String.valueOf(toString) + state.toString();
                ++n2;
            }
            return toString;
        }
    }

    public static class PessimisticState
    extends CacheState {
        public PessimisticState(long cacheExpiration) {
            super(cacheExpiration);
        }

        @Override
        protected boolean stateChanged(IProjectAreaHandle projectAreaHandle, IAuditableCommon auditableCommon, IProgressMonitor monitor) throws TeamRepositoryException {
            return true;
        }
    }

    public static class ProcessConfigurationState
    extends CacheState {
        private final Object fLastSeenProjectState;
        private final UUID fLastSeenProviderState;

        public ProcessConfigurationState(long cacheExpiration, UUID lastSeenProjectState, UUID lastSeenProviderState, IAuditableCommon auditableCommon) {
            super(cacheExpiration);
            this.fLastSeenProjectState = lastSeenProjectState;
            this.fLastSeenProviderState = lastSeenProviderState;
        }

        @Override
        protected boolean stateChanged(IProjectAreaHandle projectAreaHandle, IAuditableCommon auditableCommon, IProgressMonitor monitor) throws TeamRepositoryException {
            IProjectAreaHandle processProvider;
            IProjectAreaHandle processProviderHandle;
            IProjectArea projectArea = auditableCommon.resolveAuditable((IAuditableHandle)projectAreaHandle, CacheHelper.PROJECT_CHECK_PROFILE, monitor);
            if (!this.fLastSeenProjectState.equals(projectArea.getStateId())) {
                return true;
            }
            return this.fLastSeenProviderState != null && (processProviderHandle = ((ProjectArea)projectArea).getProcessProvider()) != null && !this.fLastSeenProviderState.equals((Object)(processProvider = (IProjectAreaHandle)auditableCommon.resolveAuditable((IAuditableHandle)processProviderHandle, CacheHelper.PROJECT_CHECK_PROFILE, monitor)).getStateId());
        }

        public String toString() {
            return "LastSeenState: " + this.fLastSeenProjectState + " LastSeenProviderState: " + this.fLastSeenProviderState + " Expires in (ms): " + (this.getExpiryTime() - System.currentTimeMillis());
        }
    }

    public static class ProcessItemState
    extends CacheState {
        private final UUID fCurrentState;
        private final IItemType fItemType;

        public ProcessItemState(long cacheExpiration, IItemType itemType, IProjectAreaHandle projectAreaHandle, IAuditableCommon auditableCommon, IProgressMonitor monitor) throws TeamRepositoryException {
            super(cacheExpiration);
            this.fItemType = itemType;
            this.fCurrentState = this.getProcessItemState(projectAreaHandle, auditableCommon, monitor);
        }

        @Override
        protected boolean stateChanged(IProjectAreaHandle projectAreaHandle, IAuditableCommon auditableCommon, IProgressMonitor monitor) throws TeamRepositoryException {
            if (this.fCurrentState == null) {
                return true;
            }
            UUID newState = this.getProcessItemState(projectAreaHandle, auditableCommon, monitor);
            return !this.fCurrentState.equals((Object)newState);
        }

        private UUID getProcessItemState(IProjectAreaHandle projectAreaHandle, IAuditableCommon auditableCommon, IProgressMonitor monitor) throws TeamRepositoryException {
            return ((WorkItemCommon)auditableCommon.getPeer(IWorkItemCommon.class)).getProcessSpecItemsState(projectAreaHandle, this.fItemType, monitor);
        }

        public String toString() {
            return "Current State: " + this.fCurrentState + " Expires in (ms): " + (this.getExpiryTime() - System.currentTimeMillis());
        }
    }

    public static class ProcessItemStateUsingLastModifedTime
    extends CacheState {
        private final Timestamp fLastModifiedTime;
        private final IItemType fItemType;
        private final IAuditableCommon fAuditableCommon;

        public ProcessItemStateUsingLastModifedTime(long cacheExpiration, IItemType itemType, IProjectAreaHandle projectAreaHandle, IAuditableCommon auditableCommon, IProgressMonitor monitor) throws TeamRepositoryException {
            super(cacheExpiration);
            this.fItemType = itemType;
            this.fAuditableCommon = auditableCommon;
            this.fLastModifiedTime = this.getLastModifiedTime(itemType, projectAreaHandle, monitor);
        }

        @Override
        protected boolean stateChanged(IProjectAreaHandle projectAreaHandle, IAuditableCommon auditableCommon, IProgressMonitor monitor) throws TeamRepositoryException {
            if (this.fLastModifiedTime == null) {
                return true;
            }
            Timestamp currentLastModifiedTime = this.getLastModifiedTime(this.fItemType, projectAreaHandle, monitor);
            if (currentLastModifiedTime == null) {
                return true;
            }
            return this.fLastModifiedTime.compareTo(currentLastModifiedTime) != 0;
        }

        protected Timestamp getLastModifiedTime(IItemType itemType, IProjectAreaHandle projectAreaHandle, IProgressMonitor monitor) throws TeamRepositoryException {
            if (IAttribute.ITEM_TYPE.equals(itemType)) {
                return this.getLastModifiedTimeForAttribute(projectAreaHandle, monitor);
            }
            if (ICategory.ITEM_TYPE.equals(itemType)) {
                return this.getLastModifiedTimeForCategory(projectAreaHandle, monitor);
            }
            if (IDeliverable.ITEM_TYPE.equals(itemType)) {
                return this.getLastModifiedTimeForDeliverable(projectAreaHandle, monitor);
            }
            return null;
        }

        private Timestamp getLastModifiedTimeForAttribute(IProjectAreaHandle projectAreaHandle, IProgressMonitor monitor) throws TeamRepositoryException {
            BaseAttributeQueryModel.AttributeQueryModel queryModel = BaseAttributeQueryModel.AttributeQueryModel.ROOT;
            IPredicate predicate = queryModel.projectArea()._eq((IItemHandle)projectAreaHandle);
            return this.executeQuery((BaseItemQueryModel)queryModel, predicate, monitor);
        }

        private Timestamp getLastModifiedTimeForCategory(IProjectAreaHandle projectAreaHandle, IProgressMonitor monitor) throws TeamRepositoryException {
            BaseCategoryQueryModel.CategoryQueryModel queryModel = BaseCategoryQueryModel.CategoryQueryModel.ROOT;
            IPredicate predicate = queryModel.projectArea()._eq((IItemHandle)projectAreaHandle);
            return this.executeQuery((BaseItemQueryModel)queryModel, predicate, monitor);
        }

        private Timestamp getLastModifiedTimeForDeliverable(IProjectAreaHandle projectAreaHandle, IProgressMonitor monitor) throws TeamRepositoryException {
            BaseDeliverableQueryModel.DeliverableQueryModel queryModel = BaseDeliverableQueryModel.DeliverableQueryModel.ROOT;
            IPredicate predicate = queryModel.projectArea()._eq((IItemHandle)projectAreaHandle);
            return this.executeQuery((BaseItemQueryModel)queryModel, predicate, monitor);
        }

        private Timestamp executeQuery(BaseItemQueryModel queryModel, IPredicate predicate, IProgressMonitor monitor) throws TeamRepositoryException {
            IDataQuery query = (IDataQuery)IDataQuery.FACTORY.newInstance((IQueryModel)((IItemQueryModel)queryModel));
            query.filter(predicate);
            query.max((IField)queryModel.modified());
            query.select((ISelectionElement)queryModel.modified());
            IDataQueryPage queryData = this.fAuditableCommon.queryData(query, new Object[0], 1, monitor);
            if (queryData.hasNext()) {
                return queryData.getRow(0).getTimestamp(0);
            }
            return null;
        }

        public String toString() {
            return "LastModifiedTime: " + this.fLastModifiedTime + " Expires in (ms): " + (this.getExpiryTime() - System.currentTimeMillis());
        }
    }
}

