/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.common.internal.util;

import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.model.Helper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;

public class DiffUtils {
    public static boolean equals(EObject left, EObject right) {
        if (left.eClass() != right.eClass()) {
            return false;
        }
        for (EStructuralFeature feature : left.eClass().getEAllStructuralFeatures()) {
            if (DiffUtils.equals(left.eGet(feature), right.eGet(feature), feature.isOrdered())) continue;
            return false;
        }
        return true;
    }

    public static boolean equals(Helper left, Helper right) {
        UUID leftId = left.getInternalId();
        UUID rightId = right.getInternalId();
        if (leftId != null && rightId != null && !leftId.equals((Object)rightId)) {
            return false;
        }
        return DiffUtils.equals((EObject)left, (EObject)right);
    }

    public static boolean equals(List<?> left, List<?> right, boolean ordered) {
        UUID uuid;
        if (left.size() != right.size()) {
            return false;
        }
        if (ordered) {
            int i = 0;
            while (i < left.size()) {
                if (!DiffUtils.equals(left.get(i), right.get(i), false)) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        HashMap leftItems = new HashMap();
        ArrayList<Object> leftObjects = new ArrayList<Object>();
        for (Object element : left) {
            Assert.isTrue((!(element instanceof List) ? 1 : 0) != 0);
            uuid = DiffUtils.getUUID(element);
            if (uuid != null) {
                leftItems.put(uuid, element);
                continue;
            }
            leftObjects.add(element);
        }
        for (Object rightElement : right) {
            uuid = DiffUtils.getUUID(rightElement);
            if (uuid != null) {
                Object leftItem = leftItems.get(uuid);
                if (leftItem == null) {
                    return false;
                }
                if (DiffUtils.equals(leftItem, rightElement, false)) continue;
                return false;
            }
            DiffUtils.remove(leftObjects, rightElement);
        }
        return leftObjects.isEmpty();
    }

    public static boolean equals(Object left, Object right, boolean ordered) {
        if (left == right) {
            return true;
        }
        if (left == null || right == null) {
            return false;
        }
        if (left instanceof IItemHandle && right instanceof IItemHandle) {
            return ((IItemHandle)left).sameItemId((IItemHandle)right);
        }
        if (left instanceof Helper && right instanceof Helper) {
            return DiffUtils.equals((Helper)left, (Helper)right);
        }
        if (left instanceof List && right instanceof List) {
            return DiffUtils.equals((List)left, (List)right, ordered);
        }
        if (left instanceof EObject && right instanceof EObject) {
            return DiffUtils.equals((EObject)left, (EObject)right);
        }
        return left.equals(right);
    }

    public static UUID getUUID(Object element) {
        if (element instanceof UUID) {
            return (UUID)element;
        }
        if (element instanceof IItemHandle) {
            return ((IItemHandle)element).getItemId();
        }
        if (element instanceof Helper) {
            return ((Helper)element).getInternalId();
        }
        return null;
    }

    public static void remove(List<Object> list, Object element) {
        Iterator<Object> iter = list.iterator();
        while (iter.hasNext()) {
            Object listElement = iter.next();
            if (!DiffUtils.equals(listElement, element, false)) continue;
            iter.remove();
            return;
        }
    }
}

