/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.common.internal.util;

import com.ibm.team.calm.foundation.common.XMLHelper;
import com.ibm.team.foundation.common.text.HTMLHandler;
import com.ibm.team.foundation.common.text.XMLConverter;
import com.ibm.team.foundation.common.text.XMLString;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class HTMLOutputHandler
extends HTMLHandler {
    private static final String ENTITY_REF_NBSP = "&nbsp;";
    private static final String BOLD_TAG = "<b>";
    private static final String BOLD_END_TAG = "</b>";
    private static final String ITALIC_TAG = "<i>";
    private static final String ITALIC_END_TAG = "</i>";
    private static final String FOREGROUND_TAG = "<span style=\"color: #{1};\">";
    private static final String BACKGROUND_TAG = "<span style=\"background: #{1};\">";
    private static final String COLOR_END_TAG = "</span>";
    private static final String REFERENCE_TAG_LEFT = "<a href=\"";
    private static final String REFERENCE_TAG_RIGHT = "\">";
    private static final String REFERENCE_END_TAG = "</a>";
    InternalScanner fScanner;
    StringBuffer fBuffer;
    private int[] fForeground;
    private int[] fBackground;
    private int fFontStyle;
    private boolean fFiltered;

    public HTMLOutputHandler(boolean canonical) {
        this(canonical, Collections.emptyList());
    }

    private HTMLOutputHandler(boolean canonical, List<IInternalRule> additionalRules) {
        this.fScanner = new InternalScanner(canonical, additionalRules);
    }

    public void beginDocument() {
        this.fBuffer = new StringBuffer();
    }

    public void endDocument() {
    }

    public void text(CharSequence text) {
        this.fBuffer.append(this.fScanner.escape(text));
    }

    public void beginStyle(int[] foreground, int[] background, int fontStyle) {
        this.fForeground = foreground;
        this.fBackground = background;
        this.fFontStyle = fontStyle;
        if ((this.fFontStyle & 1) != 0) {
            this.fBuffer.append(BOLD_TAG);
        }
        if ((this.fFontStyle & 2) != 0) {
            this.fBuffer.append(ITALIC_TAG);
        }
        if (this.fForeground != null) {
            this.fBuffer.append(FOREGROUND_TAG.replace("{1}", this.RGBToString(this.fForeground)));
        }
        if (this.fBackground != null) {
            this.fBuffer.append(BACKGROUND_TAG.replace("{1}", this.RGBToString(this.fBackground)));
        }
    }

    public void endStyle() {
        if (this.fBackground != null) {
            this.fBuffer.append(COLOR_END_TAG);
        }
        if (this.fForeground != null) {
            this.fBuffer.append(COLOR_END_TAG);
        }
        if ((this.fFontStyle & 2) != 0) {
            this.fBuffer.append(ITALIC_END_TAG);
        }
        if ((this.fFontStyle & 1) != 0) {
            this.fBuffer.append(BOLD_END_TAG);
        }
    }

    public void beginReference(CharSequence reference) {
        String href = reference.toString().trim().toLowerCase();
        if (href.startsWith("javascript:")) {
            this.fFiltered = true;
            return;
        }
        this.fFiltered = false;
        this.fBuffer.append(REFERENCE_TAG_LEFT).append(this.encode(reference.toString())).append(REFERENCE_TAG_RIGHT);
    }

    public void endReference() {
        if (this.fFiltered) {
            return;
        }
        this.fBuffer.append(REFERENCE_END_TAG);
    }

    private String encode(String reference) {
        return XMLString.createFromPlainText((String)reference).getXMLText();
    }

    private String RGBToString(int[] rgb) {
        return String.valueOf(this.toHexString(rgb[0], 2)) + this.toHexString(rgb[1], 2) + this.toHexString(rgb[2], 2);
    }

    /*
     * Unable to fully structure code
     */
    private String toHexString(int value, int digits) {
        s = Integer.toHexString(value);
        if (s.length() <= digits) ** GOTO lbl5
        throw new IllegalArgumentException();
lbl-1000:
        // 1 sources

        {
            s = "0" + s;
lbl5:
            // 2 sources

            ** while (s.length() < digits)
        }
lbl6:
        // 1 sources

        return s;
    }

    public XMLString getHTML() {
        return XMLString.createFromXMLText((String)this.fBuffer.toString());
    }

    public XMLString getXHTML() {
        int nbspPos = this.fBuffer.indexOf(ENTITY_REF_NBSP);
        while (nbspPos != -1) {
            this.fBuffer.replace(nbspPos, nbspPos + ENTITY_REF_NBSP.length(), " ");
            nbspPos = this.fBuffer.indexOf(ENTITY_REF_NBSP);
        }
        return XMLString.createFromXMLText((String)this.fBuffer.toString());
    }

    public static XMLString sanitize(XMLString string) {
        HTMLOutputHandler handler = new HTMLOutputHandler(false);
        XMLConverter.parseHTML((XMLString)string, (HTMLHandler)handler);
        return handler.getHTML();
    }

    public static XMLString toSafeXHTML(XMLString string) {
        HTMLOutputHandler handler = new HTMLOutputHandler(true, Arrays.asList(new CharacterRule()));
        XMLConverter.parseHTML((XMLString)string, (HTMLHandler)handler);
        return handler.getXHTML();
    }

    public static class CharacterRule
    extends XMLHelper.XmlCharacterRule
    implements IInternalRule {
        @Override
        public String evaluate(InternalScanner scanner) {
            String replacement = this.replacement(scanner.read());
            if (replacement != null) {
                return replacement;
            }
            scanner.unread();
            return null;
        }
    }

    private static class EntityRule
    implements IInternalRule {
        private static final String CHARS = "<>&^~\"\t";
        private static final String[] ENTITIES = new String[]{"&lt;", "&gt;", "&amp;", "&circ;", "&tilde;", "&quot;", "&#09;"};

        private EntityRule() {
        }

        @Override
        public String evaluate(InternalScanner scanner) {
            int ch = scanner.read();
            int index = CHARS.indexOf(ch);
            if (index > -1) {
                return ENTITIES[index];
            }
            scanner.unread();
            return null;
        }
    }

    private static interface IInternalRule {
        public String evaluate(InternalScanner var1);
    }

    private static class InternalScanner {
        private static final int EOF = -1;
        private final List<IInternalRule> fRules;
        private CharSequence fText;
        private int fOffset;

        public InternalScanner(boolean canonical, List<IInternalRule> additionalRules) {
            this.fRules = new ArrayList<IInternalRule>(Arrays.asList(new LineDelimiterRule(canonical), new SpaceRule(), new EntityRule()));
            this.fRules.addAll(additionalRules);
        }

        public int read() {
            try {
                if (this.fOffset < this.fText.length()) {
                    char c = this.fText.charAt(this.fOffset);
                    return c;
                }
                return -1;
            }
            finally {
                ++this.fOffset;
            }
        }

        public void unread() {
            --this.fOffset;
        }

        public String escape(CharSequence text) {
            this.fOffset = 0;
            this.fText = text;
            StringBuffer buffer = new StringBuffer();
            while (true) {
                String replacement;
                if ((replacement = this.replacement()) != null) {
                    buffer.append(replacement);
                    continue;
                }
                int ch = this.read();
                if (ch == -1) break;
                buffer.append((char)ch);
            }
            return buffer.toString();
        }

        private String replacement() {
            for (IInternalRule rule : this.fRules) {
                String replacement = rule.evaluate(this);
                if (replacement == null) continue;
                return replacement;
            }
            return null;
        }
    }

    private static class LineDelimiterRule
    implements IInternalRule {
        private static final String BREAK_TAG = "<br/>";
        private static final String CANONICAL_BREAK_TAG = "<br></br>";
        private final String fBreakTag;

        public LineDelimiterRule(boolean canonical) {
            this.fBreakTag = canonical ? CANONICAL_BREAK_TAG : BREAK_TAG;
        }

        @Override
        public String evaluate(InternalScanner scanner) {
            int ch = scanner.read();
            if (ch == 10) {
                return this.fBreakTag;
            }
            if (ch == 13) {
                ch = scanner.read();
                if (ch != 10) {
                    scanner.unread();
                }
                return this.fBreakTag;
            }
            scanner.unread();
            return null;
        }
    }

    private static class SpaceRule
    implements IInternalRule {
        private SpaceRule() {
        }

        @Override
        public String evaluate(InternalScanner scanner) {
            int ch = scanner.read();
            if (ch == 32) {
                ch = scanner.read();
                scanner.unread();
                if (ch == 32) {
                    return HTMLOutputHandler.ENTITY_REF_NBSP;
                }
            }
            scanner.unread();
            return null;
        }
    }
}

