/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.common.workflow;

import com.ibm.team.workitem.common.workflow.StateResolutionPair;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public interface IStateGroup {
    public String getIdentifier();

    public String getName();

    public URL getIconUrl();

    public String getTopLevelGroupId();

    public List<OSLCGroup> getOSLCGroups();

    public boolean contains(StateResolutionPair var1);

    public Collection<StateResolutionPair> getStateResolutionPairs();

    public static enum OSLCGroup {
        INPROGRESS("oslc-inprogress"),
        FIXED("oslc-fixed"),
        CLOSED("oslc-closed"),
        APPROVED("oslc-approved"),
        REVIEWED("oslc-reviewed"),
        VERIFIED("oslc-verified");

        private static final Map<String, OSLCGroup> fgOslcGroupMap;
        private final String fId;

        static {
            fgOslcGroupMap = new HashMap<String, OSLCGroup>();
            OSLCGroup[] oSLCGroupArray = OSLCGroup.values();
            int n = oSLCGroupArray.length;
            int n2 = 0;
            while (n2 < n) {
                OSLCGroup group = oSLCGroupArray[n2];
                fgOslcGroupMap.put(group.getId(), group);
                ++n2;
            }
        }

        public static OSLCGroup getGroup(String group) {
            return fgOslcGroupMap.get(group);
        }

        private OSLCGroup(String id) {
            this.fId = id;
        }

        public String getId() {
            return this.fId;
        }
    }
}

