/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.scm.common;

import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IWorkspaceHandle;
import com.ibm.team.scm.common.internal.dto2.PageDescriptor;
import com.ibm.team.scm.common.internal.dto2.ScmDto2Factory;

public interface IPageDescriptor {
    public static final IPageDescriptorFactory FACTORY = new IPageDescriptorFactory(){

        @Override
        public IPageDescriptor initialize(IWorkspaceHandle workspace, IComponentHandle component, long startIndex, int maxPageSize) {
            if (workspace == null) {
                throw new IllegalArgumentException("workspace must not be null");
            }
            if (component == null) {
                throw new IllegalArgumentException("component must not be null");
            }
            if (startIndex < 0L) {
                throw new IllegalArgumentException("startIndex must not be less than 0.");
            }
            if (maxPageSize <= 0) {
                throw new IllegalArgumentException("maxPageSize must be greater than 0.");
            }
            PageDescriptor pageDescriptor = ScmDto2Factory.eINSTANCE.createPageDescriptor();
            pageDescriptor.setWorkspace(workspace);
            pageDescriptor.setComponent(component);
            pageDescriptor.setStartIndex(startIndex);
            pageDescriptor.setMaxPageSize(maxPageSize);
            return pageDescriptor;
        }
    };

    public long getTotalSize();

    public long getStartIndex();

    public long getSyncTime();

    public boolean hasNextPage();

    public void setStartIndex(long var1);

    public void setMaxPageSize(int var1);

    public int getMaxPageSize();

    public void setWorkspace(IWorkspaceHandle var1);

    public void setComponent(IComponentHandle var1);

    public IWorkspaceHandle getWorkspace();

    public IComponentHandle getComponent();

    public static interface IPageDescriptorFactory {
        public IPageDescriptor initialize(IWorkspaceHandle var1, IComponentHandle var2, long var3, int var5);
    }
}

