/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.scm.common.internal.process;

import com.ibm.team.process.common.advice.IAdvisorInfo;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.common.internal.process.AdvisorDataMarshaller;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.util.List;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class UnifiedProcessDescriptionUtil {
    public static Document createXmlDoc() throws TeamRepositoryException {
        Document doc = null;
        DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
        try {
            doc = docFactory.newDocumentBuilder().newDocument();
        }
        catch (ParserConfigurationException e) {
            throw new TeamRepositoryException((Throwable)e);
        }
        return doc;
    }

    public static String serializeDoc(Document doc) throws TeamRepositoryException {
        try {
            return UnifiedProcessDescriptionUtil.serializeDocument(doc);
        }
        catch (TransformerException e) {
            throw new TeamRepositoryException((Throwable)e);
        }
        catch (IOException e) {
            throw new TeamRepositoryException((Throwable)e);
        }
    }

    public static String serializeDocument(Document doc) throws TransformerException, IOException {
        TransformerFactory factory = TransformerFactory.newInstance();
        try {
            factory.setAttribute("indent-number", new Integer(4));
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        Transformer transformer = factory.newTransformer();
        transformer.setOutputProperty("method", "xml");
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("omit-xml-declaration", "yes");
        try {
            transformer.setOutputProperty("{http://xml.apache.org/xalan}indent-amount", "4");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        CharArrayWriter s = new CharArrayWriter();
        StreamResult outputTarget = new StreamResult(s);
        DOMSource source = new DOMSource(doc);
        transformer.transform(source, outputTarget);
        return s.toString();
    }

    public static String joinUuids(List<? extends IItemHandle> handles) {
        StringBuffer buf = new StringBuffer(handles.size() * 30);
        for (IItemHandle iItemHandle : handles) {
            if (buf.length() > 0) {
                buf.append(' ');
            }
            buf.append(iItemHandle.getItemId().getUuidValue());
        }
        return buf.toString();
    }

    public static String joinUuids(IItemHandle[] handles) {
        StringBuffer buf = new StringBuffer(handles.length * 30);
        IItemHandle[] iItemHandleArray = handles;
        int n = handles.length;
        int n2 = 0;
        while (n2 < n) {
            IItemHandle handle = iItemHandleArray[n2];
            if (buf.length() > 0) {
                buf.append(' ');
            }
            buf.append(handle.getItemId().getUuidValue());
            ++n2;
        }
        return buf.toString();
    }

    public static String joinUuids(UUID ... uuids) {
        StringBuffer buf = new StringBuffer(uuids.length * 30);
        UUID[] uUIDArray = uuids;
        int n = uuids.length;
        int n2 = 0;
        while (n2 < n) {
            UUID uuid = uUIDArray[n2];
            if (buf.length() > 0) {
                buf.append(' ');
            }
            buf.append(uuid.getUuidValue());
            ++n2;
        }
        return buf.toString();
    }

    public static void xmlBind(Document doc, Element parent, String src, Object ... args) {
        int state = 0;
        StringBuffer cur = new StringBuffer(src.length());
        int i = 0;
        while (i < src.length()) {
            char c = src.charAt(i);
            switch (state) {
                case 3: {
                    if (c == '\'') {
                        state = 0;
                        break;
                    }
                    cur.append(c);
                    break;
                }
                case 0: {
                    if (c == '{') {
                        state = 1;
                        parent.appendChild(doc.createTextNode(cur.toString()));
                        cur = new StringBuffer(3);
                        break;
                    }
                    if (c == '\'') {
                        state = 3;
                        break;
                    }
                    cur.append(c);
                    break;
                }
                case 1: {
                    if (c == '}') {
                        state = 0;
                        int idx = Integer.parseInt(cur.toString());
                        if (args[idx] instanceof Node) {
                            parent.appendChild((Node)args[idx]);
                        } else {
                            parent.appendChild(doc.createTextNode(args[idx].toString()));
                        }
                        cur = new StringBuffer(src.length());
                        break;
                    }
                    if (!Character.isDigit(c)) {
                        throw new IllegalArgumentException("Got a non-digit in an argument: " + c);
                    }
                    cur.append(c);
                }
            }
            ++i;
        }
        if (state != 0) {
            throw new IllegalArgumentException("Must finish in text state");
        }
        parent.appendChild(doc.createTextNode(cur.toString()));
    }

    public static void saveIntoInfo(Document amlDoc, AdvisorDataMarshaller.IScmAdvisorMarshallable data, UUID repoRoot, IAdvisorInfo info) throws TeamRepositoryException {
        UnifiedProcessDescriptionUtil.saveIntoInfo(UnifiedProcessDescriptionUtil.serializeDoc(amlDoc), data, repoRoot, info);
    }

    public static void saveIntoInfo(String amlDoc, AdvisorDataMarshaller.IScmAdvisorMarshallable data, UUID repoRoot, IAdvisorInfo info) throws TeamRepositoryException {
        Document d2 = UnifiedProcessDescriptionUtil.createXmlDoc();
        try {
            AdvisorDataMarshaller.marshallInto(new AdvisorDataMarshaller.AdvisorData<AdvisorDataMarshaller.IScmAdvisorMarshallable>(amlDoc, data), d2, d2.getDocumentElement(), repoRoot);
        }
        catch (AdvisorDataMarshaller.MarshallerException e) {
            throw new TeamRepositoryException((Throwable)e);
        }
        String serialized = UnifiedProcessDescriptionUtil.serializeDoc(d2);
        info.setData(serialized);
    }
}

