/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.scm.common.internal.util;

import com.ibm.team.links.common.ILink;
import com.ibm.team.repository.common.IAuditable;
import com.ibm.team.repository.common.IAuditableHandle;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.IManagedItem;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.scm.common.IChangeSet;
import com.ibm.team.scm.common.dto.IChangeSetLinkSummary;
import com.ibm.team.scm.common.internal.util.ItemId;
import com.ibm.team.scm.common.internal.util.ItemLists;
import com.ibm.team.scm.common.internal.util.NewCollection;
import com.ibm.team.scm.common.providers.ItemProvider;
import com.ibm.team.scm.common.providers.ProviderFactory;
import com.ibm.team.scm.common.providers.ScmProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

public class ItemProviderUtil {
    private static <K, V> void addToMapOfLists(Map<K, List<V>> map, K key, V value) {
        List<V> currentList = map.get(key);
        if (currentList == null) {
            currentList = NewCollection.arrayList();
            map.put(key, currentList);
        }
        currentList.add(value);
    }

    public static <T extends IItem> Map<ItemId<T>, T> fetchCurrents(ProviderFactory itemProvider, Collection<ItemId<T>> items, IProgressMonitor monitor) throws TeamRepositoryException {
        return ItemProviderUtil.fetchCurrents(itemProvider.getItemProvider(), items, monitor);
    }

    public static <T extends IItem> Map<ItemId<T>, T> fetchCurrents(ItemProvider itemProvider, Collection<ItemId<T>> items, IProgressMonitor monitor) throws TeamRepositoryException {
        if (items.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap result = NewCollection.hashMap();
        List<IManagedItem> fetched = itemProvider.fetchItems(ItemLists.idsToHandles(items), monitor);
        for (IItem iItem : fetched) {
            if (iItem == null) continue;
            result.put(new ItemId((IItemHandle)iItem), iItem);
        }
        return result;
    }

    public static Map<ItemId<IChangeSet>, IChangeSetLinkSummary> getChangeSetLinkSummaries(ProviderFactory factory, Collection<ItemId<IChangeSet>> changeSets, IProgressMonitor monitor) throws TeamRepositoryException {
        HashMap<ItemId<IChangeSet>, IChangeSetLinkSummary> result = NewCollection.hashMap();
        ScmProvider scmProvider = factory.getScmProvider();
        List<IChangeSetLinkSummary> linkSummaries = !changeSets.isEmpty() ? scmProvider.getChangeSetLinkSummary(ItemLists.idsToHandles(changeSets), monitor) : Collections.EMPTY_LIST;
        for (IChangeSetLinkSummary changeSetLinkSummary : linkSummaries) {
            ItemId csid = new ItemId((IItemHandle)changeSetLinkSummary.getChangeSet());
            result.put(csid, changeSetLinkSummary);
        }
        return result;
    }

    public static Map<ItemId<IChangeSet>, List<ItemId<IAuditable>>> resolveLinks(ProviderFactory providerFactory, List<ItemId<IChangeSet>> handles, String linkTypeId, IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        new HashMap();
        providerFactory.getScmProvider();
        ItemProvider itemProvider = providerFactory.getItemProvider();
        ArrayList linksToResolve = new ArrayList();
        new ArrayList();
        Map<ItemId<IChangeSet>, IChangeSetLinkSummary> summaries = ItemProviderUtil.getChangeSetLinkSummaries(providerFactory, handles, (IProgressMonitor)progress.newChild(50));
        for (IChangeSetLinkSummary changeSetLinkSummary : summaries.values()) {
            linksToResolve.addAll(ItemLists.handlesToIds(changeSetLinkSummary.getLinks()));
        }
        Map cachedLinks = ItemProviderUtil.fetchCurrents(itemProvider, linksToResolve, (IProgressMonitor)progress.newChild(50));
        HashMap<ItemId<IChangeSet>, List<ItemId<IAuditable>>> result = NewCollection.hashMap();
        for (Map.Entry<ItemId<IChangeSet>, IChangeSetLinkSummary> next : summaries.entrySet()) {
            ItemId<IChangeSet> cs = next.getKey();
            IChangeSetLinkSummary linkSummary = next.getValue();
            List linkHandles = ItemLists.handlesToIds(linkSummary.getLinks());
            for (ItemId nextLinkHandle : linkHandles) {
                Object linkTarget;
                ILink nextLink = (ILink)cachedLinks.get(nextLinkHandle);
                if (nextLink == null || !nextLink.getLinkTypeId().equals(linkTypeId) || !((linkTarget = nextLink.getTargetRef().resolve()) instanceof IAuditableHandle)) continue;
                IAuditableHandle targetAuditable = (IAuditableHandle)linkTarget;
                ItemProviderUtil.addToMapOfLists(result, cs, new ItemId((IItemHandle)targetAuditable));
            }
        }
        return result;
    }
}

