/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.scm.common.process;

import com.ibm.team.repository.common.IAuditableHandle;
import com.ibm.team.scm.common.IChangeSet;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class SaveClosedChangeSetOperationData {
    private ChangeType changeType;
    private IChangeSet changeSet;
    private List<? extends IAuditableHandle> links;
    private List<URI> remoteURIs;

    public SaveClosedChangeSetOperationData(IChangeSet changeSet, ChangeType changeType) {
        if (changeSet == null) {
            throw new IllegalArgumentException("changeSet cannot be null");
        }
        if (changeType == null) {
            throw new IllegalArgumentException("changeType cannot be null");
        }
        this.changeSet = changeSet;
        this.changeType = changeType;
        this.links = Collections.EMPTY_LIST;
        this.remoteURIs = Collections.EMPTY_LIST;
    }

    public SaveClosedChangeSetOperationData(IChangeSet changeSet, ChangeType changeType, List<? extends IAuditableHandle> links) {
        this(changeSet, changeType);
        this.links = links == null ? Collections.EMPTY_LIST : links;
    }

    public SaveClosedChangeSetOperationData(IChangeSet changeSet, ChangeType changeType, ArrayList<URI> remoteURIs) {
        this(changeSet, changeType, new ArrayList());
        this.remoteURIs = remoteURIs == null ? Collections.EMPTY_LIST : remoteURIs;
    }

    public ChangeType getChangeType() {
        return this.changeType;
    }

    public void setChangeType(ChangeType changeType) {
        this.changeType = changeType;
    }

    public IChangeSet getChangeSet() {
        return this.changeSet;
    }

    public List<? extends IAuditableHandle> getLinks() {
        return this.links;
    }

    public List<URI> getRemoteLinks() {
        return this.remoteURIs;
    }

    public static enum ChangeType {
        COMMENT,
        ADD_LINK,
        REMOVE_LINK;

    }
}

