/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.fulltext.common.internal.analysis;

import com.ibm.team.fulltext.common.ArtifactToken;
import com.ibm.team.fulltext.common.TokenizerTypes;
import com.ibm.team.fulltext.common.internal.analysis.ArtifactAttribute;
import com.ibm.team.fulltext.common.internal.analysis.ArtifactAttributeImpl;
import com.ibm.team.fulltext.common.internal.analysis.SplitTokenFilter;
import com.ibm.team.fulltext.common.internal.util.QueryUtils;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.TermAttribute;

public final class NonAlphaNumSplitFilter
extends SplitTokenFilter {
    private final boolean fWildcardAware;

    public NonAlphaNumSplitFilter(TokenStream stream, boolean wildcardAware) {
        super(stream);
        this.fWildcardAware = wildcardAware;
    }

    @Override
    protected void splitToken(ArtifactAttribute token) {
        boolean splitWhitespaces = true;
        boolean splitNonAlphaNum = true;
        if (token.isArtifact()) {
            if (!token.applies(TokenizerTypes.SPLIT_WHITESPACE) && !token.applies(TokenizerTypes.SPLIT_NON_ALPHANUM)) {
                this.addToQueue(token);
                return;
            }
            splitWhitespaces = token.applies(TokenizerTypes.SPLIT_WHITESPACE);
            splitNonAlphaNum = token.applies(TokenizerTypes.SPLIT_NON_ALPHANUM);
        }
        int tokenStart = -1;
        StringBuilder buffer = new StringBuilder();
        String text = token.term();
        int offset = 0;
        while (offset < text.length()) {
            char ch = text.charAt(offset);
            boolean split = false;
            boolean isCJK = false;
            boolean isThai = QueryUtils.isThai(ch);
            boolean isWhitespace = Character.isWhitespace(ch);
            boolean isWildcard = this.isWildcard(ch);
            if (isWhitespace && splitWhitespaces) {
                split = true;
            } else if (isWildcard && !this.fWildcardAware) {
                split = true;
            } else if (!(isWhitespace || isWildcard || !splitNonAlphaNum || QueryUtils.isJapaneseSymbol(ch) || isThai || Character.isLetterOrDigit(ch))) {
                split = true;
            }
            if (!split) {
                if (tokenStart == -1) {
                    tokenStart = offset + token.startOffset();
                }
                buffer.append(ch);
                isCJK = QueryUtils.isCJK(ch);
            }
            if (split || isCJK || isThai) {
                this.addToQueue(buffer, tokenStart, token, isCJK || isThai);
                buffer.setLength(0);
                tokenStart = -1;
            }
            ++offset;
        }
        if (buffer.length() > 0) {
            this.addToQueue(buffer, tokenStart, token, false);
        }
    }

    private boolean isWildcard(char ch) {
        return ch == '?' || ch == '*';
    }

    private void addToQueue(StringBuilder buffer, int start, ArtifactAttribute initial, boolean overrideLengthCheck) {
        if (overrideLengthCheck || buffer.length() > 1 || buffer.length() == 1 && Character.isDigit(buffer.charAt(0))) {
            this.addToQueue((TermAttribute)this.createToken(buffer.toString(), start, start + buffer.length(), initial));
        }
    }

    private Token createToken(String value, int start, int end, ArtifactAttribute initial) {
        if (initial instanceof ArtifactToken) {
            return ((ArtifactToken)((Object)initial)).clone(value, start, end);
        }
        if (initial instanceof ArtifactAttributeImpl) {
            return ((ArtifactAttributeImpl)initial).toToken(value, start, end);
        }
        return new Token(value, start, end);
    }
}

