/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.copyfileareas.migration;

import com.ibm.team.filesystem.client.internal.copyfileareas.migration.CaseInsensitiveString;
import com.ibm.team.filesystem.client.internal.copyfileareas.migration.DiskBackedHashMapEntriesValidator;
import com.ibm.team.filesystem.client.internal.copyfileareas.migration.ForwardInfo;
import com.ibm.team.filesystem.client.internal.copyfileareas.migration.GlobalMetadataValidator;
import com.ibm.team.filesystem.client.internal.copyfileareas.migration.HeapValidator;
import com.ibm.team.filesystem.common.FileLineDelimiter;
import com.ibm.team.internal.repository.rcp.util.RAFWrapper;
import com.ibm.team.repository.common.utils.HashCode;
import java.io.File;
import java.io.IOException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class ItemInfoMapValidator
extends DiskBackedHashMapEntriesValidator {
    protected static final int STRING_TAG = 1;
    protected static final int FILE_ITEM_INFO_TAG = 2;
    protected static final int METADATA_VERSION = 4;
    protected static final int METADATA_VERSION_M5D1 = 5;
    protected static final int METADATA_VERSION_M6D1 = 6;
    protected static final int METADATA_VERSION_RC1 = 7;
    protected static final long NULL_CHECKSUM = -1L;
    protected boolean isCaseSensitive;
    protected File cfaRoot;
    protected IPath subPath;

    public ItemInfoMapValidator(File rootPath, boolean isCaseSensitive, HeapValidator hv, GlobalMetadataValidator gv) throws IOException {
        super(hv, gv);
        this.cfaRoot = rootPath;
        this.isCaseSensitive = isCaseSensitive;
    }

    @Override
    public void beginValidation() throws IOException {
        super.beginValidation();
        if (!this.hv.getHeapFile().getName().equals(".iteminfo.dat")) {
            this.log.append("Invalid item info map file name " + this.hv.getHeapFile() + "\n");
        }
        this.subPath = new Path(this.hv.getHeapFile().getCanonicalPath()).removeFirstSegments(new Path(this.cfaRoot.getCanonicalPath()).segmentCount()).removeLastSegments(1).setDevice(null).makeUNC(false).removeTrailingSeparator().makeAbsolute();
    }

    @Override
    public void validateEntry(long entryOffset, long keyOffset, boolean keyIsHeapADT, long valueOffset, boolean valueIsHeapADT, int hash, RAFWrapper raf) throws IOException {
        if (keyIsHeapADT) {
            this.log.append("HeapADT attribute unexpectedly set on item info key of entry at " + entryOffset + "\n");
        }
        if (valueIsHeapADT) {
            this.log.append("HeapADT attribute unexpectedly set on item info value of entry at " + entryOffset + "\n");
        }
        IPath path = this.validateKey(entryOffset, keyOffset, hash, raf);
        ForwardInfo info = this.validateValue(entryOffset, valueOffset, raf);
        if (path != null && info.getItemId() != null) {
            this.gv.addForwardInfo(path, info);
        }
    }

    protected IPath validateKey(long entryOffset, long keyOffset, int hashCode, RAFWrapper raf) throws IOException {
        if (keyOffset < 0L || keyOffset >= this.hv.getWorkingAreaSize()) {
            this.log.append("The item info key pointer is at an impossible location " + keyOffset + " at " + entryOffset + "\n");
            return null;
        }
        this.setPosition(keyOffset);
        IPath result = null;
        try {
            String name;
            int tag = this.validateByte("item info key", keyOffset, "tag", raf);
            if (tag == -1) {
                return null;
            }
            if (tag != 1) {
                this.log.append("Unexpected tag found instead of STRING_TAG " + tag + " at offset " + keyOffset + "\n");
            }
            if ((name = this.validateString("item info key", keyOffset, "name", raf)) != null) {
                result = this.subPath.append(name);
                if (!Path.ROOT.isValidSegment(name)) {
                    this.log.append("The item name \"" + name + "\" at offset " + keyOffset + " is not valid\n");
                }
                String hashName = !this.isCaseSensitive ? name.toUpperCase().toLowerCase() : name;
                this.addKey(new CaseInsensitiveString(hashName, name), entryOffset, keyOffset, "item info");
                if (hashCode != hashName.hashCode()) {
                    this.log.append("The entry at " + entryOffset + " contains a hash code (" + hashCode + ") for item info key at " + keyOffset + " with name \"" + name + "\" and hash name \"" + hashName + "\" whose hash code is " + hashName.hashCode() + "\n");
                }
            }
        }
        finally {
            this.hv.claim(new HeapValidator.HeapClaimant(keyOffset, this.getPosition() - keyOffset, "Item Info Key"));
        }
        return result;
    }

    protected ForwardInfo validateValue(long entryOffset, long valueOffset, RAFWrapper raf) throws IOException {
        ForwardInfo result = new ForwardInfo();
        result.setLastModification(-1L);
        result.setLocalSize(-1L);
        result.setRemoteSize(-1L);
        result.setRemoteChecksum(-1L);
        result.setNumLineDelimiters(-1L);
        if (valueOffset < 0L || valueOffset > this.hv.getWorkingAreaSize()) {
            this.log.append("The item info value pointer is at an impossible location " + valueOffset + " at " + entryOffset + "\n");
            return result;
        }
        this.setPosition(valueOffset);
        try {
            int hasParent;
            long version;
            int tag = this.validateByte("item info value", valueOffset, "tag", raf);
            if (tag == -1) {
                ForwardInfo forwardInfo = result;
                return forwardInfo;
            }
            if (tag != 2) {
                this.log.append("Unexpected tag found instead of FILE_ITEM_INFO_TAG " + tag + " at offset " + valueOffset + "\n");
            }
            if ((version = this.validateInt("item info value", valueOffset, "version", raf)) == -1L) {
                ForwardInfo forwardInfo = result;
                return forwardInfo;
            }
            switch ((int)version) {
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    break;
                }
                default: {
                    this.log.append("Unexpected version found " + version + " at offset " + valueOffset + "\n");
                }
            }
            int isFolder = this.validateByte("item info value", valueOffset, "isFolder", raf);
            if (isFolder == -1) {
                ForwardInfo forwardInfo = result;
                return forwardInfo;
            }
            if ((isFolder & 0xFFFFFFFE) != 0) {
                this.log.append("Unexpected value found for isFolder " + isFolder + " at offset " + valueOffset + "\n");
            }
            result.setFolder(isFolder != 0);
            String itemHandle = this.validateHandle("item info value", valueOffset, "item", raf);
            if (itemHandle != null) {
                String itemId = itemHandle;
                String stateId = null;
                int idx = itemHandle.indexOf(124);
                if (idx != -1) {
                    itemId = itemHandle.substring(0, idx);
                    stateId = itemHandle.substring(idx + 1);
                }
                result.setItemId(itemId);
                result.setStateId(stateId);
            }
            if (isFolder == 0) {
                long[] lastMod = this.validateLong("item info value", valueOffset, "last modification", raf);
                if (lastMod[1] == -1L) {
                    ForwardInfo forwardInfo = result;
                    return forwardInfo;
                }
                if (lastMod[0] != -1L && itemHandle != null && itemHandle.indexOf(124) == -1) {
                    this.log.append("File \"" + itemHandle + "\" has no state id but has modification stamp " + lastMod[0] + " at " + valueOffset + "\n");
                }
                result.setLastModification(lastMod[0]);
            }
            if ((hasParent = this.validateByte("item info value", valueOffset, "hasParent", raf)) == -1) {
                ForwardInfo forwardInfo = result;
                return forwardInfo;
            }
            if ((hasParent & 0xFFFFFFFE) != 0) {
                this.log.append("Unexpected value found for hasParent " + hasParent + " at offset " + valueOffset + "\n");
            }
            if (hasParent != 0) {
                String parent = this.validateHandle("item info value", valueOffset, "parent folder", raf);
                result.setRemoteParentId(parent);
                String name = this.validateString("item info value", valueOffset, "parent folder name", raf);
                if (name != null && !Path.ROOT.isValidSegment(name)) {
                    this.log.append("The parent name \"" + name + "\" at offset " + valueOffset + " is not valid\n");
                }
                if (itemHandle != null && itemHandle.indexOf(124) == -1) {
                    this.log.append("The item \"" + itemHandle + "\" has a remote parent, but no state id at offset " + valueOffset + "\n");
                }
                result.setRemoteName(name);
            } else if (isFolder == 0 && itemHandle != null && itemHandle.indexOf(124) != -1) {
                this.log.append("The file \"" + itemHandle + "\" has a state id, but no remote parent at offset " + valueOffset + "\n");
            }
            int hasHash = this.validateByte("item info value", valueOffset, "hasHash", raf);
            if (hasHash == -1) {
                ForwardInfo forwardInfo = result;
                return forwardInfo;
            }
            if ((hasHash & 0xFFFFFFFE) != 0) {
                this.log.append("Unexpected value found for hasHash " + hasHash + " at offset " + valueOffset + "\n");
            }
            if (hasHash != 0) {
                long[] hash;
                if (isFolder != 0) {
                    this.log.append("Unexpected folder has hash at " + valueOffset + "\n");
                }
                if ((hash = this.validateLong("item info value", valueOffset, "hash", raf))[1] == -1L) {
                    ForwardInfo forwardInfo = result;
                    return forwardInfo;
                }
                result.setLocalChecksum(new HashCode(hash[0]));
            } else if (isFolder == 0 && hasParent != 0) {
                this.log.append("Unexpected file has no hash but has remote parent at " + valueOffset + "\n");
            }
            long[] localSize = this.validateLong("inverse item info value", valueOffset, "size", raf);
            if (localSize[1] == -1L) {
                ForwardInfo forwardInfo = result;
                return forwardInfo;
            }
            if (localSize[0] == -1L) {
                if (isFolder == 0 && hasParent != 0) {
                    this.log.append("Unexpected file has no size but has remote parent at " + valueOffset + "\n");
                }
            } else if (isFolder != 0) {
                this.log.append("Folder at " + valueOffset + " has localSize " + localSize[0] + "\n");
            } else if (hasParent == 0) {
                this.log.append("File at " + valueOffset + " has localSize " + localSize[0] + " but no remote parent\n");
            }
            result.setLocalSize(localSize[0]);
            if (version >= 5L) {
                int currentLineDelimiterPresent;
                int origLineDelimiterPresent = this.validateByte("inverse item info value", valueOffset, "origLineDelimiterPresent", raf);
                if (origLineDelimiterPresent == -1) {
                    ForwardInfo forwardInfo = result;
                    return forwardInfo;
                }
                if ((origLineDelimiterPresent & 0xFFFFFFFE) != 0) {
                    this.log.append("Unexpected value found for origLineDelimiterPresent " + origLineDelimiterPresent + " at offset " + valueOffset + "\n");
                }
                long origLineDelimiterOrd = -1L;
                if (origLineDelimiterPresent != 0) {
                    origLineDelimiterOrd = this.validateInt("inverse item info value", valueOffset, "origLineDelimiter", raf);
                    if (isFolder != 0) {
                        this.log.append("Folder at offset " + valueOffset + " has original line delimiter \"" + origLineDelimiterOrd + "\"\n");
                    } else if (hasParent == 0) {
                        this.log.append("File at " + valueOffset + " has original line delimiter \"" + origLineDelimiterOrd + "\" but no remote parent\n");
                    }
                    if (origLineDelimiterOrd == -1L) {
                        ForwardInfo forwardInfo = result;
                        return forwardInfo;
                    }
                    FileLineDelimiter origLineDelimiter = this.validateLineDelimeter((int)origLineDelimiterOrd, "inverse item info value", valueOffset, "origLineDelimiter");
                    result.setRemoteLineDelimiter(origLineDelimiter);
                }
                if ((currentLineDelimiterPresent = this.validateByte("inverse item info value", valueOffset, "currentLineDelimiterPresent", raf)) == -1) {
                    ForwardInfo forwardInfo = result;
                    return forwardInfo;
                }
                if ((currentLineDelimiterPresent & 0xFFFFFFFE) != 0) {
                    this.log.append("Unexpected value found for currentLineDelimiterPresent " + currentLineDelimiterPresent + " at offset " + valueOffset + "\n");
                }
                if (currentLineDelimiterPresent != 0) {
                    long currentLineDelimiterOrd = this.validateInt("inverse item info value", valueOffset, "currentLineDelimiter", raf);
                    if (isFolder != 0) {
                        this.log.append("Folder entry at offset " + valueOffset + " has current line delimiter \"" + currentLineDelimiterOrd + "\"\n");
                    }
                    if (currentLineDelimiterOrd == -1L) {
                        ForwardInfo forwardInfo = result;
                        return forwardInfo;
                    }
                    FileLineDelimiter currentLineDelimiter = this.validateLineDelimeter((int)currentLineDelimiterOrd, "inverse item info value", valueOffset, "currentLineDelimiter");
                    result.setLocalLineDelimiter(currentLineDelimiter);
                } else if (isFolder == 0 && origLineDelimiterPresent != 0) {
                    this.log.append("File entry at offset " + valueOffset + " has original line delimiter but not a current one\n");
                }
                int origContentTypePresent = this.validateByte("inverse item info value", valueOffset, "origContentTypePresent", raf);
                if (origContentTypePresent == -1) {
                    ForwardInfo forwardInfo = result;
                    return forwardInfo;
                }
                if ((origContentTypePresent & 0xFFFFFFFE) != 0) {
                    this.log.append("Unexpected value found for origContentTypePresent " + origContentTypePresent + " at offset " + valueOffset + "\n");
                }
                if (origContentTypePresent != 0) {
                    String origContentType = this.validateString("inverse item info value", valueOffset, "origContentType", raf);
                    if (isFolder != 0) {
                        this.log.append("Folder at offset " + valueOffset + " has original content type \"" + origContentType + "\"\n");
                    } else if (hasParent == 0) {
                        this.log.append("File at " + valueOffset + " has original content type \"" + origContentType + "\" but no remote parent\n");
                    }
                    if (origLineDelimiterPresent == 0) {
                        this.log.append("Item at " + valueOffset + " has original content type \"" + origContentType + "\" but no original line delimiter\n");
                    }
                    result.setRemoteContentType(origContentType);
                } else if (origLineDelimiterPresent != 0) {
                    this.log.append("Item at " + valueOffset + " has original line delimiter \"" + origLineDelimiterOrd + "\" but no original content type\n");
                }
                int currentContentTypePresent = this.validateByte("inverse item info value", valueOffset, "currentContentTypePresent", raf);
                if (currentContentTypePresent == -1) {
                    ForwardInfo forwardInfo = result;
                    return forwardInfo;
                }
                if ((currentContentTypePresent & 0xFFFFFFFE) != 0) {
                    this.log.append("Unexpected value found for currentContentTypePresent " + currentContentTypePresent + " at offset " + valueOffset + "\n");
                }
                if (currentContentTypePresent != 0) {
                    String currentContentType = this.validateString("inverse item info value", valueOffset, "currentContentType", raf);
                    if (isFolder != 0) {
                        this.log.append("Folder entry at offset " + valueOffset + " has current content type \"" + currentContentType + "\"\n");
                    }
                    result.setLocalContentType(currentContentType);
                } else if (isFolder == 0 && origContentTypePresent != 0) {
                    this.log.append("File entry at offset " + valueOffset + " has original content type but not a current one\n");
                }
                if (version >= 6L) {
                    long[] checksumInRepo;
                    long[] sizeInRepo;
                    int deltaPredecessorPresent;
                    int contentIdPresent = this.validateByte("inverse item info value", valueOffset, "contentIdPresent", raf);
                    if (contentIdPresent == -1) {
                        ForwardInfo forwardInfo = result;
                        return forwardInfo;
                    }
                    if ((contentIdPresent & 0xFFFFFFFE) != 0) {
                        this.log.append("Unexpected value found for contentIdPresent " + contentIdPresent + " at offset " + valueOffset + "\n");
                    }
                    String contentId = null;
                    if (contentIdPresent != 0) {
                        contentId = this.validateUUID("inverse item info value", valueOffset, "contentId", raf);
                        if (isFolder != 0) {
                            this.log.append("Folder at offset " + valueOffset + " has content id \"" + contentId + "\"\n");
                        } else if (hasParent == 0) {
                            this.log.append("File at " + valueOffset + " has content id \"" + contentId + "\" but no remote parent\n");
                        }
                        if (origLineDelimiterPresent == 0) {
                            this.log.append("Item at " + valueOffset + " has content id \"" + contentId + "\" but no original line delimiter\n");
                        }
                        if (origContentTypePresent == 0) {
                            this.log.append("Item at " + valueOffset + " has content id \"" + contentId + "\" but no original content type\n");
                        }
                        result.setContentId(contentId);
                    }
                    if ((deltaPredecessorPresent = this.validateByte("inverse item info value", valueOffset, "deltaPredecessorPresent", raf)) == -1) {
                        ForwardInfo forwardInfo = result;
                        return forwardInfo;
                    }
                    if ((deltaPredecessorPresent & 0xFFFFFFFE) != 0) {
                        this.log.append("Unexpected value found for deltaPredecessorPresent " + deltaPredecessorPresent + " at offset " + valueOffset + "\n");
                    }
                    if (deltaPredecessorPresent != 0) {
                        String deltaPredecessor = this.validateUUID("inverse item info value", valueOffset, "deltaPredecessor", raf);
                        if (isFolder != 0) {
                            this.log.append("Folder at offset " + valueOffset + " has delta predecessor \"" + deltaPredecessor + "\"\n");
                        } else if (hasParent == 0) {
                            this.log.append("File at " + valueOffset + " has delta predecessor \"" + deltaPredecessor + "\" but no remote parent\n");
                        }
                        if (contentIdPresent == 0) {
                            this.log.append("Item at " + valueOffset + " has delta predecessor \"" + deltaPredecessor + "\" but no content id\n");
                        }
                        result.setDeltaPredecessor(deltaPredecessor);
                    }
                    if ((sizeInRepo = this.validateLong("inverse item info value", valueOffset, "sizeInRepo", raf))[1] == -1L) {
                        ForwardInfo forwardInfo = result;
                        return forwardInfo;
                    }
                    if (sizeInRepo[0] != -1L) {
                        if (isFolder != 0) {
                            this.log.append("Folder at offset " + valueOffset + " has size in repo \"" + sizeInRepo[0] + "\"\n");
                        } else if (hasParent == 0) {
                            this.log.append("File at " + valueOffset + " has size in repo \"" + sizeInRepo[0] + "\" but no remote parent\n");
                        }
                        if (contentIdPresent == 0) {
                            this.log.append("Item at " + valueOffset + " has size in repo \"" + sizeInRepo[0] + "\" but no content id\n");
                        }
                    } else if (contentIdPresent != 0) {
                        this.log.append("Item at " + valueOffset + " has content id \"" + contentId + "\" but no size in repo\n");
                    }
                    result.setRemoteSize(sizeInRepo[0]);
                    int contentEncodingPresent = this.validateByte("inverse item info value", valueOffset, "contentEncodingPresent", raf);
                    if (contentEncodingPresent == -1) {
                        ForwardInfo forwardInfo = result;
                        return forwardInfo;
                    }
                    if ((contentEncodingPresent & 0xFFFFFFFE) != 0) {
                        this.log.append("Unexpected value found for contentEncodingPresent " + contentEncodingPresent + " at offset " + valueOffset + "\n");
                    }
                    if (contentEncodingPresent != 0) {
                        String encoding = this.validateString("inverse item info value", valueOffset, "contentEncoding", raf);
                        if (isFolder != 0) {
                            this.log.append("Folder at offset " + valueOffset + " has content encoding \"" + encoding + "\"\n");
                        } else if (hasParent == 0) {
                            this.log.append("File at " + valueOffset + " has content encoding \"" + encoding + "\" but no remote parent\n");
                        }
                        if (contentIdPresent == 0) {
                            this.log.append("Item at " + valueOffset + " has content encoding \"" + encoding + "\" but no content id\n");
                        }
                        result.setRemoteEncoding(encoding);
                    }
                    if ((checksumInRepo = this.validateLong("inverse item info value", valueOffset, "checksumInRepo", raf))[1] == -1L) {
                        ForwardInfo forwardInfo = result;
                        return forwardInfo;
                    }
                    if (checksumInRepo[0] != -1L) {
                        if (isFolder != 0) {
                            this.log.append("Folder at offset " + valueOffset + " has checksum in repo \"" + checksumInRepo[0] + "\"\n");
                        } else if (hasParent == 0) {
                            this.log.append("File at " + valueOffset + " has checksum in repo \"" + checksumInRepo[0] + "\" but no remote parent\n");
                        }
                        if (contentIdPresent == 0) {
                            this.log.append("Item at " + valueOffset + " has checksum in repo \"" + checksumInRepo[0] + "\" but no content id\n");
                        }
                    } else if (contentIdPresent != 0) {
                        this.log.append("Item at " + valueOffset + " has content id \"" + contentId + "\" but no checksum in repo\n");
                    }
                    result.setRemoteChecksum(checksumInRepo[0]);
                    long[] numDelimiters = this.validateLong("inverse item info value", valueOffset, "numDelimiters", raf);
                    if (numDelimiters[1] == -1L) {
                        ForwardInfo forwardInfo = result;
                        return forwardInfo;
                    }
                    if (numDelimiters[0] != -1L) {
                        if (isFolder != 0) {
                            this.log.append("Folder at offset " + valueOffset + " has num delimiters \"" + numDelimiters[0] + "\"\n");
                        } else if (hasParent == 0) {
                            this.log.append("File at " + valueOffset + " has num delimiters \"" + numDelimiters[0] + "\" but no remote parent\n");
                        }
                        if (contentIdPresent == 0) {
                            this.log.append("Item at " + valueOffset + " has num delimiters \"" + numDelimiters[0] + "\" but no content id\n");
                        }
                    }
                    result.setNumLineDelimiters(numDelimiters[0]);
                    if (version >= 7L && isFolder == 0) {
                        int isExecutable = this.validateByte("inverse item info value", valueOffset, "isExecutable", raf);
                        if (isExecutable == -1) {
                            ForwardInfo forwardInfo = result;
                            return forwardInfo;
                        }
                        if ((isExecutable & 0xFFFFFFFE) != 0) {
                            this.log.append("Unexpected value found for isExecutable " + isExecutable + " at offset " + valueOffset + "\n");
                        }
                        result.setLocalExecutable(isExecutable != 0);
                        int isOrigExecutable = this.validateByte("inverse item info value", valueOffset, "isOrigExecutable", raf);
                        if (isOrigExecutable == -1) {
                            ForwardInfo forwardInfo = result;
                            return forwardInfo;
                        }
                        if ((isOrigExecutable & 0xFFFFFFFE) != 0) {
                            this.log.append("Unexpected value found for isOrigExecutable " + isOrigExecutable + " at offset " + valueOffset + "\n");
                        }
                        result.setRemoteExecutable(isOrigExecutable != 0);
                    }
                }
            }
        }
        finally {
            this.hv.claim(new HeapValidator.HeapClaimant(valueOffset, this.getPosition() - valueOffset, "Item Info Value"));
        }
        return result;
    }
}

