/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.load;

import com.ibm.team.filesystem.client.ILocation;
import com.ibm.team.filesystem.client.IRelativeLocation;
import com.ibm.team.filesystem.client.ISandbox;
import com.ibm.team.filesystem.client.operations.ILoadLocation;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IVersionableHandle;

public class LoadLocation
implements ILoadLocation {
    private final ISandbox sandbox;
    private final IRelativeLocation relativeLoadPath;
    private final String name;
    private final ILocation fullPath;
    private final IConnection connection;
    private final IComponent component;
    private final IVersionableHandle itemToLoad;
    private final boolean loadWithAnotherName;

    public LoadLocation(ISandbox sandbox, IRelativeLocation relativeLoadPath, String name, IConnection connection, IComponent component, IVersionableHandle itemToLoad, boolean isLoadWithAnotherName) throws TeamRepositoryException {
        this.sandbox = sandbox;
        this.relativeLoadPath = relativeLoadPath;
        this.name = name;
        this.fullPath = sandbox.getRoot().append(relativeLoadPath).append(name);
        this.connection = connection;
        this.component = component;
        this.itemToLoad = itemToLoad;
        this.loadWithAnotherName = isLoadWithAnotherName;
    }

    @Override
    public IComponent getComponent() {
        return this.component;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.connection == null ? 0 : this.connection.hashCode());
        result = 31 * result + (this.component == null ? 0 : this.component.getItemId().hashCode());
        result = 31 * result + (this.fullPath == null ? 0 : this.fullPath.hashCode());
        result = 31 * result + (this.itemToLoad == null ? 0 : this.itemToLoad.getItemId().hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LoadLocation other = (LoadLocation)obj;
        if (this.connection == null ? other.connection != null : !this.connection.equals(other.connection)) {
            return false;
        }
        if (this.component == null ? other.component != null : !this.component.sameItemId((IItemHandle)other.component)) {
            return false;
        }
        if (this.fullPath == null ? other.fullPath != null : !this.fullPath.equals(other.fullPath)) {
            return false;
        }
        return !(this.itemToLoad == null ? other.itemToLoad != null : !this.itemToLoad.sameItemId((IItemHandle)other.itemToLoad));
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getComponent().getName());
        sb.append('/');
        sb.append(this.fullPath.toString());
        return sb.toString();
    }

    @Override
    public IConnection getConnection() {
        return this.connection;
    }

    @Override
    public ISandbox getSandbox() {
        return this.sandbox;
    }

    @Override
    public IRelativeLocation getLoadPath() {
        return this.relativeLoadPath.append(this.name);
    }

    @Override
    public IVersionableHandle getRootToLoad() {
        return this.itemToLoad;
    }

    public ILocation getFullPath() {
        return this.fullPath;
    }

    public boolean isLoadWithAnotherName() {
        return this.loadWithAnotherName;
    }
}

