/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.localchanges;

import com.ibm.team.filesystem.client.IRelativeLocation;
import com.ibm.team.filesystem.client.internal.localchanges.LocalChange;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.Assert;

public class LocalChangeNode {
    private Set<LocalChange> changes;
    private Map<String, LocalChangeNode> children;
    private LocalChangeNode parent;
    private String name;

    public LocalChangeNode(String name, LocalChangeNode parent) {
        this.name = name;
        this.parent = parent;
        this.changes = Collections.EMPTY_SET;
        this.children = Collections.EMPTY_MAP;
    }

    public boolean basicAccept(IVisitor visitor) {
        boolean hasChange;
        boolean recurse;
        if (this.changes.isEmpty()) {
            recurse = true;
            hasChange = false;
        } else {
            recurse = false;
            hasChange = true;
            for (LocalChange change : this.changes) {
                if (!visitor.visit(change)) continue;
                recurse = true;
            }
        }
        if (!recurse) {
            return hasChange || !this.children.isEmpty();
        }
        Iterator<LocalChangeNode> i = this.children.values().iterator();
        while (i.hasNext()) {
            LocalChangeNode current = i.next();
            boolean hasChanges = current.basicAccept(visitor);
            if (!hasChanges) {
                i.remove();
            }
            hasChange |= hasChanges;
        }
        return hasChange;
    }

    public void collect(final Collection collected) {
        this.basicAccept(new IVisitor(){

            @Override
            public boolean visit(LocalChange toVisit) {
                if (!toVisit.isCanceled()) {
                    collected.add(toVisit);
                }
                return true;
            }
        });
    }

    public Set<LocalChange> getChanges() {
        return this.changes;
    }

    public Collection getChildren() {
        return this.children.values();
    }

    public LocalChangeNode getNode(IRelativeLocation path, boolean create) {
        return this.internalGetNode(path, 0, create);
    }

    LocalChangeNode internalGetNode(IRelativeLocation path, int level, boolean create) {
        Assert.isTrue((level <= path.segmentCount() ? 1 : 0) != 0);
        boolean sameLevel = level == path.segmentCount() - 1;
        LocalChangeNode child = this.children.get(path.segment(level));
        if (child == null) {
            if (!create) {
                return null;
            }
            if (this.children.isEmpty()) {
                this.children = new HashMap<String, LocalChangeNode>();
            }
            child = new LocalChangeNode(path.segment(level), this);
            this.children.put(path.segment(level), child);
        }
        return sameLevel ? child : child.internalGetNode(path, level + 1, true);
    }

    public void addChange(LocalChange newChange) {
        Assert.isNotNull((Object)newChange);
        Assert.isTrue((newChange.isCanceled() || newChange.getTarget() != null ? 1 : 0) != 0);
        if (this.changes.isEmpty()) {
            this.changes = new HashSet<LocalChange>();
        }
        this.changes.add(newChange);
    }

    public void removeChange(LocalChange toRemove) {
        this.changes.remove(toRemove);
        if (this.changes.isEmpty()) {
            this.changes = Collections.EMPTY_SET;
        }
    }

    public void prune() {
        this.changes = Collections.EMPTY_SET;
        this.children = Collections.EMPTY_MAP;
    }

    public static interface IVisitor {
        public boolean visit(LocalChange var1);
    }
}

