/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.namespace.impl;

import com.ibm.team.filesystem.client.FileSystemCore;
import com.ibm.team.filesystem.client.IFileSystemView;
import com.ibm.team.filesystem.client.internal.era.EraDescriptor;
import com.ibm.team.filesystem.client.internal.namespace.BaselineNamespace;
import com.ibm.team.filesystem.client.internal.namespace.impl.AbstractConfigurationContext;
import com.ibm.team.filesystem.client.internal.namespace.impl.ContextNameUtil;
import com.ibm.team.filesystem.common.IFileItem;
import com.ibm.team.filesystem.common.IFileItemHandle;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.scm.client.IBaselineConnection;
import com.ibm.team.scm.client.IConfiguration;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.common.IBaseline;
import com.ibm.team.scm.common.IChangeSet;
import com.ibm.team.scm.common.IChangeSetHandle;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.internal.util.ItemId;
import com.ibm.team.scm.common.internal.util.ItemLists;
import com.ibm.team.scm.common.internal.util.StateId;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;

public final class BaselineContext
extends AbstractConfigurationContext {
    private IBaselineConnection baseline;
    private IConfiguration configuration;
    private EraDescriptor cachedChangeSets;
    private String name;

    public BaselineContext(IBaselineConnection baseline) throws TeamRepositoryException {
        super(BaselineNamespace.create(baseline));
        this.baseline = baseline;
        this.name = ContextNameUtil.getContextName(baseline);
        this.configuration = baseline.configuration();
    }

    @Override
    public IConfiguration getConfiguration() {
        return this.configuration;
    }

    @Override
    public IConnection getConnection() {
        return this.baseline;
    }

    @Override
    public EraDescriptor getChangeSets(IProgressMonitor monitor) throws TeamRepositoryException {
        if (this.cachedChangeSets == null) {
            this.cachedChangeSets = EraDescriptor.createStaticDescriptor(this.baseline.changeHistory());
        }
        return this.cachedChangeSets;
    }

    @Override
    public ItemId<IComponent> getComponent() {
        return ItemId.create((IItemHandle)this.baseline.getComponent());
    }

    @Override
    public void refresh(IProgressMonitor monitor) throws TeamRepositoryException {
        super.refresh(monitor);
    }

    @Override
    public boolean isLive() {
        return false;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public List<ItemId<IChangeSet>> getBlame(StateId<IFileItem> fileItemHandle, ItemId<IChangeSet> changeSetHandle, IProgressMonitor monitor) throws TeamRepositoryException {
        IFileSystemView fsview = FileSystemCore.getFileSystemManager(this.baseline.teamRepository()).getFileSystemView((IConnection)this.baseline);
        return ItemLists.handlesToIds((Collection)fsview.getBlame(this.baseline.getComponent(), (IFileItemHandle)fileItemHandle.toHandle(), (IChangeSetHandle)changeSetHandle.toHandle(), monitor));
    }

    public ItemId<IBaseline> getBaselineId() {
        return new ItemId((IItemHandle)this.baseline.getBaseline());
    }
}

