/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.operations;

import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.internal.Messages;
import com.ibm.team.filesystem.client.internal.operations.AbstractCurrentPortOperation;
import com.ibm.team.filesystem.client.internal.utils.ConfigurationFacade;
import com.ibm.team.filesystem.client.operations.CompleteCurrentPatchDilemmaHandler;
import com.ibm.team.filesystem.client.operations.ICompleteCurrentPatchOperation;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.ICurrentPatch;
import com.ibm.team.scm.common.IVersionableChange;
import java.util.ArrayList;
import java.util.HashSet;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;

public class CompleteCurrentPortOperation
extends AbstractCurrentPortOperation
implements ICompleteCurrentPatchOperation {
    private int flags;

    public CompleteCurrentPortOperation(CompleteCurrentPatchDilemmaHandler dilemmaHandler) {
        super(dilemmaHandler == null ? CompleteCurrentPatchDilemmaHandler.getDefault() : dilemmaHandler);
    }

    @Override
    protected String getOperationLabel() {
        return Messages.CompleteCurrentPortOperation_0;
    }

    @Override
    protected void doExecute(HashSet<ConfigurationFacade> configurationsToLock, IProgressMonitor monitor) throws TeamRepositoryException, FileSystemException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)configurationsToLock.size());
        for (ConfigurationFacade configurationFacade : configurationsToLock) {
            IWorkspaceConnection wc = (IWorkspaceConnection)configurationFacade.getCachedConnection();
            IComponentHandle componentHandle = configurationFacade.getComponentHandle();
            ICurrentPatch currentPort = wc.getCurrentPatch(componentHandle);
            this.resolvePendingChanges(currentPort);
            wc.completeCurrentPatch(componentHandle, this.getFlags(), (IProgressMonitor)progress.newChild(1));
        }
    }

    @Override
    public CompleteCurrentPatchDilemmaHandler getDilemmaHandler() {
        return (CompleteCurrentPatchDilemmaHandler)super.getDilemmaHandler();
    }

    private void resolvePendingChanges(ICurrentPatch currentPort) throws FileSystemException {
        ArrayList<IVersionableChange> outstandingChanges = new ArrayList<IVersionableChange>();
        for (IVersionableChange change : currentPort.getVersionableChanges()) {
            if (change.isResolved()) continue;
            outstandingChanges.add(change);
        }
        if (outstandingChanges.isEmpty()) {
            return;
        }
        int result = this.getDilemmaHandler().unresolvedChanges(outstandingChanges);
        if (result == 0) {
            return;
        }
        if (result == 1) {
            throw new OperationCanceledException();
        }
        throw new FileSystemException(Messages.CompleteCurrentPortOperation_1);
    }

    @Override
    public int getFlags() {
        return this.flags;
    }

    @Override
    public void setFlags(int flags) {
        this.flags = flags;
    }

    @Override
    public void completeCurrentPatch(IWorkspaceConnection connection, IComponentHandle component) {
        this.setContext(connection, component);
    }
}

