/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.process;

import com.ibm.team.filesystem.client.FileSystemCore;
import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.ISharingManager;
import com.ibm.team.filesystem.client.internal.LoggingHelper;
import com.ibm.team.filesystem.client.internal.Messages;
import com.ibm.team.filesystem.common.IFileItemHandle;
import com.ibm.team.process.common.IProcessConfigurationElement;
import com.ibm.team.process.common.advice.AdvisableOperation;
import com.ibm.team.process.common.advice.IAdvisorInfo;
import com.ibm.team.process.common.advice.IAdvisorInfoCollector;
import com.ibm.team.process.common.advice.IReportInfo;
import com.ibm.team.process.common.advice.runtime.IOperationAdvisor;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.scm.common.IChange;
import com.ibm.team.scm.common.IChangeSet;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IContextHandle;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.IWorkspace;
import com.ibm.team.scm.common.IWorkspaceHandle;
import com.ibm.team.scm.common.process.DeliverOperationData;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class AbstractShareableAdvisor
implements IOperationAdvisor {
    private static final String TAG_COMPONENTS = "components";
    private static final String TAG_COMPONENT = "component";
    private static final String ATTR_NAME = "name";
    private static final String DATA_TAG_DATA = "data";
    public static final String DATA_ATTR_FILE_ITEMID = "fileItemId";
    public static final String DATA_ATTR_FILE_NAME = "fileName";
    public static final String DATA_ATTR_COMPONENT_ITEMID = "componentItemId";
    public static final String DATA_ATTR_WORKSPACE_ITEMID = "workspaceItemId";
    private List<String> fComponents;

    protected void initialize(IProcessConfigurationElement advisorConfiguration) {
        this.fComponents = null;
        IProcessConfigurationElement[] children = advisorConfiguration.getChildren();
        int i = 0;
        while (i < children.length) {
            IProcessConfigurationElement child = children[i];
            if (child.getName().equals(TAG_COMPONENTS)) {
                IProcessConfigurationElement[] components = child.getChildren();
                this.fComponents = new ArrayList<String>();
                int j = 0;
                while (j < components.length) {
                    String componentName;
                    IProcessConfigurationElement element = components[j];
                    if (element.getName().equals(TAG_COMPONENT) && (componentName = element.getAttribute(ATTR_NAME)) != null) {
                        this.fComponents.add(componentName);
                    }
                    ++j;
                }
            }
            ++i;
        }
    }

    public void run(AdvisableOperation operation, IProcessConfigurationElement advisorConfiguration, IAdvisorInfoCollector collector, IProgressMonitor monitor) throws TeamRepositoryException {
        Object operationData = operation.getOperationData();
        if (!(operationData instanceof DeliverOperationData)) {
            return;
        }
        monitor.beginTask("", 1000);
        try {
            List changeSets;
            this.initialize(advisorConfiguration);
            DeliverOperationData data = (DeliverOperationData)operationData;
            IWorkspace sourceWorkspace = data.getSourceWorkspace();
            ITeamRepository teamRepository = (ITeamRepository)sourceWorkspace.getOrigin();
            try {
                changeSets = teamRepository.itemManager().fetchCompleteItems(data.getChangeSetHandles(), 0, (IProgressMonitor)new SubProgressMonitor(monitor, 50));
            }
            catch (TeamRepositoryException e) {
                LoggingHelper.log("com.ibm.team.filesystem.client", e);
                collector.addInfo((IReportInfo)collector.createExceptionInfo(Messages.AbstractShareableAdvisor_0, (Throwable)e));
                monitor.done();
                return;
            }
            SubMonitor changeSetMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.AbstractShareableAdvisor_1, (int)changeSets.size());
            for (IChangeSet changeSet : changeSets) {
                if (changeSet == null) {
                    collector.addInfo((IReportInfo)collector.createExceptionInfo(Messages.AbstractShareableAdvisor_2, (Throwable)new TeamRepositoryException(Messages.AbstractShareableAdvisor_3)));
                    continue;
                }
                IComponentHandle componentHandle = changeSet.getComponent();
                IComponent component = (IComponent)teamRepository.itemManager().getSharedItemIfKnown((IItemHandle)componentHandle);
                if (component != null && this.fComponents != null && !this.fComponents.contains(component.getName())) continue;
                int interval = 500;
                long stopTime = System.currentTimeMillis() + (long)interval;
                ArrayList<Object> problems = new ArrayList<Object>();
                List changes = changeSet.changes();
                SubMonitor changeMonitor = changeSetMonitor.newChild(1);
                changeMonitor.beginTask(Messages.AbstractShareableAdvisor_4, changes.size() * 2);
                for (IChange change : changes) {
                    int changeKind = change.kind();
                    if ((changeKind & 2) != 2 && changeKind != 1) {
                        changeMonitor.worked(1);
                        continue;
                    }
                    IVersionableHandle versionableHandle = change.afterState();
                    try {
                        ISharingManager sharingManager = FileSystemCore.getSharingManager();
                        Collection<IShareable> shareables = sharingManager.findShareables((IContextHandle)sourceWorkspace, componentHandle, versionableHandle, (IProgressMonitor)changeMonitor.newChild(1));
                        SubMonitor shareableMon = changeMonitor.newChild(shareables.size());
                        for (IShareable shareable : shareables) {
                            IVersionableHandle versionable;
                            IReportInfo problem = this.getShareableProblem(shareable, versionable = shareable.getVersionable((IProgressMonitor)shareableMon.newChild(1)), teamRepository, sourceWorkspace, componentHandle, collector, shareableMon.newChild(1));
                            if (problem == null) continue;
                            Exception dataException = null;
                            if (problem instanceof IAdvisorInfo) {
                                try {
                                    this.setProblemData((IAdvisorInfo)problem, (IWorkspaceHandle)sourceWorkspace, componentHandle, (IFileItemHandle)versionable, shareable.getLocalPath().getName());
                                }
                                catch (ParserConfigurationException e) {
                                    dataException = e;
                                }
                                catch (TransformerException e) {
                                    dataException = e;
                                }
                                catch (IOException e) {
                                    dataException = e;
                                }
                            }
                            problems.add(problem);
                            if (dataException != null) {
                                IAdvisorInfo exceptionInfo = collector.createExceptionInfo(Messages.AbstractShareableAdvisor_5, (Throwable)dataException);
                                exceptionInfo.setSeverity(2);
                                problems.add(exceptionInfo);
                            }
                            if (System.currentTimeMillis() <= stopTime) continue;
                            collector.addInfos(problems.toArray(new IReportInfo[problems.size()]));
                            problems.clear();
                            stopTime = System.currentTimeMillis() + (long)interval;
                        }
                    }
                    catch (FileSystemException e) {
                        collector.addInfo((IReportInfo)collector.createExceptionInfo(Messages.AbstractShareableAdvisor_6, (Throwable)((Object)e)));
                    }
                }
                changeMonitor.done();
                if (problems.size() <= 0) continue;
                collector.addInfos(problems.toArray(new IReportInfo[problems.size()]));
            }
        }
        finally {
            monitor.done();
        }
    }

    protected abstract IReportInfo getShareableProblem(IShareable var1, IVersionableHandle var2, ITeamRepository var3, IWorkspace var4, IComponentHandle var5, IAdvisorInfoCollector var6, SubMonitor var7) throws FileSystemException;

    protected abstract void appendToProblemData(Element var1, Object var2, Document var3);

    protected void setProblemData(IAdvisorInfo problem, IWorkspaceHandle workspaceHandle, IComponentHandle componentHandle, IFileItemHandle fileItem, String fileName) throws ParserConfigurationException, TransformerException, IOException {
        Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
        Element root = doc.createElement(DATA_TAG_DATA);
        if (workspaceHandle != null && componentHandle != null) {
            root.setAttribute(DATA_ATTR_WORKSPACE_ITEMID, workspaceHandle.getItemId().getUuidValue());
            root.setAttribute(DATA_ATTR_COMPONENT_ITEMID, componentHandle.getItemId().getUuidValue());
            root.setAttribute("sourceWorkspaceId", workspaceHandle.getItemId().getUuidValue());
        }
        doc.appendChild(root);
        this.appendToProblemData(root, problem.getProblemObject(), doc);
        String data = AbstractShareableAdvisor.serializeDocument(doc);
        problem.setData(data);
    }

    public static String serializeDocument(Document doc) throws TransformerException, IOException {
        TransformerFactory factory = TransformerFactory.newInstance();
        try {
            factory.setAttribute("indent-number", new Integer(4));
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        Transformer transformer = factory.newTransformer();
        transformer.setOutputProperty("method", "xml");
        transformer.setOutputProperty("indent", "yes");
        try {
            transformer.setOutputProperty("{http://xml.apache.org/xalan}indent-amount", "4");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        CharArrayWriter s = new CharArrayWriter();
        StreamResult outputTarget = new StreamResult(s);
        DOMSource source = new DOMSource(doc);
        transformer.transform(source, outputTarget);
        return s.toString();
    }
}

