/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.rest.util;

import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.IOperationFactory;
import com.ibm.team.filesystem.client.ISandbox;
import com.ibm.team.filesystem.client.IShare;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.internal.Messages;
import com.ibm.team.filesystem.client.internal.PathLocation;
import com.ibm.team.filesystem.client.internal.RelativeLocation;
import com.ibm.team.filesystem.client.internal.SharingManager;
import com.ibm.team.filesystem.client.internal.ignore.DefaultIgnoreProvider;
import com.ibm.team.filesystem.client.internal.ignore.IgnoreManager;
import com.ibm.team.filesystem.client.internal.ignore.IgnoreRule;
import com.ibm.team.filesystem.client.internal.rest.util.CommitUtil;
import com.ibm.team.filesystem.client.internal.rest.util.CoreUtil;
import com.ibm.team.filesystem.client.internal.rest.util.IgnoresUtil;
import com.ibm.team.filesystem.client.internal.rest.util.SandboxUpdateDilemmaUtil;
import com.ibm.team.filesystem.client.internal.utils.ConfigurationFacade;
import com.ibm.team.filesystem.client.operations.BackupDilemmaHandler;
import com.ibm.team.filesystem.client.operations.CommitDilemmaHandler;
import com.ibm.team.filesystem.client.operations.IEncodingUploadFailure;
import com.ibm.team.filesystem.client.operations.ILineDelimiterUploadFailure;
import com.ibm.team.filesystem.client.operations.IMultipleSandboxShare;
import com.ibm.team.filesystem.client.operations.IShareOperation;
import com.ibm.team.filesystem.client.operations.IShareOutOfSync;
import com.ibm.team.filesystem.client.operations.IShareOverlap;
import com.ibm.team.filesystem.client.operations.OutOfSyncDilemmaHandler;
import com.ibm.team.filesystem.client.operations.ShareDilemmaHandler;
import com.ibm.team.filesystem.client.rest.parameters.ParmsShare;
import com.ibm.team.filesystem.client.rest.parameters.ParmsShareRequest;
import com.ibm.team.filesystem.common.internal.rest.client.share.FilesystemRestClientDTOshareFactory;
import com.ibm.team.filesystem.common.internal.rest.client.share.MultipleSandboxShareDTO;
import com.ibm.team.filesystem.common.internal.rest.client.share.ShareOverlapDTO;
import com.ibm.team.filesystem.common.internal.rest.client.share.ShareResultDTO;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.client.internal.ConfigurationDescriptor;
import com.ibm.team.scm.client.internal.IConfigurationDescriptor;
import com.ibm.team.scm.common.IChangeSetHandle;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IFolderHandle;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.osgi.util.NLS;

public class ShareUtil {
    public static ShareResultDTO share(final ParmsShare parms, IProgressMonitor progress) throws TeamRepositoryException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)100);
        final SubMonitor dilemmaMonitor = monitor.newChild(10);
        final ShareResultDTO result = FilesystemRestClientDTOshareFactory.eINSTANCE.createShareResultDTO();
        final SandboxUpdateDilemmaUtil sandboxUpdateDilemmaUtil = new SandboxUpdateDilemmaUtil(parms.sandboxUpdateDilemmaHandler, result.getSandboxUpdateDilemma());
        final OutOfSyncDilemmaHandler outOfSyncDilemmaHandler = new OutOfSyncDilemmaHandler(){

            @Override
            public int outOfSync(Collection<IShareOutOfSync> sharesOutOfSync) {
                return 0;
            }

            @Override
            public boolean willIgnoreAllSharesOutOfSync() {
                return true;
            }
        };
        final CommitDilemmaHandler commitDilemmaHandler = CommitUtil.getCommitDilemmaHandler(parms.commitDilemmaHandler, result.getCommitDilemma(), parms.sandboxUpdateDilemmaHandler, result.getSandboxUpdateDilemma(), null, null, outOfSyncDilemmaHandler);
        ShareDilemmaHandler shareDilemmaHandler = new ShareDilemmaHandler(){

            @Override
            public OutOfSyncDilemmaHandler getOutOfSyncDilemmaHandler() {
                return outOfSyncDilemmaHandler;
            }

            @Override
            public int overlappingShareRequests(Collection<? extends IShareOverlap> projectShares) {
                dilemmaMonitor.setWorkRemaining(projectShares.size());
                for (IShareOverlap iShareOverlap : projectShares) {
                    result.getShareOverlaps().add(this.translateShareOverlap(iShareOverlap, (IProgressMonitor)dilemmaMonitor.newChild(1)));
                }
                return 0;
            }

            @Override
            public int multipleSandboxesForConfigurations(Collection<? extends IMultipleSandboxShare> multipleSandboxesForShares) {
                for (IMultipleSandboxShare iMultipleSandboxShare : multipleSandboxesForShares) {
                    result.getMultipleSandboxShares().add(this.translateMultipleSandboxShare(iMultipleSandboxShare));
                }
                return parms.getMultipleSandboxDirection();
            }

            private MultipleSandboxShareDTO translateMultipleSandboxShare(IMultipleSandboxShare multiSandboxShare) {
                MultipleSandboxShareDTO multipleSandboxShare = FilesystemRestClientDTOshareFactory.eINSTANCE.createMultipleSandboxShareDTO();
                IConfigurationDescriptor configuration = multiSandboxShare.getConfiguration();
                if (configuration instanceof ConfigurationFacade) {
                    multipleSandboxShare.setConfiguration(CoreUtil.translateConfigurationDescriptor((ConfigurationFacade)configuration));
                } else if (configuration instanceof ConfigurationDescriptor) {
                    multipleSandboxShare.setConfiguration(CoreUtil.translateConfigurationDescriptor((ConfigurationDescriptor)configuration));
                }
                for (ISandbox sandbox : multiSandboxShare.getSandboxes()) {
                    multipleSandboxShare.getSandboxes().add(sandbox.getRoot().toOSString());
                }
                for (IShareable shareRoot : multiSandboxShare.getShareables()) {
                    multipleSandboxShare.getRoots().add(CoreUtil.translateShareable(shareRoot));
                }
                return multipleSandboxShare;
            }

            private ShareOverlapDTO translateShareOverlap(IShareOverlap overlap, IProgressMonitor progress) {
                SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)overlap.getOverlappingShares().size());
                ShareOverlapDTO shareOverlap = FilesystemRestClientDTOshareFactory.eINSTANCE.createShareOverlapDTO();
                ITeamRepository teamRepository = overlap.getConnection().teamRepository();
                shareOverlap.setRepositoryId(CoreUtil.translateRepositoryId(teamRepository));
                shareOverlap.setRepositoryURL(teamRepository.getRepositoryURI());
                shareOverlap.setWorkspaceItemId(overlap.getConnection().getContextHandle().getItemId().getUuidValue());
                shareOverlap.setComponentItemId(overlap.getComponent().getItemId().getUuidValue());
                shareOverlap.setRoot(CoreUtil.translateShareable(overlap.getShareRoot()));
                for (IShareable shareable : overlap.getOverlappingShareRoots()) {
                    shareOverlap.getOverlappingRoots().add(CoreUtil.translateShareable(shareable));
                }
                for (IShare share : overlap.getOverlappingShares()) {
                    shareOverlap.getOverlappingShares().add(CoreUtil.translateShare(share, (IProgressMonitor)monitor.newChild(1)));
                }
                return shareOverlap;
            }

            @Override
            public int encodingErrors(Collection<? extends IEncodingUploadFailure> failedUploads, IProgressMonitor monitor) {
                return commitDilemmaHandler.encodingErrors(failedUploads, monitor);
            }

            @Override
            public int lineDelimiterErrors(Collection<? extends ILineDelimiterUploadFailure> failedFiles, IProgressMonitor monitor) throws FileSystemException {
                return commitDilemmaHandler.lineDelimiterErrors(failedFiles, monitor);
            }

            @Override
            public BackupDilemmaHandler getBackupDilemmaHandler() {
                return sandboxUpdateDilemmaUtil.getBackupDilemmaHandler();
            }

            @Override
            public void linkWarnings(boolean anyBrokenLinks, boolean anyNonInteroperableLinks, IShareable[] shareables, String[] targets, Boolean[] directoryLinks, Boolean[] broken, Boolean[] nonInteroperable) {
                commitDilemmaHandler.linkWarnings(anyBrokenLinks, anyNonInteroperableLinks, shareables, targets, directoryLinks, broken, nonInteroperable);
            }

            @Override
            public int predecessorContentDeletedErrors(Collection<IShareable> failedUploads) {
                return commitDilemmaHandler.predecessorContentDeletedErrors(failedUploads);
            }

            @Override
            public int deletedContent(Collection<IShareable> contentDeleted) {
                return sandboxUpdateDilemmaUtil.deletedContent(contentDeleted);
            }
        };
        IShareOperation shareOperation = ShareUtil.prepareShareRequest(parms, shareDilemmaHandler, (IProgressMonitor)monitor.newChild(10));
        try {
            shareOperation.run((IProgressMonitor)monitor.newChild(80));
        }
        catch (OperationCanceledException operationCanceledException) {
            result.setCancelled(true);
        }
        for (IChangeSetHandle changeSetHandle : shareOperation.getCommittedChangeSets()) {
            result.getChangeSetsCommitted().add(changeSetHandle.getItemId().getUuidValue());
        }
        return result;
    }

    private static IShareOperation prepareShareRequest(ParmsShare parms, ShareDilemmaHandler dilemmaHandler, IProgressMonitor progress) throws TeamRepositoryException {
        IShareOperation op = IOperationFactory.instance.getShareOperation(dilemmaHandler);
        op.checkInNewShareChildren(parms.checkInNewShareChildren);
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)parms.shareRequests.length);
        ParmsShareRequest[] parmsShareRequestArray = parms.shareRequests;
        int n = parms.shareRequests.length;
        int n2 = 0;
        while (n2 < n) {
            ParmsShareRequest request = parmsShareRequestArray[n2];
            SubMonitor loopMonitor = SubMonitor.convert((IProgressMonitor)monitor.newChild(1), (int)60);
            IWorkspaceConnection workspace = request.workspace.getWorkspaceConnection((IProgressMonitor)loopMonitor.newChild(10));
            ISandbox sandbox = SharingManager.getInstance().getSandbox(new PathLocation((IPath)new Path(request.sandboxPath)), false);
            ArrayList<RelativeLocation> itemsToShare = new ArrayList<RelativeLocation>(request.itemsToShare.length);
            String[] stringArray = request.itemsToShare;
            int n3 = request.itemsToShare.length;
            int n4 = 0;
            while (n4 < n3) {
                String itemRelativePath = stringArray[n4];
                itemsToShare.add(new RelativeLocation(new Path(itemRelativePath).segments()));
                ++n4;
            }
            String[] newFolderNames = request.newFolderPath == null || request.newFolderPath.trim().length() == 0 ? new String[]{} : new Path(request.newFolderPath).segments();
            IComponentHandle component = request.getComponentHandle();
            if (component == null) {
                op.share(workspace, request.componentName, newFolderNames, sandbox, itemsToShare, parms.overwrite, (IProgressMonitor)loopMonitor.newChild(10));
            } else {
                IChangeSetHandle changeSet = request.getChangeSetHandle();
                IFolderHandle parentFolder = request.getParentFolderHandle();
                op.share(workspace, changeSet, component, parentFolder, newFolderNames, sandbox, itemsToShare, parms.overwrite, (IProgressMonitor)loopMonitor.newChild(10));
            }
            if (request.ignoreRules != null) {
                ShareUtil.purgeIgnoresBeforeShare(request, loopMonitor.newChild(10));
                if (request.ignoreRules.length > 0) {
                    DefaultIgnoreProvider dip = (DefaultIgnoreProvider)IgnoreManager.getInstance().getIgnoreProvider("default", (IProgressMonitor)loopMonitor.newChild(1));
                    IgnoresUtil.ValidatedIgnoreRuleList val = IgnoresUtil.validateIgnoreRuleList(workspace, component, dip, request.ignoreRules, (IProgressMonitor)loopMonitor.newChild(1));
                    SubMonitor ruleMonitor = SubMonitor.convert((IProgressMonitor)loopMonitor.newChild(8), (int)val.rules.size());
                    for (IgnoreRule rule : val.rules) {
                        try {
                            dip.addIgnoreRule(rule, (IProgressMonitor)ruleMonitor.newChild(1));
                        }
                        catch (FileSystemException e) {
                            throw new TeamRepositoryException(NLS.bind((String)Messages.ShareUtil_FAILURE_CREATING_IGNORE_RULE, (Object)rule.getMatcher().getPattern()), (Throwable)((Object)e));
                        }
                    }
                    ruleMonitor.done();
                    dip.clearFileCache();
                }
            }
            loopMonitor.done();
            ++n2;
        }
        return op;
    }

    private static void purgeIgnoresBeforeShare(ParmsShareRequest request, SubMonitor monitor) throws TeamRepositoryException {
        monitor = SubMonitor.convert((IProgressMonitor)monitor, (int)(request.itemsToShare.length * 2));
        int i = 1;
        String[] stringArray = request.itemsToShare;
        int n = request.itemsToShare.length;
        int n2 = 0;
        while (n2 < n) {
            String relativeShareRoot = stringArray[n2];
            File shareRoot = new Path(request.sandboxPath).append(relativeShareRoot).toFile();
            monitor.setTaskName(NLS.bind((String)Messages.ShareUtil_PURGING_IGNORES_FROM_PROJECT, (Object[])new Object[]{shareRoot, i++, request.itemsToShare.length}));
            LinkedList<File> toDelete = new LinkedList<File>();
            ShareUtil.visit(shareRoot, toDelete, (IProgressMonitor)monitor.newChild(1));
            SubMonitor victimMonitor = monitor.newChild(1);
            victimMonitor.setWorkRemaining(toDelete.size());
            for (File staleIgnoreFile : toDelete) {
                victimMonitor.subTask(NLS.bind((String)Messages.ShareUtil_DELETING_IGNORE_FILE, (Object)staleIgnoreFile.getAbsolutePath()));
                if (staleIgnoreFile.delete()) continue;
                throw new TeamRepositoryException(NLS.bind((String)Messages.ShareUtil_FAILED_TO_PURGE_IGNORES, (Object)staleIgnoreFile.getAbsolutePath()));
            }
            ++n2;
        }
    }

    private static void visit(File file, LinkedList<File> toDelete, IProgressMonitor progress) throws TeamRepositoryException {
        if (file.getName().equals(".jazzignore")) {
            toDelete.add(file);
        } else {
            SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)100);
            IFileStore fileStore = EFS.getLocalFileSystem().getStore((IPath)new Path(file.getAbsolutePath()));
            try {
                File[] children;
                IFileInfo fileInfo = fileStore.fetchInfo(0, (IProgressMonitor)monitor.newChild(1));
                if (!fileInfo.getAttribute(32) && (children = file.listFiles()) != null) {
                    monitor.setWorkRemaining(children.length);
                    File[] fileArray = children;
                    int n = children.length;
                    int n2 = 0;
                    while (n2 < n) {
                        File child = fileArray[n2];
                        ShareUtil.visit(child, toDelete, (IProgressMonitor)monitor.newChild(1));
                        ++n2;
                    }
                }
            }
            catch (CoreException e) {
                throw new TeamRepositoryException(NLS.bind((String)Messages.ShareUtil_0, (Object)file.getAbsolutePath()), (Throwable)e);
            }
        }
    }
}

