/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rational.wvcm.ri.repo;

import com.ibm.rational.wvcm.ri.impl.FolderImpl;
import com.ibm.rational.wvcm.ri.repo.RiRepo;
import com.ibm.rational.wvcm.ri.repo.RiRepoActivity;
import com.ibm.rational.wvcm.ri.repo.RiRepoControllableResource;
import com.ibm.rational.wvcm.ri.repo.RiRepoIFolder;
import com.ibm.rational.wvcm.ri.repo.RiRepoResource;
import com.ibm.rational.wvcm.ri.repo.RiRepoVersion;
import com.ibm.rational.wvcm.ri.repo.RiRepoWorkspace;
import com.ibm.rational.wvcm.ri.srvc.SrvcFeedback;
import com.ibm.rational.wvcm.ri.srvc.SrvcProvider;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.wvcm.ControllableResource;
import javax.wvcm.Folder;
import javax.wvcm.Location;
import javax.wvcm.PropertyNameList;
import javax.wvcm.Version;
import javax.wvcm.Workspace;
import javax.wvcm.WvcmException;

public class RiRepoFolder
extends RiRepoResource
implements RiRepoIFolder {
    @Override
    public Class<?> get_proxyClass() {
        return FolderImpl.class;
    }

    protected RiRepoFolder(RiRepoResource parent, String bindingName, SrvcProvider provider, RiRepo repo) {
        super(parent, bindingName, provider, repo);
        this.initialize();
    }

    private void initialize() {
        this.createProperty(RiRepoIFolder.CHILD_BINDING_LIST, new ArrayList());
        this.createProperty(Folder.CHILD_LIST, null);
        this.createProperty(Folder.CHILD_MAP, null);
    }

    @Override
    protected boolean handleCalculatedProperties(PropertyNameList.PropertyName<?> propertyName, Object[] calculatedValue) {
        if (RiRepoFolder.handleCalculatedPropertiesHelper(this, propertyName, calculatedValue)) {
            return true;
        }
        return super.handleCalculatedProperties(propertyName, calculatedValue);
    }

    protected static boolean handleCalculatedPropertiesHelper(RiRepoResource self, PropertyNameList.PropertyName<?> propertyName, Object[] calculatedValue) {
        if (propertyName.equals((Object)Folder.CHILD_LIST)) {
            List cbl = self.getListProperty(RiRepoIFolder.CHILD_BINDING_LIST);
            ArrayList<RiRepoResource> cl = new ArrayList<RiRepoResource>();
            int i = 0;
            while (i < cbl.size()) {
                RiRepoIFolder.RepoBinding binding = (RiRepoIFolder.RepoBinding)cbl.get(i);
                RiRepoResource member = binding.get_bindingMember();
                cl.add(member);
                ++i;
            }
            calculatedValue[0] = cl;
            return true;
        }
        if (propertyName.equals((Object)Folder.CHILD_MAP)) {
            List cbl = self.getListProperty(RiRepoIFolder.CHILD_BINDING_LIST);
            HashMap<String, RiRepoResource> map = new HashMap<String, RiRepoResource>();
            int i = 0;
            while (i < cbl.size()) {
                RiRepoIFolder.RepoBinding binding = (RiRepoIFolder.RepoBinding)cbl.get(i);
                RiRepoResource member = binding.get_bindingMember();
                String bindingName = binding.get_bindingName();
                map.put(bindingName, member);
                ++i;
            }
            calculatedValue[0] = map;
            return true;
        }
        return false;
    }

    @Override
    public void doRebindChild(String bindingName, Location sourceFolderLocation, String sourceBindingName, Folder.RebindFlag[] flags, SrvcFeedback feedback) throws WvcmException {
        boolean destinationExists;
        RiRepoFolder parent = this;
        Location destination = parent.location().child(bindingName);
        boolean overwrite = false;
        if (flags != null) {
            int i = 0;
            while (i < flags.length) {
                if (flags[i] == Folder.RebindFlag.OVERWRITE) {
                    overwrite = true;
                }
                ++i;
            }
        }
        Location sourceLocation = sourceFolderLocation.child(sourceBindingName);
        RiRepoResource source = (RiRepoResource)parent.provider().lookup(sourceLocation, feedback);
        if (source == null) {
            throw new WvcmException("Repository resource does not exist: " + sourceLocation, null, WvcmException.ReasonCode.NOT_FOUND);
        }
        if (!(source instanceof RiRepoActivity)) {
            throw new WvcmException("doRebindChild not supported for this type of child", WvcmException.ReasonCode.METHOD_NOT_SUPPORTED);
        }
        RiRepoActivity child = (RiRepoActivity)source;
        RiRepoResource destinationResource = (RiRepoResource)child.provider().lookup(destination, feedback);
        boolean bl = destinationExists = destinationResource != null;
        if (destinationExists && !overwrite) {
            throw new WvcmException("There already is a resource at the destination, and overwrite is false", WvcmException.ReasonCode.CANNOT_OVERWRITE);
        }
        if (parent != child.get_repo().getActivityFolder()) {
            throw new WvcmException("Destination activity location is invalid: " + destination, WvcmException.ReasonCode.CANNOT_CREATE_AT_THIS_LOCATION);
        }
        if (destinationExists) {
            this.doUnbindChild(bindingName, feedback);
        }
        RiRepoIFolder.RepoBinding binding = child.getParentBinding(sourceLocation);
        binding.renameBinding(bindingName);
    }

    @Override
    public void doUnbindChild(String bindingName, SrvcFeedback feedback) throws WvcmException {
        List<RiRepoVersion> actVersionList;
        List<RiRepoControllableResource> actCheckoutList;
        RiRepoFolder parent = this;
        Location location = parent.location().child(bindingName);
        RiRepoResource resource = (RiRepoResource)parent.provider().lookup(location, feedback);
        if (resource == null) {
            throw new WvcmException("Repository resource does not exist: " + location, null, WvcmException.ReasonCode.NOT_FOUND);
        }
        if (!(resource instanceof RiRepoActivity)) {
            throw new WvcmException("doRebindChild not supported for this type of child", WvcmException.ReasonCode.METHOD_NOT_SUPPORTED);
        }
        RiRepoActivity child = (RiRepoActivity)resource;
        RiRepoIFolder.RepoBinding binding = child.getParentBinding(location);
        List<RiRepoWorkspace> curWorkspaceList = child.getCurrentWorkspaceList();
        if (curWorkspaceList != null) {
            int i = 0;
            while (i < curWorkspaceList.size()) {
                RiRepoWorkspace ws = curWorkspaceList.get(i);
                if (ws.getCurrentActivityList().contains(child)) {
                    ws.setProperty_RemoveFromList(Workspace.CURRENT_ACTIVITY_LIST, child);
                }
                ++i;
            }
        }
        if ((actCheckoutList = child.getActivityCheckoutList()) != null) {
            int i = 0;
            while (i < actCheckoutList.size()) {
                RiRepoControllableResource cr = actCheckoutList.get(i);
                if (child == cr.getProperty(ControllableResource.ACTIVITY)) {
                    cr.setProperty(ControllableResource.ACTIVITY, null);
                }
                ++i;
            }
        }
        if ((actVersionList = child.getActivityVersionList()) != null) {
            int i = 0;
            while (i < actVersionList.size()) {
                RiRepoVersion version = actVersionList.get(i);
                if (child == version.getProperty(Version.ACTIVITY)) {
                    version.setProperty(Version.ACTIVITY, null);
                }
                ++i;
            }
        }
        binding.unbind();
    }
}

