/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.common.util;

import com.ibm.team.filesystem.common.FileLineDelimiter;
import com.ibm.team.filesystem.common.util.LineDelimiterVerifier;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.UnsupportedEncodingException;

public class VerifyConvertToCRLFInputStream
extends LineDelimiterVerifier {
    private boolean pendingChar = false;
    private int lastChar = -1;
    private boolean mustReturnLF = false;

    public VerifyConvertToCRLFInputStream(InputStream in, String encoding) throws UnsupportedEncodingException {
        super(in, encoding);
    }

    @Override
    public int read() throws IOException {
        if (this.mustReturnLF) {
            this.mustReturnLF = false;
            return 10;
        }
        if (!this.pendingChar) {
            this.lastChar = super.read();
            this.pendingChar = true;
        }
        if (this.lastChar == 13) {
            this.lastChar = super.read();
            if (this.lastChar == 10) {
                this.validateLineDelimiter(FileLineDelimiter.LINE_DELIMITER_CRLF);
                this.pendingChar = false;
            } else {
                this.validateLineDelimiter(FileLineDelimiter.LINE_DELIMITER_CR);
                if (this.lastChar == -1) {
                    this.pendingChar = false;
                }
            }
            this.mustReturnLF = true;
            return 13;
        }
        if (this.lastChar == 10) {
            this.validateLineDelimiter(FileLineDelimiter.LINE_DELIMITER_LF);
            this.pendingChar = false;
            this.mustReturnLF = true;
            return 13;
        }
        this.pendingChar = false;
        return this.lastChar;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public int read(char[] buffer, int off, int len) throws IOException {
        if (len == 0) {
            return 0;
        }
        if (len <= 2) {
            b = this.read();
            if (b == -1) {
                return -1;
            }
            buffer[off] = (char)b;
            return 1;
        }
        charsReturned = 0;
        if (this.mustReturnLF) {
            this.mustReturnLF = false;
            buffer[off++] = 10;
            ++charsReturned;
            if (--len < 2) {
                return charsReturned;
            }
        }
        j = off + (len /= 2);
        toProcess = 0;
        toRead = len;
        if (this.pendingChar) {
            this.pendingChar = false;
            buffer[j] = (char)this.lastChar;
            --toRead;
            ++charsReturned;
            ++toProcess;
        }
        iioe = null;
        try {
            len = super.read(buffer, j + toProcess, toRead);
            if (len == -1) {
                if (toProcess == 0) {
                    return charsReturned == 0 ? -1 : charsReturned;
                }
                b = buffer[j];
                if (b == 10) {
                    this.validateLineDelimiter(FileLineDelimiter.LINE_DELIMITER_LF);
                    buffer[off++] = 13;
                    ++charsReturned;
                } else if (b == 13) {
                    this.validateLineDelimiter(FileLineDelimiter.LINE_DELIMITER_CR);
                    buffer[off++] = b;
                    ++charsReturned;
                    b = 10;
                }
                buffer[off++] = b;
                return charsReturned;
            }
        }
        catch (InterruptedIOException e) {
            len = e.bytesTransferred;
            iioe = e;
        }
        charsReturned += len;
        toProcess += len;
        if (true) ** GOTO lbl75
        do {
            if ((b = buffer[j++]) == 13) {
                if (toProcess > 0) {
                    if (buffer[j] == '\n') {
                        this.validateLineDelimiter(FileLineDelimiter.LINE_DELIMITER_CRLF);
                        buffer[off++] = b;
                        buffer[off++] = buffer[j++];
                    } else {
                        this.validateLineDelimiter(FileLineDelimiter.LINE_DELIMITER_CR);
                        buffer[off++] = b;
                        buffer[off++] = 10;
                        ++charsReturned;
                    }
                } else {
                    this.pendingChar = true;
                    this.lastChar = b;
                    --charsReturned;
                }
            } else if (b == 10) {
                this.validateLineDelimiter(FileLineDelimiter.LINE_DELIMITER_LF);
                buffer[off++] = 13;
                ++charsReturned;
                buffer[off++] = b;
            } else {
                buffer[off++] = b;
            }
lbl75:
            // 6 sources

            v0 = --toProcess;
            --toProcess;
        } while (v0 > 0);
        if (iioe != null) {
            iioe.bytesTransferred = charsReturned;
            throw iioe;
        }
        if (charsReturned == 0) {
            b = this.read();
            if (b == -1) {
                return -1;
            }
            buffer[off] = (char)b;
            return 1;
        }
        return charsReturned;
    }

    @Override
    public long skip(long skipBytes) throws IOException {
        int actualCount = 0;
        try {
            while (skipBytes-- > 0L && this.read() != -1) {
                ++actualCount;
            }
            return actualCount;
        }
        catch (InterruptedIOException e) {
            e.bytesTransferred = actualCount;
            throw e;
        }
    }

    @Override
    public boolean markSupported() {
        return false;
    }
}

