/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.common;

import com.ibm.team.repository.common.IContributorHandle;
import com.ibm.team.repository.common.IContributorLicenseType;
import com.ibm.team.repository.common.ILicenseAssignmentResult;
import com.ibm.team.repository.common.IServerLicenseType;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.model.ILicensesInfo;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public interface ILicenseAdminService {
    public void revokeLicense(String var1);

    public void restoreLicense(String var1);

    public IContributorLicenseType[] getLicenseTypes() throws TeamRepositoryException;

    public void assignLicense(IContributorHandle var1, String var2) throws TeamRepositoryException;

    public void unassignLicense(IContributorHandle var1, String var2) throws TeamRepositoryException;

    public void unassignAllLicenses(IContributorHandle var1) throws TeamRepositoryException;

    public String[] getAssignedLicenses(IContributorHandle var1) throws TeamRepositoryException;

    public void setLicensePurchaseCount(String var1, Integer var2) throws TeamRepositoryException;

    public void addLicense(byte[] var1) throws TeamRepositoryException;

    public ILicensesInfo addLicenses(String[] var1, boolean var2) throws TeamRepositoryException;

    public void removeLicense(byte[] var1) throws TeamRepositoryException;

    public void removeLicenseById(String var1) throws TeamRepositoryException;

    public IServerLicenseType getServerLicenseType() throws TeamRepositoryException;

    public IContributorHandle[] getLicensedContributors(String var1) throws TeamRepositoryException;

    public boolean isValidLicense(String var1) throws TeamRepositoryException;

    public String getLicenseAgreement(String var1) throws TeamRepositoryException;

    public BatchResult reassignLicense(String var1, String var2, IContributorHandle ... var3) throws TeamRepositoryException;

    public ILicenseAssignmentResult assignLicenseWithResult(IContributorHandle var1, String var2) throws TeamRepositoryException;

    public static class BatchResult {
        private Map<UUID, ResultMapEntry> resultMap = new HashMap<UUID, ResultMapEntry>();

        public Set<IContributorHandle> getFailed() {
            HashSet<IContributorHandle> handles = new HashSet<IContributorHandle>();
            for (ResultMapEntry r : this.resultMap.values()) {
                handles.add(r.handle);
            }
            return handles;
        }

        public String getError(IContributorHandle handle) {
            ResultMapEntry result = this.resultMap.get(handle.getItemId());
            return result != null ? result.message : null;
        }

        public void failure(IContributorHandle handle, String message) {
            if (message != null && message.length() > 0) {
                this.resultMap.put(handle.getItemId(), new ResultMapEntry(handle, message));
            }
        }
    }

    public static class ResultMapEntry {
        IContributorHandle handle = null;
        String message = "";

        public ResultMapEntry(IContributorHandle handle, String message) {
            this.handle = handle;
            this.message = message;
        }
    }
}

