/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.common.internal.content;

import com.ibm.team.repository.common.internal.content.RandomAccessContentSource;
import com.ibm.team.repository.common.internal.nls.Messages;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;

public class FileContentSource
implements RandomAccessContentSource {
    public static final int BUFFER_SIZE = 16384;
    public static final int BUFFER_ADVANCE = 64;
    protected RandomAccessFile rafile;
    protected FileChannel fc;
    protected long size;
    protected File file;
    protected byte[] buffer;
    protected ByteBuffer bb;
    protected long bufferOffset;
    protected int bufferLength;
    protected boolean deleteOnClose;

    public FileContentSource(File file, boolean delete) throws IOException {
        this.rafile = new RandomAccessFile(file, "r");
        this.fc = this.rafile.getChannel();
        this.size = this.fc.size();
        this.file = file;
        this.buffer = new byte[16384];
        this.bb = ByteBuffer.wrap(this.buffer);
        this.bufferOffset = 0L;
        this.bufferLength = 0;
        this.deleteOnClose = delete;
    }

    public FileContentSource(File file) throws IOException {
        this(file, false);
    }

    private boolean targetBytesInMemory(long offset, int length) {
        return offset >= this.bufferOffset && offset + (long)length <= this.bufferOffset + (long)this.bufferLength;
    }

    private void readBuffer(long offset, int length) throws IOException {
        int minread;
        long realOffset;
        if (length >= 16384) {
            realOffset = offset;
            minread = 0;
        } else if (length >= 16320) {
            minread = 16384 - length;
            realOffset = Math.max(offset - (long)minread, 0L);
            minread = (int)(offset - realOffset);
        } else {
            minread = 64;
            realOffset = Math.max(offset - 64L, 0L);
            minread = (int)(offset - realOffset);
        }
        this.bb.clear();
        long readOffset = realOffset;
        do {
            int read;
            if ((read = this.fc.read(this.bb, readOffset)) == -1) {
                throw new IOException(Messages.getServerString("FileContentSource.ErrorReadEOF"));
            }
            readOffset += (long)read;
        } while (this.bb.position() <= minread);
        this.bufferLength = this.bb.position();
        this.bufferOffset = realOffset;
    }

    private void internalOffsetCopyBytes(byte[] toArray, int targetOffset, long contentOffset, int length) {
        System.arraycopy(this.buffer, (int)(contentOffset - this.bufferOffset), toArray, targetOffset, length);
    }

    @Override
    public void copyBytes(byte[] toArray, long offset, int length) throws IOException {
        this.offsetCopyBytes(toArray, 0, offset, length);
    }

    private void internalOffsetCopyBytesFromDisk(byte[] toArray, int targetOffset, long offset, int length) throws IOException {
        while (length != 0) {
            this.readBuffer(offset, length);
            int len = (int)Math.min((long)length, (long)this.bufferLength - offset + this.bufferOffset);
            System.arraycopy(this.buffer, (int)(offset - this.bufferOffset), toArray, targetOffset, len);
            targetOffset += len;
            offset += (long)len;
            length -= len;
        }
    }

    @Override
    public void offsetCopyBytes(byte[] toArray, int targetOffset, long offset, int length) throws IOException {
        if (this.targetBytesInMemory(offset, length)) {
            this.internalOffsetCopyBytes(toArray, targetOffset, offset, length);
        } else if (this.bufferLength != 0 && this.bufferOffset + (long)this.bufferLength > offset && this.bufferOffset < offset + (long)length) {
            int bufPos = (int)Math.max(offset - this.bufferOffset, 0L);
            int arrayPos = (int)(this.bufferOffset - offset + (long)bufPos + (long)targetOffset);
            int len = Math.min(this.bufferLength - bufPos, targetOffset + length - arrayPos);
            System.arraycopy(this.buffer, bufPos, toArray, arrayPos, len);
            if (arrayPos > targetOffset) {
                this.internalOffsetCopyBytesFromDisk(toArray, targetOffset, offset, arrayPos - targetOffset);
            }
            if (arrayPos + len < length + targetOffset) {
                this.internalOffsetCopyBytesFromDisk(toArray, arrayPos + len, offset + (long)len + (long)arrayPos - (long)targetOffset, length - len - arrayPos + targetOffset);
            }
        } else {
            this.internalOffsetCopyBytesFromDisk(toArray, targetOffset, offset, length);
        }
    }

    @Override
    public byte getByte(long position) throws IOException {
        if (!this.targetBytesInMemory(position, 1)) {
            this.readBuffer(position, 1);
        }
        return this.buffer[(int)(position - this.bufferOffset)];
    }

    @Override
    public byte[] getBytes(long offset, int length) throws IOException {
        byte[] result = new byte[length];
        this.offsetCopyBytes(result, 0, offset, length);
        return result;
    }

    @Override
    public long getLength() throws IOException {
        return this.size;
    }

    @Override
    public void close() {
        try {
            try {
                this.rafile.close();
            }
            catch (IOException iOException) {
                System.err.println("Warning: error closing content source");
            }
        }
        finally {
            if (this.deleteOnClose && !this.file.delete()) {
                System.err.println("Warning: error deleting content source");
            }
        }
    }
}

