/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.common.transport;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class UriUtil {
    private static final Log _logger = LogFactory.getLog((String)UriUtil.class.getName());
    private static final String URL_ENCODED_SPACE = "%20";
    private static final String UTF_8 = "UTF-8";
    private static final char AMPERSAND = '&';
    private static final String EMPTY_STRING = "";
    private static final char EQUALS = '=';
    private static final char COLON = ':';
    private static final String SCHEME_POSTFIX = "://";
    private static final char FWD_SLASH = '/';
    private static final char QUESTION_MARK = '?';
    private static final char HASH = '#';
    private static final String FORWARD_SLASH = "/";
    private static final String BACKWARDS_SLASH = "/";

    public static String normalize(String uri, boolean decode) throws URISyntaxException {
        if (uri == null || uri.length() == 0) {
            throw new IllegalArgumentException("uri must not be null or empty");
        }
        StringBuilder strBuilder = new StringBuilder();
        URI workingUri = new URI(uri);
        if (!workingUri.isAbsolute() || workingUri.isOpaque()) {
            throw new IllegalArgumentException("uri must be absolute and not opaque");
        }
        String scheme = workingUri.getScheme().toLowerCase();
        strBuilder.append(scheme);
        strBuilder.append(SCHEME_POSTFIX);
        strBuilder.append(workingUri.getHost().toLowerCase());
        strBuilder.append(':');
        int port = workingUri.getPort();
        if (port == -1) {
            strBuilder.append(scheme.equals("https") ? 443 : 80);
        } else {
            strBuilder.append(port);
        }
        String path = workingUri.getRawPath();
        strBuilder.append(path == null || path.length() == 0 ? Character.valueOf('/') : (decode ? UriUtil.decode(path) : path));
        String query = workingUri.getRawQuery();
        if (query != null && query.length() > 0) {
            if (decode) {
                query = UriUtil.decode(query);
            }
            strBuilder.append('?');
            strBuilder.append(query);
        }
        return strBuilder.toString();
    }

    public static String trimTrailingSlash(String uri) {
        if (uri == null) {
            return uri;
        }
        if ((uri = uri.trim()).endsWith("/") || uri.endsWith("/")) {
            int len = uri.length();
            if (len > 1) {
                return uri.substring(0, len - 1);
            }
            uri = new String();
        }
        return uri;
    }

    public static String trimLeadingSlash(String uri) {
        if (uri == null) {
            return uri;
        }
        if ((uri = uri.trim()).startsWith("/") || uri.startsWith("/")) {
            if (uri.length() > 1) {
                return uri.substring(1);
            }
            uri = new String();
        }
        return uri;
    }

    public static String trimSlashes(String uri) {
        return UriUtil.trimTrailingSlash(UriUtil.trimLeadingSlash(uri));
    }

    public static String encode(String str) {
        if (str == null) {
            throw new IllegalArgumentException("str must not be null");
        }
        String newStr = null;
        try {
            newStr = URLEncoder.encode(str, UTF_8);
        }
        catch (UnsupportedEncodingException e) {
            String msg = String.format("Unexpected encoding error during the %s encoding of string \"%s\": Exception message: %s", UTF_8, str, e.getMessage());
            _logger.error((Object)msg);
            return msg;
        }
        return newStr.replace("+", URL_ENCODED_SPACE);
    }

    public static String decode(String str) {
        if (str == null) {
            throw new IllegalArgumentException("str must not be null");
        }
        str = str.replace(URL_ENCODED_SPACE, "+");
        try {
            return URLDecoder.decode(str, UTF_8);
        }
        catch (UnsupportedEncodingException e) {
            String msg = String.format("Unexpected decoding error during the %s decoding of string \"%s\": Exception message: %s", UTF_8, str, e.getMessage());
            _logger.error((Object)msg);
            return msg;
        }
    }

    public static URI toRelativeUri(String str) throws URISyntaxException {
        URI uri = new URI(str);
        uri = UriUtil.fromComponents(null, null, -1, uri.getRawPath(), uri.getRawQuery(), uri.getRawFragment());
        return uri;
    }

    public static String toRelativeUri(String str, boolean decode) throws URISyntaxException {
        URI uri = new URI(str);
        uri = UriUtil.fromComponents(null, null, -1, uri.getRawPath(), uri.getRawQuery(), uri.getRawFragment());
        if (decode) {
            return UriUtil.decode(uri.toString());
        }
        return uri.toString();
    }

    public static URI fromComponents(String scheme, String hostname, int port, String path, String query, String fragment) throws URISyntaxException {
        StringBuilder strBuilder = new StringBuilder();
        if (scheme != null && hostname != null && scheme.trim().length() > 0 && hostname.trim().length() > 0) {
            strBuilder.append(scheme.trim());
            strBuilder.append(SCHEME_POSTFIX);
            strBuilder.append(hostname.trim());
            if (port != -1) {
                strBuilder.append(':');
                strBuilder.append(Integer.toString(port));
            }
        }
        path = UriUtil.trimLeadingSlash(path);
        strBuilder.append('/');
        if (path != null && path.length() > 0) {
            strBuilder.append(path);
        }
        if (query != null && query.trim().length() > 0) {
            strBuilder.append('?');
            strBuilder.append(query.trim());
        }
        if (fragment != null && fragment.trim().length() > 0) {
            strBuilder.append('#');
            strBuilder.append(fragment.trim());
        }
        URI uri = new URI(strBuilder.toString());
        return uri;
    }

    public static Map<String, String[]> parseQueryParameters(String query) {
        HashMap<String, ArrayList<String>> map = new HashMap<String, ArrayList<String>>();
        if (query == null || query.length() == 0) {
            return new HashMap<String, String[]>();
        }
        if (query.charAt(0) != '&') {
            query = String.valueOf('&') + query;
        }
        int masterNdx = 0;
        while (masterNdx < query.length()) {
            int startNdx;
            int endNdx;
            String parm = EMPTY_STRING;
            if ((endNdx = query.indexOf(38, startNdx = ++masterNdx)) == -1) {
                parm = query.substring(startNdx);
                masterNdx = query.length();
            } else {
                parm = query.substring(startNdx, endNdx);
                masterNdx = endNdx;
            }
            UriUtil.loadParmInMap(parm, map);
        }
        HashMap<String, String[]> newMap = new HashMap<String, String[]>(map.size());
        for (String key : map.keySet()) {
            ArrayList list = (ArrayList)map.get(key);
            String[] strings = new String[list.size()];
            int i = 0;
            while (i < list.size()) {
                strings[i] = (String)list.get(i);
                ++i;
            }
            newMap.put(key, strings);
        }
        return newMap;
    }

    public static String queryString(Map<String, String[]> parmMap) {
        return UriUtil.queryString(parmMap, null);
    }

    public static boolean hasQuery(String uri) {
        URI requestUri = null;
        try {
            requestUri = new URI(uri);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(String.format("Invalid URI \"%s\" specified in request. Exception message: \"%s\"", uri, e.getMessage()));
        }
        return requestUri.getQuery() != null;
    }

    public static String queryString(Map<String, String[]> parmMap, String[] exclude) {
        if (parmMap == null) {
            throw new IllegalArgumentException("parmMap must not be null");
        }
        StringBuffer buf = new StringBuffer(256);
        for (Map.Entry<String, String[]> entry : parmMap.entrySet()) {
            String[] values;
            int n;
            String key = entry.getKey();
            boolean includeParm = true;
            if (exclude != null) {
                String[] stringArray = exclude;
                n = exclude.length;
                int n2 = 0;
                while (n2 < n) {
                    String parm = stringArray[n2];
                    if (key.equals(parm)) {
                        includeParm = false;
                        break;
                    }
                    ++n2;
                }
            }
            if (!includeParm) continue;
            String[] stringArray = values = entry.getValue();
            int n3 = values.length;
            n = 0;
            while (n < n3) {
                String value = stringArray[n];
                if (buf.length() != 0) {
                    buf.append('&');
                }
                buf.append(key);
                buf.append('=');
                buf.append(value);
                ++n;
            }
        }
        return buf.toString();
    }

    public static String getAppContext(URI uri) {
        if (uri == null) {
            return null;
        }
        if (!uri.isAbsolute()) {
            return null;
        }
        String path = uri.getPath();
        if (path == null || path.length() == 0) {
            return null;
        }
        int ndx = path.indexOf(47, 1);
        if (ndx == -1) {
            return path;
        }
        return path.substring(0, ndx);
    }

    public static boolean isAbsoluteUri(String string) {
        try {
            URI uri = new URI(string);
            return uri.isAbsolute();
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static boolean startsWithPath(URI baseUri, URI compareUri) {
        String basePath;
        String comparePath = compareUri.getPath();
        if (comparePath == null) {
            comparePath = EMPTY_STRING;
        }
        if (!comparePath.endsWith("/")) {
            comparePath = String.valueOf(comparePath) + "/";
        }
        if ((basePath = baseUri.getPath()) == null) {
            basePath = EMPTY_STRING;
        }
        if (!basePath.endsWith("/")) {
            basePath = String.valueOf(basePath) + "/";
        }
        return basePath.startsWith(comparePath);
    }

    private static void loadParmInMap(String parm, HashMap<String, ArrayList<String>> map) {
        int equals = parm.indexOf(61);
        String key = null;
        String value = EMPTY_STRING;
        if (equals == -1) {
            key = parm;
        } else if (equals == parm.length() - 1) {
            key = parm.substring(0, equals);
        } else {
            key = parm.substring(0, equals);
            value = parm.substring(equals + 1);
        }
        ArrayList<String> mapValue = map.get(key);
        if (mapValue == null) {
            mapValue = new ArrayList();
            map.put(key, mapValue);
        }
        mapValue.add(value);
    }
}

