/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.common.utils;

import com.ibm.team.repository.common.LineDelimiter;
import com.ibm.team.repository.common.internal.nls.Messages;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.repository.common.utils.ContentLineDelimiterError;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.nio.charset.CodingErrorAction;

public abstract class LineDelimiterVerifier
extends InputStreamReader {
    private long lineDelimiterCount = 0L;
    private long markLineDelimiterCount = 0L;
    private boolean enabled = true;
    private LineDelimiter lineDelimiter = LineDelimiter.LINE_DELIMITER_NONE;

    public LineDelimiterVerifier(InputStream in, String encoding, LineDelimiter expectedLineTerminator) throws UnsupportedEncodingException {
        super(in, Charset.forName(encoding).newDecoder().onMalformedInput(CodingErrorAction.REPORT).onUnmappableCharacter(CodingErrorAction.REPORT));
        this.lineDelimiter = expectedLineTerminator;
    }

    public LineDelimiterVerifier(InputStream in, String encoding) throws UnsupportedEncodingException {
        this(in, encoding, LineDelimiter.LINE_DELIMITER_NONE);
    }

    @Override
    public void mark(int readlimit) throws IOException {
        super.mark(readlimit);
        this.markLineDelimiterCount = this.lineDelimiterCount;
    }

    @Override
    public void reset() throws IOException {
        super.reset();
        this.lineDelimiterCount = this.markLineDelimiterCount;
    }

    protected final void validateLineDelimiter(LineDelimiter delimiterFound) throws ContentLineDelimiterError {
        ++this.lineDelimiterCount;
        if (this.lineDelimiter == LineDelimiter.LINE_DELIMITER_NONE) {
            this.lineDelimiter = delimiterFound;
        } else if (this.enabled && this.lineDelimiter != delimiterFound) {
            String msg = NLS.bind(Messages.getServerString("LineDelimiterVerifier.ErrorMismatchedDelimiters"), this.lineDelimiterCount, delimiterFound.toString(), this.lineDelimiter.toString());
            throw new ContentLineDelimiterError(msg);
        }
    }

    public final long getLineDelimiterCount() {
        return this.lineDelimiterCount;
    }

    public final LineDelimiter getLineDelimiter() {
        return this.lineDelimiter;
    }

    final void setVerifyEnabled(boolean enabled) {
        this.enabled = enabled;
    }
}

