/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.common.utils;

import com.ibm.team.repository.common.utils.UnsynchronizedByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.CodingErrorAction;

public class ReaderToInputStream
extends InputStream {
    private static final String STREAM_IS_CLOSED = "InputStreamReader is closed";
    private Reader in;
    private UnsynchronizedByteArrayOutputStream buffer;
    private OutputStreamWriter writer;
    private int posn;
    private char[] buf;

    public ReaderToInputStream(Reader reader, String encoding) {
        this.in = reader;
        this.buffer = new UnsynchronizedByteArrayOutputStream();
        this.writer = new OutputStreamWriter((OutputStream)this.buffer, Charset.forName(encoding).newEncoder().onMalformedInput(CodingErrorAction.REPORT).onUnmappableCharacter(CodingErrorAction.REPORT));
        this.buf = new char[8192];
    }

    public ReaderToInputStream(InputStreamReader inputStreamReader) {
        this.in = inputStreamReader;
        this.buffer = new UnsynchronizedByteArrayOutputStream();
        this.writer = new OutputStreamWriter((OutputStream)this.buffer, Charset.forName(inputStreamReader.getEncoding()).newEncoder().onMalformedInput(CodingErrorAction.REPORT).onUnmappableCharacter(CodingErrorAction.REPORT));
        this.buf = new char[8192];
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public int read() throws IOException {
        if (this.in != null) ** GOTO lbl12
        throw new IOException("InputStreamReader is closed");
lbl-1000:
        // 1 sources

        {
            if (this.writer == null) {
                return -1;
            }
            read = this.in.read();
            if (read == -1) {
                this.writer.close();
                this.writer = null;
                continue;
            }
            this.writer.write(read);
            this.writer.flush();
lbl12:
            // 3 sources

            ** while ((size = this.buffer.size()) == 0)
        }
lbl13:
        // 1 sources

        result = this.buffer.getBuffer()[this.posn];
        ++this.posn;
        if (this.posn == size) {
            this.buffer.reset();
            this.posn = 0;
        }
        return result & 255;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || off > b.length || len < 0 || off + len > b.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return 0;
        }
        if (this.in != null) ** GOTO lbl18
        throw new IOException("InputStreamReader is closed");
lbl-1000:
        // 1 sources

        {
            if (this.writer == null) {
                return -1;
            }
            read = this.in.read(this.buf);
            if (read == -1) {
                this.writer.close();
                this.writer = null;
                continue;
            }
            this.writer.write(this.buf, 0, read);
            this.writer.flush();
lbl18:
            // 3 sources

            ** while ((size = this.buffer.size()) == 0)
        }
lbl19:
        // 1 sources

        len = Math.min(len, size - this.posn);
        System.arraycopy(this.buffer.getBuffer(), this.posn, b, off, len);
        this.posn += len;
        if (this.posn == size) {
            this.buffer.reset();
            this.posn = 0;
        }
        return len;
    }

    @Override
    public int available() throws IOException {
        if (this.in == null) {
            throw new IOException(STREAM_IS_CLOSED);
        }
        return this.buffer.size() - this.posn + (this.in.ready() ? 1 : 0);
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public void close() throws IOException {
        if (this.in != null) {
            this.buffer = null;
            this.buf = null;
            this.writer = null;
            Reader reader = this.in;
            this.in = null;
            reader.close();
        }
    }

    @Override
    public long skip(long n) throws IOException {
        if (this.in == null) {
            throw new IOException(STREAM_IS_CLOSED);
        }
        long skipped = 0L;
        if (n <= 0L) {
            return 0L;
        }
        while (true) {
            int size;
            int len;
            if ((long)(len = (size = this.buffer.size()) - this.posn) >= n) {
                if ((long)len == n) {
                    this.buffer.reset();
                    this.posn = 0;
                } else {
                    this.posn = (int)((long)this.posn + n);
                }
                return skipped += n;
            }
            this.buffer.reset();
            this.posn = 0;
            skipped += (long)len;
            n -= (long)len;
            if (this.writer == null) {
                return skipped;
            }
            int read = this.in.read(this.buf);
            if (read == -1) {
                this.writer.close();
                this.writer = null;
                continue;
            }
            this.writer.write(this.buf, 0, read);
            this.writer.flush();
        }
    }
}

