/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal;

import com.ibm.team.filesystem.client.internal.FileItemInfo;
import com.ibm.team.filesystem.common.FileLineDelimiter;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.common.ContentHash;
import com.ibm.team.scm.common.IFolderHandle;
import com.ibm.team.scm.common.IVersionableHandle;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.Assert;

public class InverseFileItemInfo
extends FileItemInfo {
    private final IFolderHandle localParent;
    private final String localName;
    private final Map<String, IVersionableHandle> remoteChildren;
    private final Map<String, String> originalProperties;
    private final Map<String, String> changedProperties;
    private final Set<String> removedProperties;

    public InverseFileItemInfo(IVersionableHandle handle, boolean contentChanged, long lastContentChangeCheckStamp, IFolderHandle remoteParent, String remoteName, boolean loadedWithAnotherName, Map<String, IVersionableHandle> remoteChildren, IFolderHandle localParent, String localName, ContentHash hash, long size, FileLineDelimiter originalLineDelimiter, FileLineDelimiter lineDelimiter, String originalContentType, String contentType, ContentHash contentPredecessorHintHash, long contentSizeInRepo, String originalEncoding, ContentHash hashInRepo, long lineDelimiterCountInRepo, boolean executable, boolean originalExecutable, boolean directoryLink, boolean originalDirectoryLink, Map<String, String> originalProperties, Set<String> removedProperties, Map<String, String> propertyChanges) {
        super(handle, contentChanged, lastContentChangeCheckStamp, remoteParent, remoteName, loadedWithAnotherName, hash, size, originalLineDelimiter, lineDelimiter, originalContentType, contentType, contentPredecessorHintHash, contentSizeInRepo, originalEncoding, hashInRepo, lineDelimiterCountInRepo, executable, originalExecutable, directoryLink, originalDirectoryLink);
        Assert.isTrue((localParent == null || !localParent.hasFullState() ? 1 : 0) != 0);
        Assert.isTrue((localName != null || localParent == null ? 1 : 0) != 0);
        Assert.isNotNull(remoteChildren);
        Assert.isTrue((remoteChildren.isEmpty() || handle instanceof IFolderHandle ? 1 : 0) != 0);
        Assert.isTrue((!contentChanged || localName != null ? 1 : 0) != 0);
        this.localParent = localParent;
        this.localName = localName;
        this.remoteChildren = remoteChildren;
        this.originalProperties = new HashMap<String, String>(originalProperties);
        this.changedProperties = new HashMap<String, String>(propertyChanges);
        this.removedProperties = new HashSet<String>(removedProperties);
        Assert.isTrue((!originalProperties.containsKey("contentType") ? 1 : 0) != 0);
        Assert.isTrue((!originalProperties.containsKey("fileTimestamp") ? 1 : 0) != 0);
        Assert.isTrue((!this.changedProperties.containsKey("contentType") ? 1 : 0) != 0);
        Assert.isTrue((!this.changedProperties.containsKey("fileTimestamp") ? 1 : 0) != 0);
        for (Map.Entry<String, String> entry : originalProperties.entrySet()) {
            Assert.isTrue((entry.getKey().length() <= 128 ? 1 : 0) != 0);
            Assert.isTrue((entry.getValue().length() <= Short.MAX_VALUE ? 1 : 0) != 0);
        }
        for (Map.Entry<String, String> entry : this.changedProperties.entrySet()) {
            Assert.isTrue((entry.getKey().length() <= 128 ? 1 : 0) != 0);
            Assert.isTrue((entry.getValue().length() <= Short.MAX_VALUE ? 1 : 0) != 0);
        }
    }

    public InverseFileItemInfo(IFolderHandle handle, IFolderHandle remoteParent, String remoteName, boolean loadedWithAnotherName, Map remoteChildren, IFolderHandle localParent, String localName, Map<String, String> originalProperties, Set<String> removedProperties, Map<String, String> propertyChanges) {
        this((IVersionableHandle)handle, false, -1L, remoteParent, remoteName, loadedWithAnotherName, remoteChildren, localParent, localName, null, -1L, null, null, null, null, null, -1L, null, null, -1L, false, false, false, false, originalProperties, removedProperties, propertyChanges);
    }

    public IFolderHandle getLocalParent() {
        return this.localParent;
    }

    public String getLocalName() {
        return this.localName;
    }

    public Map<String, IVersionableHandle> getRemoteChildren() {
        return this.remoteChildren;
    }

    public Map<String, String> getOriginalProperties() {
        return Collections.unmodifiableMap(this.originalProperties);
    }

    public Map<String, String> getChangedProperties() {
        return Collections.unmodifiableMap(this.changedProperties);
    }

    public Set<String> getRemovedProperties() {
        return Collections.unmodifiableSet(this.removedProperties);
    }

    public InverseFileItemInfo withLocalName(String localName) {
        return new InverseFileItemInfo(this.getVersionableHandle(), this.isContentChanged(), this.getLastContentChangeCheckStamp(), this.getParent(), this.getName(), this.isLoadedWithAnotherName(), this.getRemoteChildren(), this.getLocalParent(), localName, this.getHash(), this.getContentLength(), this.getOriginalLineDelimiter(), this.getLineDelimiter(), this.getOriginalContentType(), this.getContentType(), this.getStoredPredecessorHintHash(), this.getStoredSize(), this.getStoredEncoding(), this.getStoredHash(), this.getStoredNumLineDelimiters(), this.isExecutable(), this.isOriginalExecutable(), this.isDirectoryLink(), this.isOriginalDirectoryLink(), this.originalProperties, this.removedProperties, this.changedProperties);
    }

    public InverseFileItemInfo withLocalParent(IFolderHandle localParent) {
        return new InverseFileItemInfo(this.getVersionableHandle(), this.isContentChanged(), this.getLastContentChangeCheckStamp(), this.getParent(), this.getName(), this.isLoadedWithAnotherName(), this.getRemoteChildren(), localParent, this.getLocalName(), this.getHash(), this.getContentLength(), this.getOriginalLineDelimiter(), this.getLineDelimiter(), this.getOriginalContentType(), this.getContentType(), this.getStoredPredecessorHintHash(), this.getStoredSize(), this.getStoredEncoding(), this.getStoredHash(), this.getStoredNumLineDelimiters(), this.isExecutable(), this.isOriginalExecutable(), this.isDirectoryLink(), this.isOriginalDirectoryLink(), this.originalProperties, this.removedProperties, this.changedProperties);
    }

    public InverseFileItemInfo withRemoteChildren(Map<String, IVersionableHandle> children) {
        return new InverseFileItemInfo(this.getVersionableHandle(), this.isContentChanged(), this.getLastContentChangeCheckStamp(), this.getParent(), this.getName(), this.isLoadedWithAnotherName(), Collections.unmodifiableMap(children), this.getLocalParent(), this.getLocalName(), this.getHash(), this.getContentLength(), this.getOriginalLineDelimiter(), this.getLineDelimiter(), this.getOriginalContentType(), this.getContentType(), this.getStoredPredecessorHintHash(), this.getStoredSize(), this.getStoredEncoding(), this.getStoredHash(), this.getStoredNumLineDelimiters(), this.isExecutable(), this.isOriginalExecutable(), this.isDirectoryLink(), this.isOriginalDirectoryLink(), this.originalProperties, this.removedProperties, this.changedProperties);
    }

    public InverseFileItemInfo addRemoteChild(String name, IVersionableHandle versionableHandle) {
        HashMap<String, IVersionableHandle> childMap = new HashMap<String, IVersionableHandle>(this.getRemoteChildren());
        childMap.put(name, versionableHandle);
        return this.withRemoteChildren(childMap);
    }

    public InverseFileItemInfo removeRemoteChild(String childName) {
        HashMap<String, IVersionableHandle> children = new HashMap<String, IVersionableHandle>(this.getRemoteChildren());
        children.remove(childName);
        return this.withRemoteChildren(children);
    }

    public IVersionableHandle getRemoteChild(String name) {
        return this.getRemoteChildren().get(name);
    }

    public InverseFileItemInfo asLocalDeletion() {
        return new InverseFileItemInfo(this.getVersionableHandle(), false, -1L, this.getParent(), this.getName(), this.isLoadedWithAnotherName(), this.getRemoteChildren(), null, null, this.getHash(), this.getContentLength(), this.getOriginalLineDelimiter(), this.getLineDelimiter(), this.getOriginalContentType(), this.getContentType(), this.getStoredPredecessorHintHash(), this.getStoredSize(), this.getStoredEncoding(), this.getStoredHash(), this.getStoredNumLineDelimiters(), this.isExecutable(), this.isOriginalExecutable(), this.isDirectoryLink(), this.isOriginalDirectoryLink(), this.originalProperties, this.removedProperties, this.changedProperties);
    }

    public InverseFileItemInfo withNewUUID() {
        return new InverseFileItemInfo((IVersionableHandle)this.getVersionableHandle().getItemType().createItemHandle(UUID.generate(), null), false, -1L, null, null, false, Collections.<String, IVersionableHandle>emptyMap(), this.getLocalParent(), this.getLocalName(), null, -1L, null, this.getLineDelimiter(), null, this.getContentType(), null, -1L, null, null, -1L, this.isExecutable(), false, this.isDirectoryLink(), false, Collections.<String, String>emptyMap(), Collections.<String>emptySet(), Collections.<String, String>emptyMap());
    }

    public InverseFileItemInfo forMoveToNewWC(IFolderHandle remoteParent, String name) {
        return new InverseFileItemInfo(this.getVersionableHandle(), false, -1L, remoteParent, name, this.isLoadedWithAnotherName(), Collections.EMPTY_MAP, null, null, this.getHash(), this.getContentLength(), this.getOriginalLineDelimiter(), this.getLineDelimiter(), this.getOriginalContentType(), this.getContentType(), this.getStoredPredecessorHintHash(), this.getStoredSize(), this.getStoredEncoding(), this.getStoredHash(), this.getStoredNumLineDelimiters(), this.isExecutable(), this.isOriginalExecutable(), this.isDirectoryLink(), this.isOriginalDirectoryLink(), this.originalProperties, this.removedProperties, this.changedProperties);
    }

    public InverseFileItemInfo updateLocalInfo(FileItemInfo entry, boolean modified, long timeStamp, IFolderHandle localParent, String localName) {
        return new InverseFileItemInfo(this.getVersionableHandle(), modified, timeStamp, this.getParent(), this.getName(), this.isLoadedWithAnotherName(), this.getRemoteChildren(), localParent, localName, this.getHash(), this.getContentLength(), this.getOriginalLineDelimiter(), entry.getLineDelimiter(), this.getOriginalContentType(), entry.getContentType(), this.getStoredPredecessorHintHash(), this.getStoredSize(), this.getStoredEncoding(), this.getStoredHash(), this.getStoredNumLineDelimiters(), this.isExecutable(), this.isOriginalExecutable(), this.isDirectoryLink(), this.isOriginalDirectoryLink(), this.originalProperties, this.removedProperties, this.changedProperties);
    }
}

