/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.checkin;

import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.ILocalChange;
import com.ibm.team.filesystem.client.internal.InverseFileItemInfo;
import com.ibm.team.filesystem.client.internal.MetadataProperties;
import com.ibm.team.filesystem.client.internal.checkin.CheckinUploadData;
import com.ibm.team.filesystem.client.internal.checkin.NewCheckInOperation;
import com.ibm.team.filesystem.client.internal.checkin.UploadHandler;
import com.ibm.team.filesystem.client.internal.copyfileareas.AbstractLock;
import com.ibm.team.filesystem.client.internal.copyfileareas.CFALockUtil;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICopyFileArea;
import com.ibm.team.filesystem.client.internal.utils.CancellationMonitor;
import com.ibm.team.scm.common.IContextHandle;
import org.eclipse.core.runtime.IProgressMonitor;

public class CheckinUploadHandler
extends UploadHandler {
    private final ICopyFileArea cfa;

    public CheckinUploadHandler(ICopyFileArea cfa, NewCheckInOperation.ComponentCheckInRequest req, ILocalChange localChange, boolean atomicCommitRequired, CheckinUploadData uploadData, CancellationMonitor cMon) throws FileSystemException {
        super(localChange.getShareable(), req.getWorkspace(), req.getComponent(), localChange.getTarget(), atomicCommitRequired, uploadData, cMon);
        this.cfa = cfa;
    }

    @Override
    protected UploadHandler.AdditionalFileInfo getAdditionalFileInfo(CancellationMonitor cMon) throws FileSystemException {
        InverseFileItemInfo info;
        UploadHandler.AdditionalFileInfo additionalFileInfo = new UploadHandler.AdditionalFileInfo(this);
        AbstractLock lock = CFALockUtil.lockExistingForRead(this.cfa.getRoot(), (IProgressMonitor)cMon);
        try {
            info = this.cfa.getItemInfo(this.getVersionable(), this.getComponent(), (IContextHandle)this.getWorkspace().getResolvedWorkspace(), true);
        }
        finally {
            CFALockUtil.endBatching(lock, this.getCancellationMonitor());
        }
        additionalFileInfo.specifiedLineDelimiter = info.getLineDelimiter();
        additionalFileInfo.predecessorHintHash = info.getStoredHash();
        additionalFileInfo.predecessorEncoding = info.getStoredEncoding();
        additionalFileInfo.properties = new MetadataProperties(info.getOriginalProperties(), info.getChangedProperties(), info.getRemovedProperties()).getCurrentProperties();
        return additionalFileInfo;
    }
}

