/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.copyfileareas.validator;

import com.ibm.team.filesystem.client.ISharingDescriptor;
import com.ibm.team.filesystem.client.internal.SharingDescriptor;
import com.ibm.team.filesystem.client.internal.copyfileareas.CaseInsensitiveString;
import com.ibm.team.filesystem.client.internal.copyfileareas.GlobalMetadataValidator;
import com.ibm.team.filesystem.client.internal.copyfileareas.validator.DiskBackedHashMapEntriesValidator;
import com.ibm.team.filesystem.client.internal.copyfileareas.validator.HeapValidator;
import com.ibm.team.internal.repository.rcp.util.RAFWrapper;
import com.ibm.team.repository.transport.client.TeamServerFactoryImpl;
import com.ibm.team.scm.common.dto.ISyncTime;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.lang.reflect.Field;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class SharingDescriptorsMapValidator
extends DiskBackedHashMapEntriesValidator {
    private static final int UNKNOWN_CONFIG_STATE = 1;
    private static final int FILE_ROOT = 2;
    private static final int LINK_ROOT = 4;
    private static final int HAS_LOAD_ROOT = 8;
    private static final int HAS_CLIENT_DATA = 16;
    private static final int METADATA_VERSION = 0;
    protected boolean isCaseSensitive;
    protected File cfaRoot;

    public SharingDescriptorsMapValidator(File rootPath, boolean isCaseSensitive, HeapValidator hv, GlobalMetadataValidator gv) throws IOException {
        super(hv, gv);
        this.cfaRoot = rootPath;
        this.isCaseSensitive = isCaseSensitive;
    }

    @Override
    public void beginValidation() throws IOException {
        super.beginValidation();
        if (!this.hv.getHeapFile().getName().equals(".descriptors.dat")) {
            this.log.append("Invalid sharing descriptors map file name " + this.hv.getHeapFile() + "\n");
        }
        if (!this.hv.getHeapFile().getParentFile().equals(this.cfaRoot)) {
            this.log.append("Invalid sharing descriptors map location " + this.hv.getHeapFile() + " relative to root " + this.cfaRoot + "\n");
        }
    }

    @Override
    public void validateEntry(long entryOffset, long keyOffset, boolean keyIsHeapADT, long valueOffset, boolean valueIsHeapADT, int hash, RAFWrapper raf) throws IOException {
        if (keyIsHeapADT) {
            this.log.append("HeapADT attribute unexpectedly set on sharing descriptors key of entry at " + entryOffset + "\n");
        }
        if (valueIsHeapADT) {
            this.log.append("HeapADT attribute unexpectedly set on sharing descriptors value of entry at " + entryOffset + "\n");
        }
        IPath path = this.validateKey(entryOffset, keyOffset, hash, raf);
        ISharingDescriptor desc = this.validateValue(entryOffset, valueOffset, raf);
        if (path != null && desc != null) {
            this.gv.addSharingDescriptor(path, desc, this.log);
        }
    }

    protected IPath validateKey(long entryOffset, long keyOffset, int hashCode, RAFWrapper raf) throws IOException {
        if (keyOffset < 0L || keyOffset > this.hv.getWorkingAreaSize()) {
            this.log.append("The sharing descriptors key pointer is at an impossible location " + keyOffset + " at " + entryOffset + "\n");
            return null;
        }
        this.setPosition(keyOffset);
        ObjectInputStream oin = new ObjectInputStream(new ByteBufferInputStream(raf));
        Object o = null;
        boolean success = true;
        try {
            o = oin.readObject();
        }
        catch (Exception e) {
            this.logThrowable(e);
            success = false;
        }
        Path result = null;
        if (success) {
            if (o == null) {
                this.log.append("The sharing descriptor key read at offset " + keyOffset + " is null\n");
            } else {
                if (!(o instanceof String)) {
                    this.log.append("The sharing descriptor value read at offset " + keyOffset + " is of an unknown type " + o.getClass().getName() + "\n");
                } else {
                    Path p;
                    String path = (String)o;
                    String hashName = !this.isCaseSensitive ? path.toUpperCase().toLowerCase() : path;
                    this.addKey(new CaseInsensitiveString(hashName, path), entryOffset, keyOffset, "sharing descriptor");
                    result = p = new Path(null, path);
                    if (!p.isAbsolute()) {
                        this.log.append("Sharing descriptor path \"" + p + "\" is not absolute at offset " + keyOffset + "\n");
                    }
                    if (p.isUNC()) {
                        this.log.append("Sharing descriptor path \"" + p + "\" is a UNC path at offset " + keyOffset + "\n");
                    }
                    if (p.hasTrailingSeparator()) {
                        this.log.append("Sharing descriptor path \"" + p + "\" has a trailing separator at offset " + keyOffset + "\n");
                    }
                    if (p.segmentCount() < 1) {
                        this.log.append("Sharing descriptor path \"" + p + "\" does not have anysegments at " + keyOffset + "\n");
                    }
                    int i = 0;
                    while (i < p.segmentCount()) {
                        if (!p.isValidSegment(p.segment(i))) {
                            this.log.append("The segment \"" + p.segment(i) + "\" of sharing descriptor path \"" + p + "\" at " + keyOffset + " is not valid\n");
                        }
                        ++i;
                    }
                    o = hashName;
                }
                if (o.hashCode() != hashCode) {
                    this.log.append("The entry at " + entryOffset + " contains a hash code (" + hashCode + ") for sharing descriptor key at " + keyOffset + " with path \"" + o + "\" whose hash code is " + o.hashCode() + "\n");
                }
            }
        }
        this.hv.claim(new HeapValidator.HeapClaimant(keyOffset, this.getPosition() - keyOffset, "Sharing Descriptors Key"));
        return result;
    }

    protected ISharingDescriptor validateValue(long entryOffset, long valueOffset, RAFWrapper raf) throws IOException {
        if (valueOffset < 0L || valueOffset > this.hv.getWorkingAreaSize()) {
            this.log.append("The sharing descriptors value pointer is at an impossible location " + valueOffset + " at " + entryOffset + "\n");
            return null;
        }
        this.setPosition(valueOffset);
        ObjectInputStream oin = new ObjectInputStream(new ByteBufferInputStream(raf));
        Object o = null;
        boolean success = true;
        try {
            o = oin.readObject();
        }
        catch (Exception e) {
            this.logThrowable(e);
            success = false;
        }
        SharingDescriptor result = null;
        if (success) {
            if (o == null) {
                this.log.append("The sharing descriptor value read at offset " + valueOffset + " is null\n");
            } else if (!(o instanceof SharingDescriptor)) {
                this.log.append("The sharing descriptor value read at offset " + valueOffset + " is of an unknown type " + o.getClass().getName() + "\n");
            } else {
                SharingDescriptor desc;
                result = desc = (SharingDescriptor)o;
                if (desc.getRepositoryUri() == null) {
                    this.log.append("The sharing descriptor value read at offset " + valueOffset + " has a null repository URI\n");
                } else if (TeamServerFactoryImpl.INSTANCE.validateURL(desc.getRepositoryUri()) != 0) {
                    this.log.append("The sharing descriptor value read at offset " + valueOffset + " contains a repository URI \"" + desc.getRepositoryUri() + "\" which is not valid\n");
                }
                if (desc.getRepositoryId() == null) {
                    this.log.append("The sharing descriptor value read at offset " + valueOffset + " has a null repository UUID\n");
                }
                if (desc.getComponent() == null) {
                    this.log.append("The sharing descriptor value read at offset " + valueOffset + " has a null component\n");
                }
                if (desc.getComponentName() == null) {
                    this.log.append("The sharing descriptor value read at offset " + valueOffset + " has a null component name\n");
                } else if (desc.getComponentName().length() == 0) {
                    this.log.append("The sharing descriptor value read at offset " + valueOffset + " has a component name that is empty\n");
                }
                if (desc.getRootVersionable() == null) {
                    this.log.append("The sharing descriptor value read at offset " + valueOffset + " has a null root folder\n");
                }
                if (desc.getConnectionName() == null) {
                    this.log.append("The sharing descriptor value read at offset " + valueOffset + " has a null connection name\n");
                } else if (desc.getConnectionName().length() == 0) {
                    this.log.append("The sharing descriptor value read at offset " + valueOffset + " has a connection name that is empty\n");
                }
                if (desc.getConnectionHandle() == null) {
                    this.log.append("The sharing descriptor value read at offset " + valueOffset + " has a null connection\n");
                }
                if (desc.getConfigurationState() == null) {
                    this.log.append("The sharing descriptor value read at offset " + valueOffset + " has a null configuration state\n");
                }
                if (desc.isUnknownState()) {
                    if (!ISyncTime.TIME_NONE.equals(desc.getConfigurationState())) {
                        this.log.append("The sharing descriptor value read at offset " + valueOffset + " has configuration state " + desc.getConfigurationState() + " but the flags indicate it is unknown\n");
                    }
                } else if (ISyncTime.TIME_NONE.equals(desc.getConfigurationState())) {
                    this.log.append("The sharing descriptor value read at offset " + valueOffset + " has unknown configuration state but the flags indicate it is known\n");
                }
                try {
                    Field f = SharingDescriptor.class.getDeclaredField("flags");
                    f.setAccessible(true);
                    int flags = f.getInt(desc);
                    int flagMask = 31;
                    if ((flags & ~flagMask) != 0) {
                        this.log.append("The sharing descriptor value read at offset " + valueOffset + " has an unexpected value for flags: " + flags + "\n");
                    }
                }
                catch (NoSuchFieldException e) {
                    this.logThrowable(e);
                }
                catch (IllegalAccessException e) {
                    this.logThrowable(e);
                }
            }
        }
        this.hv.claim(new HeapValidator.HeapClaimant(valueOffset, this.getPosition() - valueOffset, "Sharing Descriptors Value"));
        return result;
    }

    @Override
    public boolean validateCustomMetadata(DataInputStream in) throws IOException {
        int v = in.readInt();
        if (v != 0) {
            this.log.append("Metadata version mismatch for sharing descriptors map: " + v + " != " + 0);
            return false;
        }
        return true;
    }

    protected class ByteBufferInputStream
    extends InputStream {
        protected RAFWrapper raf;
        protected long top;
        boolean closed;

        public ByteBufferInputStream(RAFWrapper raf) {
            this.raf = raf;
            this.top = SharingDescriptorsMapValidator.this.hv.getWorkingAreaSize();
        }

        @Override
        public int read() throws IOException {
            if (this.closed) {
                throw new IOException("Stream closed");
            }
            if (SharingDescriptorsMapValidator.this.getPosition() >= this.top) {
                return -1;
            }
            if (SharingDescriptorsMapValidator.this.buf.remaining() == 0) {
                this.fill();
            }
            return SharingDescriptorsMapValidator.this.buf.get() & 0xFF;
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            if (this.closed) {
                throw new IOException("Stream closed");
            }
            if (SharingDescriptorsMapValidator.this.getPosition() >= this.top) {
                return -1;
            }
            if (SharingDescriptorsMapValidator.this.buf.remaining() == 0) {
                this.fill();
            }
            int read = Math.min(len, SharingDescriptorsMapValidator.this.buf.remaining());
            SharingDescriptorsMapValidator.this.buf.get(b, off, read);
            return read;
        }

        @Override
        public long skip(long n) throws IOException {
            if (this.closed) {
                throw new IOException("Stream closed");
            }
            long realOffset = SharingDescriptorsMapValidator.this.getPosition();
            if (realOffset >= this.top) {
                return 0L;
            }
            if ((n = Math.min(this.top - realOffset, n)) <= (long)SharingDescriptorsMapValidator.this.buf.remaining()) {
                SharingDescriptorsMapValidator.this.buf.position((int)((long)SharingDescriptorsMapValidator.this.buf.position() + n));
            } else {
                SharingDescriptorsMapValidator.this.buf.position(SharingDescriptorsMapValidator.this.buf.limit());
            }
            return n;
        }

        @Override
        public void close() throws IOException {
            this.closed = true;
        }

        protected void fill() throws IOException {
            int currRead;
            SharingDescriptorsMapValidator.this.buf.compact();
            do {
                if ((currRead = this.raf.getFile().getChannel().read(SharingDescriptorsMapValidator.this.buf, SharingDescriptorsMapValidator.this.currentOffset)) == -1) {
                    throw new EOFException();
                }
                SharingDescriptorsMapValidator.this.currentOffset += (long)currRead;
            } while (currRead == 0);
            SharingDescriptorsMapValidator.this.buf.flip();
        }
    }
}

