/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.era;

import com.ibm.team.filesystem.client.internal.era.DeliveryInfo;
import com.ibm.team.filesystem.client.internal.era.EraDescriptor;
import com.ibm.team.filesystem.client.internal.namespace.IItemContext;
import com.ibm.team.filesystem.client.internal.namespace.WorkspaceNamespace;
import com.ibm.team.filesystem.client.util.ConnectionUtil;
import com.ibm.team.repository.common.ItemNotFoundException;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.common.collection.SoftValueMap;
import com.ibm.team.scm.client.IChangeHistory;
import com.ibm.team.scm.client.IChangeHistoryDescriptor;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.ComponentNotInWorkspaceException;
import com.ibm.team.scm.common.IChangeHistoryEntryChange;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.ICurrentComponentInfo;
import com.ibm.team.scm.common.dto.ISyncTime;
import com.ibm.team.scm.common.internal.util.NewCollection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

public class LiveChangeHistoryCache {
    private static SoftValueMap<WorkspaceNamespace, CachedChangeHistory> cache = new SoftValueMap();

    private static List<DeliveryInfo> getDeliveries(List<IChangeHistoryEntryChange> recent) {
        ArrayList changeSets = NewCollection.arrayList();
        for (IChangeHistoryEntryChange next : recent) {
            changeSets.add(new DeliveryInfo(next));
        }
        return changeSets;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CachedChangeHistory fetchRecent(WorkspaceNamespace namespace, IProgressMonitor monitor) throws TeamRepositoryException {
        try {
            List changeSets;
            IChangeHistory previous;
            IChangeHistory changeHistory;
            ISyncTime syncTime3;
            ISyncTime syncTime;
            SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
            IItemContext context = namespace.createContext((IProgressMonitor)progress.newChild(50));
            IConnection connection = context.getConnection();
            IWorkspaceConnection wc = null;
            if (!(connection instanceof IWorkspaceConnection)) {
                EraDescriptor era = context.getChangeSets((IProgressMonitor)progress.newChild(20));
                EraDescriptor previous2 = era.getPreviousEra((IProgressMonitor)progress.newChild(20));
                IChangeHistory current = era.getChangeHistory();
                IChangeHistory history = previous2 == null ? null : previous2.getChangeHistory();
                return new CachedChangeHistory(null, era.getDeliveries((IProgressMonitor)progress.newChild(10)), history, current);
            }
            wc = (IWorkspaceConnection)connection;
            IComponentHandle componentHandle = (IComponentHandle)context.getComponent().toHandle();
            ICurrentComponentInfo componentInfo = wc.getComponentInfo(componentHandle);
            SoftValueMap<WorkspaceNamespace, CachedChangeHistory> current = cache;
            synchronized (current) {
                ISyncTime syncTime2;
                CachedChangeHistory cachedResult = (CachedChangeHistory)cache.get((Object)namespace);
                if (cachedResult != null && LiveChangeHistoryCache.compareSyncTimes(syncTime2 = componentInfo.changeHistoryTime(), cachedResult.getSyncTime())) {
                    return cachedResult;
                }
            }
            do {
                progress.setWorkRemaining(100);
                syncTime = componentInfo.changeHistoryTime();
                if (!ConnectionUtil.hasComponent(wc, context.getComponent())) {
                    return new CachedChangeHistory(null, Collections.<DeliveryInfo>emptyList(), null, null);
                }
                changeHistory = wc.changeHistory(componentHandle);
                IChangeHistoryDescriptor descriptor = changeHistory.getHistoryDescriptor(true, (IProgressMonitor)progress.newChild(94));
                previous = descriptor.previousHistory();
                changeSets = descriptor.recent();
            } while (!LiveChangeHistoryCache.compareSyncTimes(syncTime, syncTime3 = componentInfo.changeHistoryTime()));
            SoftValueMap<WorkspaceNamespace, CachedChangeHistory> softValueMap = cache;
            synchronized (softValueMap) {
                CachedChangeHistory result = new CachedChangeHistory(syncTime, LiveChangeHistoryCache.getDeliveries(changeSets), previous, changeHistory);
                cache.put((Object)namespace, (Object)result);
                return result;
            }
        }
        catch (ItemNotFoundException itemNotFoundException) {
            return new CachedChangeHistory(null, Collections.<DeliveryInfo>emptyList(), null, null);
        }
        catch (ComponentNotInWorkspaceException componentNotInWorkspaceException) {
            return new CachedChangeHistory(null, Collections.<DeliveryInfo>emptyList(), null, null);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return new CachedChangeHistory(null, Collections.<DeliveryInfo>emptyList(), null, null);
        }
    }

    private static boolean compareSyncTimes(ISyncTime syncTime, ISyncTime syncTime2) {
        return syncTime.toString().equals(syncTime2.toString());
    }

    public static final class CachedChangeHistory {
        private ISyncTime syncTime;
        private List<DeliveryInfo> recent;
        private IChangeHistory previous;
        private IChangeHistory current;

        public CachedChangeHistory(ISyncTime syncTime, List<DeliveryInfo> recent, IChangeHistory previous, IChangeHistory current) {
            this.syncTime = syncTime;
            this.recent = recent;
            this.previous = previous;
            this.current = current;
        }

        public ISyncTime getSyncTime() {
            return this.syncTime;
        }

        public List<DeliveryInfo> getRecent() {
            return this.recent;
        }

        public IChangeHistory getPrevious() {
            return this.previous;
        }

        public IChangeHistory getCurrent() {
            return this.current;
        }
    }
}

