/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.ignore.loaders;

import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.IRelativeLocation;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.internal.FileSystemStatusUtil;
import com.ibm.team.filesystem.client.internal.LoggingHelper;
import com.ibm.team.filesystem.client.internal.Messages;
import com.ibm.team.filesystem.client.internal.ignore.DefaultIgnoreProvider;
import com.ibm.team.filesystem.client.internal.ignore.IIgnoreProvider;
import com.ibm.team.filesystem.client.internal.ignore.IgnoreFileLoader;
import com.ibm.team.filesystem.client.internal.ignore.IgnorePattern;
import com.ibm.team.filesystem.client.internal.ignore.IgnoreRule;
import com.ibm.team.filesystem.client.internal.ignore.IgnoreRuleComparator;
import com.ibm.team.filesystem.client.internal.ignore.JazzIgnoreFile;
import com.ibm.team.filesystem.client.internal.ignore.LocalIgnoreRule;
import com.ibm.team.filesystem.client.internal.ignore.RecursiveIgnoreRule;
import com.ibm.team.filesystem.client.internal.utils.PropertiesLoader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.osgi.util.NLS;

public class JazzIgnoreFileLoader_0
implements IgnoreFileLoader.IIgnoreFileLoader {
    public static final String ENCODING = "UTF-8";
    private static Collection<IgnorePattern> rootIgnorePatterns;
    int VERSION = 0;
    public static final char DELIM_START = '{';
    public static final char DELIM_END = '}';
    public static final char ESCAPE = '\\';
    public static final String ESCAPED_DELIM_END = "\\}";
    public static final String ESCAPED_ESCAPE = "\\\\";

    static {
        String pattern;
        rootIgnorePatterns = new ArrayList<IgnorePattern>(JazzIgnoreFile.DEFAULT_PROP_IGNORE_GLOBAL.length + JazzIgnoreFile.DEFAULT_PROP_IGNORE_LOCAL.length);
        String[] stringArray = JazzIgnoreFile.DEFAULT_PROP_IGNORE_GLOBAL;
        int n = JazzIgnoreFile.DEFAULT_PROP_IGNORE_GLOBAL.length;
        int n2 = 0;
        while (n2 < n) {
            pattern = stringArray[n2];
            rootIgnorePatterns.add(new IgnorePattern(){

                @Override
                public String getPattern() {
                    return pattern;
                }

                @Override
                public boolean isGlobal() {
                    return true;
                }
            });
            ++n2;
        }
        stringArray = JazzIgnoreFile.DEFAULT_PROP_IGNORE_LOCAL;
        n = JazzIgnoreFile.DEFAULT_PROP_IGNORE_LOCAL.length;
        n2 = 0;
        while (n2 < n) {
            pattern = stringArray[n2];
            rootIgnorePatterns.add(new IgnorePattern(){

                @Override
                public String getPattern() {
                    return pattern;
                }

                @Override
                public boolean isGlobal() {
                    return false;
                }
            });
            ++n2;
        }
        rootIgnorePatterns = Collections.unmodifiableCollection(rootIgnorePatterns);
    }

    @Override
    public JazzIgnoreFile load(int version, String encoding, DefaultIgnoreProvider.IFilesystemAbstraction filesystem, InputStream inputStream, IIgnoreProvider p, IShareable ignoreFile, IProgressMonitor progress) throws FileSystemException {
        DefaultIgnoreProvider provider = (DefaultIgnoreProvider)p;
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)5);
        long fileSize = filesystem.size(ignoreFile, (IProgressMonitor)monitor.newChild(1));
        Map<String, String> props = this.loadProperties(ignoreFile, encoding, inputStream, fileSize, (IProgressMonitor)monitor.newChild(4));
        SortedSet<IgnoreRule> rules = this.parseProperties(ignoreFile, provider, props);
        return new JazzIgnoreFile(provider, ignoreFile, rules, filesystem.lastModified(ignoreFile), fileSize);
    }

    private Map<String, String> loadProperties(IShareable ignoreFile, String encoding, InputStream inputStream, long fileSize, IProgressMonitor progress) {
        HashMap<String, String> props = new HashMap<String, String>();
        try {
            try {
                PropertiesLoader.load(props, inputStream, encoding, fileSize, progress);
            }
            catch (IOException e) {
                LoggingHelper.log(FileSystemStatusUtil.getStatusFor(4, "Unable to load properties file " + ignoreFile.getLocalPath(), e));
                HashMap<String, String> hashMap = new HashMap<String, String>();
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
                return hashMap;
            }
        }
        catch (Throwable throwable) {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            inputStream.close();
        }
        catch (IOException iOException) {}
        return props;
    }

    private SortedSet<IgnoreRule> parseProperties(IShareable ignoreFile, DefaultIgnoreProvider provider, Map<String, String> properties) {
        String[] globalProps;
        String prop;
        boolean ignoreCase = false;
        TreeSet<IgnoreRule> contents = new TreeSet<IgnoreRule>(IgnoreRuleComparator.INSTANCE);
        boolean isGlobal = this.isGlobal(ignoreFile.getLocalPath());
        String[] localProps = JazzIgnoreFileLoader_0.tokenizeProperties("core.ignore", properties);
        if (localProps == null) {
            localProps = isGlobal ? JazzIgnoreFile.DEFAULT_PROP_IGNORE_LOCAL : new String[]{};
        }
        String[] stringArray = localProps;
        int n = localProps.length;
        int n2 = 0;
        while (n2 < n) {
            prop = stringArray[n2];
            contents.add(new LocalIgnoreRule(ignoreFile, provider, prop, ignoreCase, false));
            ++n2;
        }
        String[] recursiveProps = JazzIgnoreFileLoader_0.tokenizeProperties("core.ignore.recursive", properties);
        if (recursiveProps == null && isGlobal) {
            recursiveProps = JazzIgnoreFile.DEFAULT_PROP_IGNORE_GLOBAL;
        }
        if (recursiveProps != null) {
            stringArray = recursiveProps;
            n = recursiveProps.length;
            n2 = 0;
            while (n2 < n) {
                prop = stringArray[n2];
                contents.add(new RecursiveIgnoreRule(ignoreFile, provider, prop, ignoreCase, false));
                ++n2;
            }
        }
        if (isGlobal && (globalProps = JazzIgnoreFileLoader_0.tokenizeProperties("core.global.ignore", properties)) != null) {
            stringArray = globalProps;
            n = globalProps.length;
            n2 = 0;
            while (n2 < n) {
                prop = stringArray[n2];
                contents.add(new RecursiveIgnoreRule(ignoreFile, provider, prop, ignoreCase, false));
                ++n2;
            }
        }
        return contents;
    }

    public static String[] tokenizeProperties(String name, Map<String, String> properties) {
        String prop = properties.get(name);
        if (prop == null) {
            return null;
        }
        String trimmed = prop.trim();
        ParseState state = ParseState.IN_SEP;
        LinkedList<String> patterns = new LinkedList<String>();
        StringBuffer accumulator = new StringBuffer();
        int i = 0;
        while (i < trimmed.length()) {
            char c = trimmed.charAt(i);
            switch (state) {
                case IN_SEP: {
                    if (Character.isWhitespace(c)) break;
                    if (c == '{') {
                        state = ParseState.IN_DELIM_PATTERN;
                        break;
                    }
                    state = ParseState.IN_NON_DELIM_PATTERN;
                    accumulator.append(c);
                    break;
                }
                case IN_DELIM_PATTERN: {
                    if (c == '\\') {
                        state = ParseState.ESCAPED;
                        break;
                    }
                    if (c == '}') {
                        state = ParseState.IN_SEP;
                        patterns.add(accumulator.toString());
                        accumulator = new StringBuffer();
                        break;
                    }
                    accumulator.append(c);
                    break;
                }
                case IN_NON_DELIM_PATTERN: {
                    if (Character.isWhitespace(c)) {
                        state = ParseState.IN_SEP;
                        patterns.add(accumulator.toString());
                        accumulator = new StringBuffer();
                        break;
                    }
                    accumulator.append(c);
                    break;
                }
                case ESCAPED: {
                    accumulator.append(c);
                    state = ParseState.IN_DELIM_PATTERN;
                }
            }
            ++i;
        }
        if (accumulator.length() > 0) {
            patterns.add(accumulator.toString());
        }
        if (trimmed.length() == 0) {
            return new String[0];
        }
        return patterns.toArray(new String[patterns.size()]);
    }

    private boolean isGlobal(IRelativeLocation path) {
        return path.segmentCount() == 2;
    }

    @Override
    public JazzIgnoreFile store(DefaultIgnoreProvider.IFilesystemAbstraction filesystem, DefaultIgnoreProvider provider, IShareable ignoreFile, SortedSet<IgnoreRule> rules, IProgressMonitor progress) throws FileSystemException {
        byte[] bytes = this.asBytes(ignoreFile.getLocalPath(), rules);
        ByteArrayInputStream in = new ByteArrayInputStream(bytes);
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (String)NLS.bind((String)Messages.JazzIgnoreFileLoader_0_SAVING_IGNORE_FILE, (Object)ignoreFile.getLocalPath().toString()), (int)2);
        try {
            filesystem.write(ignoreFile, in, (IProgressMonitor)monitor.newChild(1));
            JazzIgnoreFile jazzIgnoreFile = new JazzIgnoreFile(provider, ignoreFile, rules, filesystem.lastModified(ignoreFile), filesystem.size(ignoreFile, (IProgressMonitor)monitor.newChild(1)));
            return jazzIgnoreFile;
        }
        finally {
            monitor.done();
        }
    }

    private void writeRules(IRelativeLocation path, Collection<IgnoreRule> toWrite, OutputStreamWriter writer) throws IOException {
        LinkedList<StringBuffer> local = new LinkedList<StringBuffer>();
        LinkedList recursive = new LinkedList();
        for (IgnoreRule ignoreRule : toWrite) {
            StringBuffer pattern = this.encodePattern(ignoreRule.getMatcher().getPattern());
            LinkedList<StringBuffer> dest = local;
            if (ignoreRule.isRecursive()) {
                dest = recursive;
            }
            dest.add(pattern);
        }
        writer.write("core.ignore.recursive= ");
        for (CharSequence charSequence : recursive) {
            writer.write("\\\n\t" + charSequence + " ");
        }
        writer.write("\n\n");
        writer.write("core.ignore= ");
        for (CharSequence charSequence : local) {
            writer.write("\\\n\t" + charSequence + " ");
        }
    }

    private StringBuffer encodePattern(String pattern) {
        StringBuffer buf = new StringBuffer(pattern.length() + 2);
        buf.append('{');
        int i = 0;
        while (i < pattern.length()) {
            char c = pattern.charAt(i);
            if (c == '}') {
                buf.append(ESCAPED_DELIM_END);
            } else if (c == '\\') {
                buf.append(ESCAPED_ESCAPE);
            } else {
                buf.append(c);
            }
            ++i;
        }
        buf.append('}');
        return buf;
    }

    private String getComment(IRelativeLocation path) {
        return Messages.JazzIgnoreFileLoader_0_11;
    }

    @Override
    public int getVersion() {
        return this.VERSION;
    }

    @Override
    public byte[] asBytes(IRelativeLocation path, SortedSet<IgnoreRule> rules) throws FileSystemException {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        try {
            stream.write(IgnoreFileLoader.getInstance().getIgnorePreamble(this.VERSION));
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)stream, ENCODING);
            writer.write(this.getComment(path));
            this.writeRules(path, rules, writer);
            writer.flush();
            writer.close();
        }
        catch (IOException e) {
            throw new FileSystemException(e);
        }
        return stream.toByteArray();
    }

    @Override
    public Collection<IgnorePattern> getDefaultIgnorePatterns(IRelativeLocation path) {
        if (this.isGlobal(path)) {
            return rootIgnorePatterns;
        }
        return Collections.EMPTY_LIST;
    }

    static enum ParseState {
        IN_SEP,
        IN_DELIM_PATTERN,
        ESCAPED,
        IN_NON_DELIM_PATTERN;

    }
}

