/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.operations;

import com.ibm.team.filesystem.client.internal.utils.ConfigurationFacade;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IAuditable;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.IBaseline;
import com.ibm.team.scm.common.IBaselineHandle;
import com.ibm.team.scm.common.IChangeSet;
import com.ibm.team.scm.common.IChangeSetHandle;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.dto.IChangeHistorySyncReport;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

public class OperationRequest {
    private final IWorkspaceConnection workspace;
    private IChangeHistorySyncReport syncReport;
    private List<IBaselineHandle> baselines;
    private List<IChangeSetHandle> changeSets;
    private final List<IComponentHandle> components;
    private final IWorkspaceConnection source;
    private ITeamRepository optionalSource;

    public OperationRequest(IWorkspaceConnection workspace, ITeamRepository optionalSourceRepository, List<IChangeSetHandle> changeSets, IWorkspaceConnection source) {
        if (workspace == null) {
            throw new IllegalArgumentException();
        }
        if (changeSets == null) {
            throw new IllegalArgumentException();
        }
        this.workspace = workspace;
        this.optionalSource = optionalSourceRepository;
        this.changeSets = changeSets;
        this.components = Collections.EMPTY_LIST;
        this.baselines = Collections.EMPTY_LIST;
        this.syncReport = null;
        this.source = source;
    }

    public OperationRequest(IWorkspaceConnection workspace, IChangeHistorySyncReport syncReport, List<IBaselineHandle> baselines, List<IChangeSetHandle> changeSets, IWorkspaceConnection source) {
        this(workspace, syncReport, baselines, changeSets, Collections.EMPTY_LIST, source);
    }

    public OperationRequest(IWorkspaceConnection workspace, IChangeHistorySyncReport syncReport, List<IBaselineHandle> baselines, List<IChangeSetHandle> changeSets, List<IComponentHandle> components, IWorkspaceConnection source) {
        if (workspace == null) {
            throw new IllegalArgumentException();
        }
        if (syncReport == null) {
            throw new IllegalArgumentException();
        }
        if (baselines == null) {
            throw new IllegalArgumentException();
        }
        if (changeSets == null) {
            throw new IllegalArgumentException();
        }
        if (components == null) {
            throw new IllegalArgumentException();
        }
        if (source == null) {
            throw new IllegalArgumentException();
        }
        this.syncReport = syncReport;
        this.baselines = baselines;
        this.workspace = workspace;
        this.changeSets = changeSets;
        this.components = components;
        this.source = source;
    }

    public void clearChanges(IComponentHandle component, IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)10);
        if (this.changeSets.size() > 0) {
            List fullChangeSets = this.getSourceRepository().itemManager().fetchPartialItems(this.changeSets, 0, Collections.singletonList(IChangeSet.COMPONENT_PROPERTY), (IProgressMonitor)progress.newChild(5));
            ArrayList<IChangeSetHandle> newChangeSets = new ArrayList<IChangeSetHandle>();
            for (IChangeSet changeSet : fullChangeSets) {
                if (changeSet.getComponent().sameItemId((IItemHandle)component)) continue;
                newChangeSets.add((IChangeSetHandle)changeSet);
            }
            this.changeSets = newChangeSets;
        }
        if (this.baselines.size() > 0) {
            List fullBaselines = this.getSourceRepository().itemManager().fetchPartialItems(this.baselines, 0, Collections.singletonList(IBaseline.COMPONENT_PROPERTY), (IProgressMonitor)progress.newChild(5));
            ArrayList<IBaselineHandle> newBaselines = new ArrayList<IBaselineHandle>();
            for (IBaseline baseline : fullBaselines) {
                if (baseline.getComponent().sameItemId((IItemHandle)component)) continue;
                newBaselines.add((IBaselineHandle)baseline);
            }
            this.baselines = newBaselines;
        }
    }

    private ITeamRepository getSourceRepository() {
        if (this.optionalSource != null) {
            return this.optionalSource;
        }
        return this.workspace.teamRepository();
    }

    public Collection<ConfigurationFacade> getAffectedConfigurations(List<IAuditable> determinants, IProgressMonitor progress) throws TeamRepositoryException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)100);
        HashSet<ConfigurationFacade> configurations = new HashSet<ConfigurationFacade>();
        if (!this.changeSets.isEmpty()) {
            List fullChangeSets = this.getSourceRepository().itemManager().fetchCompleteItems(this.changeSets, 0, (IProgressMonitor)monitor.newChild(50));
            determinants.addAll(fullChangeSets);
            for (IChangeSet changeSet : fullChangeSets) {
                configurations.add(new ConfigurationFacade((IConnection)this.workspace, changeSet.getComponent()));
            }
        }
        if (!this.baselines.isEmpty()) {
            List fullBaselines = this.getSourceRepository().itemManager().fetchCompleteItems(this.baselines, 0, (IProgressMonitor)monitor.newChild(50));
            determinants.addAll(fullBaselines);
            for (IBaseline baseline : fullBaselines) {
                configurations.add(new ConfigurationFacade((IConnection)this.workspace, baseline.getComponent()));
            }
        }
        if (!this.components.isEmpty()) {
            List fullComponents = this.getSourceRepository().itemManager().fetchCompleteItems(this.components, 0, (IProgressMonitor)monitor.newChild(50));
            determinants.addAll(fullComponents);
            for (IComponentHandle componentHandle : this.components) {
                configurations.add(new ConfigurationFacade((IConnection)this.workspace, componentHandle));
            }
        }
        return configurations;
    }

    public List<IComponentHandle> getAffectedComponents(IProgressMonitor monitor) throws TeamRepositoryException {
        Collection<ConfigurationFacade> affected = this.getAffectedConfigurations(new ArrayList<IAuditable>(), monitor);
        ArrayList<IComponentHandle> affectedComponents = new ArrayList<IComponentHandle>(affected.size());
        for (ConfigurationFacade configurationDescriptor : affected) {
            affectedComponents.add(configurationDescriptor.getComponentHandle());
        }
        return affectedComponents;
    }

    public IWorkspaceConnection getWorkspace() {
        return this.workspace;
    }

    public IWorkspaceConnection getSourceWorkspace() {
        return this.source;
    }

    public IChangeHistorySyncReport getSyncReport() {
        return this.syncReport;
    }

    public void addBaseline(IBaselineHandle baseline) {
        for (IBaselineHandle b : this.baselines) {
            if (!b.sameItemId((IItemHandle)baseline) && baseline != null) continue;
            return;
        }
        this.baselines.add(baseline);
    }

    public void addBaseline(List<IBaselineHandle> baselines) {
        for (IBaselineHandle baseline : baselines) {
            this.addBaseline(baseline);
        }
    }

    public void addChangeSet(IChangeSetHandle changeSet) {
        for (IChangeSetHandle cs : this.changeSets) {
            if (!cs.sameItemId((IItemHandle)changeSet) && changeSet != null) continue;
            return;
        }
        this.changeSets.add(changeSet);
    }

    public void addChangeSet(List<? extends IChangeSetHandle> changeSets) {
        for (IChangeSetHandle iChangeSetHandle : changeSets) {
            this.addChangeSet(iChangeSetHandle);
        }
    }

    public void addComponent(IComponentHandle component) {
        for (IComponentHandle c : this.components) {
            if (!c.sameItemId((IItemHandle)component) && component != null) continue;
            return;
        }
        this.components.add(component);
    }

    public void addComponent(List<IComponentHandle> components) {
        for (IComponentHandle component : components) {
            this.addComponent(component);
        }
    }

    public List<IBaselineHandle> getBaselines() {
        return Collections.unmodifiableList(this.baselines);
    }

    public List<IChangeSetHandle> getChangeSets() {
        return Collections.unmodifiableList(this.changeSets);
    }

    public List<IComponentHandle> getComponents() {
        return Collections.unmodifiableList(this.components);
    }

    public void setReport(IChangeHistorySyncReport report) {
        this.syncReport = report;
    }

    public ITeamRepository getOptionalSourceRepository() {
        return this.optionalSource;
    }
}

