/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.rest.util;

import com.ibm.team.filesystem.client.ILocalChange;
import com.ibm.team.filesystem.client.IOperationFactory;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.internal.rest.CommonUtil;
import com.ibm.team.filesystem.client.internal.rest.util.CommitUtil;
import com.ibm.team.filesystem.client.internal.rest.util.CoreUtil;
import com.ibm.team.filesystem.client.internal.rest.util.ISyncViewProxy;
import com.ibm.team.filesystem.client.internal.rest.util.RefreshUtil;
import com.ibm.team.filesystem.client.internal.rest.util.SandboxUpdateDilemmaUtil;
import com.ibm.team.filesystem.client.internal.rest.util.UpdateDilemmaUtil;
import com.ibm.team.filesystem.client.internal.rest.util.VerifyOutOfSyncUtil;
import com.ibm.team.filesystem.client.internal.rest.util.WorkspaceUpdateUtil;
import com.ibm.team.filesystem.client.internal.utils.ConfigurationFacade;
import com.ibm.team.filesystem.client.operations.BackupDilemmaHandler;
import com.ibm.team.filesystem.client.operations.CommitDilemmaHandler;
import com.ibm.team.filesystem.client.operations.DeliverDilemmaHandler;
import com.ibm.team.filesystem.client.operations.ICheckinOptions;
import com.ibm.team.filesystem.client.operations.IDeliverOperation;
import com.ibm.team.filesystem.client.operations.OutOfSyncDilemmaHandler;
import com.ibm.team.filesystem.client.rest.parameters.ParmsDeliver;
import com.ibm.team.filesystem.client.rest.parameters.ParmsDeliverChangeSetsOrBaselines;
import com.ibm.team.filesystem.client.rest.parameters.ParmsDeliverComponents;
import com.ibm.team.filesystem.client.rest.parameters.ParmsDeliverDilemmaHandler;
import com.ibm.team.filesystem.client.rest.parameters.ParmsDeliverWorkspace;
import com.ibm.team.filesystem.client.rest.parameters.ParmsDeliveryRequiresHistoryReorderingDilemmaHandler;
import com.ibm.team.filesystem.common.internal.rest.client.changeset.DeliverResultDTO;
import com.ibm.team.filesystem.common.internal.rest.client.changeset.FilesystemRestClientDTOchangesetFactory;
import com.ibm.team.filesystem.common.internal.rest.client.core.ConfigurationWithUncheckedInChangesDTO;
import com.ibm.team.filesystem.common.internal.rest.client.core.FilesystemRestClientDTOcoreFactory;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.IBaseline;
import com.ibm.team.scm.common.IBaselineHandle;
import com.ibm.team.scm.common.IChangeSetHandle;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.dto.IChangeHistorySyncReport;
import com.ibm.team.scm.common.dto.IStreamLockReport;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;

public class DeliverUtil {
    public static DeliverResultDTO deliver(ParmsDeliver parms, ISyncViewProxy syncViewProxy, IProgressMonitor progress) throws TeamRepositoryException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)100);
        DeliverResultDTO result = FilesystemRestClientDTOchangesetFactory.eINSTANCE.createDeliverResultDTO();
        DeliverDilemmaHandler dilemmaHandler = DeliverUtil.getDeliverDilemmaHandler(parms, result, (IProgressMonitor)monitor.newChild(5));
        IDeliverOperation deliverOperation = DeliverUtil.prepareDeliverOperation(parms, syncViewProxy, dilemmaHandler, (IProgressMonitor)monitor.newChild(8));
        try {
            deliverOperation.run((IProgressMonitor)monitor.newChild(85));
        }
        catch (OperationCanceledException operationCanceledException) {
            result.setCancelled(true);
        }
        if (parms.structuredResultOptions != null) {
            WorkspaceUpdateUtil.populateWorkspaceUpdateResult(deliverOperation.getUpdateReport(), result.getStructuredResult(), (IProgressMonitor)monitor.newChild(2));
        }
        return result;
    }

    public static DeliverDilemmaHandler getDeliverDilemmaHandler(final ParmsDeliver parms, final DeliverResultDTO result, IProgressMonitor progress) {
        final SandboxUpdateDilemmaUtil sandboxUpdateDilemmaUtil = new SandboxUpdateDilemmaUtil(parms.sandboxUpdateDilemmaHandler, result.getSandboxUpdateDilemma());
        final UpdateDilemmaUtil updateDilemmaUtil = new UpdateDilemmaUtil(parms.updateDilemmaHandler, result.getUpdateDilemma());
        final OutOfSyncDilemmaHandler outOfSyncDilemmaHandler = VerifyOutOfSyncUtil.getOutOfSyncDilemmaHandler(parms.outOfSyncInstructions, result.getOutOfSyncShares(), parms.sandboxUpdateDilemmaHandler, result.getSandboxUpdateDilemma(), progress);
        final CommitDilemmaHandler commitDilemmaHandler = CommitUtil.getCommitDilemmaHandler(parms.pendingChangesDilemmaHandler, result.getCommitDilemma(), parms.sandboxUpdateDilemmaHandler, result.getSandboxUpdateDilemma(), parms.updateDilemmaHandler, result.getUpdateDilemma(), outOfSyncDilemmaHandler);
        final int uncheckedInChangesInstruction = CommitUtil.getUncheckedInChangesInstruction(parms.pendingChangesDilemmaHandler);
        final int flowComponents = DeliverUtil.getFlowComponentsDilemaValue(parms.deliverDilemmaHandler);
        final int flowToNonDefaultTarget = DeliverUtil.getFlowToNonDefaultTarget(parms.deliverDilemmaHandler);
        DeliverDilemmaHandler handler = new DeliverDilemmaHandler(){

            @Override
            public int uncheckedInChanges(Map<ConfigurationFacade, Collection<ILocalChange>> configurationToChangesMap) {
                for (Map.Entry<ConfigurationFacade, Collection<ILocalChange>> entry : configurationToChangesMap.entrySet()) {
                    ConfigurationWithUncheckedInChangesDTO uncheckedInChanges = FilesystemRestClientDTOcoreFactory.eINSTANCE.createConfigurationWithUncheckedInChangesDTO();
                    uncheckedInChanges.setConfiguration(CoreUtil.translateConfigurationDescriptor(entry.getKey()));
                    uncheckedInChanges.setChangeCount(entry.getValue().size());
                    result.getConfigurationsWithUncheckedInChanges().add(uncheckedInChanges);
                }
                return uncheckedInChangesInstruction;
            }

            @Override
            public int notDefaultTarget(Collection<IWorkspaceConnection> targets) {
                result.setFlowToNonDefaultTarget(true);
                return flowToNonDefaultTarget;
            }

            @Override
            public CommitDilemmaHandler getCommitDilemmaHandler() {
                return commitDilemmaHandler;
            }

            @Override
            public int deliverCombinedProblem(IWorkspaceConnection workspaceConnection, IChangeHistorySyncReport syncReport, List<IBaselineHandle> baselines, List<IChangeSetHandle> changeSets, TeamRepositoryException exception) {
                return super.deliverCombinedProblem(workspaceConnection, syncReport, baselines, changeSets, exception);
            }

            @Override
            public int componentsToBeAddedOrRemoved(List<IComponentHandle> added, List<IComponentHandle> removed) {
                result.setComponentsToFlow(true);
                return flowComponents;
            }

            @Override
            public OutOfSyncDilemmaHandler getOutOfSyncDilemmaHandler() {
                return outOfSyncDilemmaHandler;
            }

            @Override
            public int lockBeingHeld(IStreamLockReport lock, IWorkspaceConnection workspaceConnection, int requestsLeft) {
                return 0;
            }

            @Override
            public Map<IStreamLockReport, IWorkspaceConnection> locksToRelease(Map<IStreamLockReport, IWorkspaceConnection> locks) {
                for (Map.Entry<IStreamLockReport, IWorkspaceConnection> entry : locks.entrySet()) {
                    result.getLocksToRelease().add(CoreUtil.getStreamLockReportDTO(entry.getValue(), entry.getKey()));
                }
                return Collections.EMPTY_MAP;
            }

            @Override
            public void locksWereHeld(Map<IStreamLockReport, IWorkspaceConnection> locks) {
                for (Map.Entry<IStreamLockReport, IWorkspaceConnection> entry : locks.entrySet()) {
                    result.getLocksWereHeld().add(CoreUtil.getStreamLockReportDTO(entry.getValue(), entry.getKey()));
                }
            }

            @Override
            public BackupDilemmaHandler getBackupDilemmaHandler() {
                return sandboxUpdateDilemmaUtil.getBackupDilemmaHandler();
            }

            @Override
            public int deliveryRequiresHistoryReordering(IWorkspaceConnection source, IWorkspaceConnection target, IComponent component) {
                ParmsDeliveryRequiresHistoryReorderingDilemmaHandler handler = parms.deliveryRequiresHistoryReorderingDilemmaHandler;
                result.getDeliveryRequiresHistoryReordering().add(CoreUtil.getDeliveryRequiresHistoryReorderingDTO(source, target, component));
                if (handler != null && handler.deliveryRequiresHistoryReordering != null) {
                    if (handler.deliveryRequiresHistoryReordering.equals("continue")) {
                        return 0;
                    }
                    if (handler.deliveryRequiresHistoryReordering.equals("cancel")) {
                        return 1;
                    }
                    if (handler.deliveryRequiresHistoryReordering.equals("fail")) {
                        return 2;
                    }
                }
                return 2;
            }

            @Override
            public int deletedContent(Collection<IShareable> contentDeleted) {
                return sandboxUpdateDilemmaUtil.deletedContent(contentDeleted);
            }

            @Override
            public int inaccessibleForUpdate(Collection<IShareable> shareables) {
                return updateDilemmaUtil.inaccessibleForUpdate(shareables);
            }

            @Override
            public int siblingSharesToAdd(Collection<IShareable> shareables) {
                return updateDilemmaUtil.siblingSharesToAdd(shareables);
            }
        };
        return handler;
    }

    private static IDeliverOperation prepareDeliverOperation(ParmsDeliver parms, ISyncViewProxy syncViewProxy, DeliverDilemmaHandler dilemmaHandler, IProgressMonitor progress) throws TeamRepositoryException {
        IWorkspaceConnection targetWorkspace;
        IWorkspaceConnection sourceWorkspace;
        ITeamRepository repo;
        int n;
        int n2;
        Object[] objectArray;
        SubMonitor subMonitor;
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)200);
        IDeliverOperation deliverOperation = IOperationFactory.instance.getDeliverOperation(dilemmaHandler);
        deliverOperation.setPopulateUpdateReport(parms.structuredResultOptions != null);
        if (parms.deliverChangeSetsOrBaselines != null) {
            subMonitor = monitor.newChild(100).setWorkRemaining(parms.deliverChangeSetsOrBaselines.length * 10);
            objectArray = parms.deliverChangeSetsOrBaselines;
            n2 = parms.deliverChangeSetsOrBaselines.length;
            n = 0;
            while (n < n2) {
                int n3;
                Object deliverChangeSets = objectArray[n];
                repo = CommonUtil.getTeamRepository(((ParmsDeliverChangeSetsOrBaselines)deliverChangeSets).sourceWorkspace.repositoryUrl);
                sourceWorkspace = ((ParmsDeliverChangeSetsOrBaselines)deliverChangeSets).sourceWorkspace.getWorkspaceConnection((IProgressMonitor)subMonitor.newChild(10));
                targetWorkspace = ((ParmsDeliverChangeSetsOrBaselines)deliverChangeSets).targetWorkspace.getWorkspaceConnection((IProgressMonitor)subMonitor.newChild(10));
                ArrayList<IChangeSetHandle> changeSets = new ArrayList<IChangeSetHandle>();
                if (((ParmsDeliverChangeSetsOrBaselines)deliverChangeSets).changeSetItemIds != null) {
                    String[] stringArray = ((ParmsDeliverChangeSetsOrBaselines)deliverChangeSets).changeSetItemIds;
                    n3 = ((ParmsDeliverChangeSetsOrBaselines)deliverChangeSets).changeSetItemIds.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        String changeSetItemId = stringArray[n4];
                        changeSets.add(CommonUtil.createChangeSetHandle(repo, changeSetItemId));
                        ++n4;
                    }
                }
                ArrayList<IBaselineHandle> baselines = new ArrayList<IBaselineHandle>();
                if (((ParmsDeliverChangeSetsOrBaselines)deliverChangeSets).baselineItemIds != null) {
                    String[] stringArray = ((ParmsDeliverChangeSetsOrBaselines)deliverChangeSets).baselineItemIds;
                    int n5 = ((ParmsDeliverChangeSetsOrBaselines)deliverChangeSets).baselineItemIds.length;
                    n3 = 0;
                    while (n3 < n5) {
                        String baselineId = stringArray[n3];
                        baselines.add((IBaselineHandle)IBaseline.ITEM_TYPE.createItemHandle((Object)repo, UUID.valueOf((String)baselineId), null));
                        ++n3;
                    }
                }
                IChangeHistorySyncReport report = syncViewProxy.getCompareReport(sourceWorkspace, targetWorkspace, (IProgressMonitor)monitor);
                deliverOperation.deliver(sourceWorkspace, targetWorkspace, report, baselines, changeSets, Collections.EMPTY_LIST);
                ++n;
            }
        }
        if (parms.deliverComponents != null) {
            subMonitor = monitor.newChild(100).setWorkRemaining(parms.deliverComponents.length * 10);
            objectArray = parms.deliverComponents;
            n2 = parms.deliverComponents.length;
            n = 0;
            while (n < n2) {
                Object deliverComponents = objectArray[n];
                repo = CommonUtil.getTeamRepository(((ParmsDeliverComponents)deliverComponents).sourceWorkspace.repositoryUrl);
                sourceWorkspace = ((ParmsDeliverComponents)deliverComponents).sourceWorkspace.getWorkspaceConnection((IProgressMonitor)subMonitor.newChild(10));
                targetWorkspace = ((ParmsDeliverComponents)deliverComponents).targetWorkspace.getWorkspaceConnection((IProgressMonitor)subMonitor.newChild(10));
                String[] stringArray = ((ParmsDeliverComponents)deliverComponents).componentItemIds;
                int n6 = ((ParmsDeliverComponents)deliverComponents).componentItemIds.length;
                int n7 = 0;
                while (n7 < n6) {
                    String componentItemId = stringArray[n7];
                    IComponentHandle component = (IComponentHandle)IComponent.ITEM_TYPE.createItemHandle((Object)repo, UUID.valueOf((String)componentItemId), null);
                    IChangeHistorySyncReport report = syncViewProxy.getCompareReport(sourceWorkspace, targetWorkspace, (IProgressMonitor)monitor);
                    deliverOperation.deliver(sourceWorkspace, targetWorkspace, report, component);
                    ++n7;
                }
                ++n;
            }
        }
        if (parms.deliverWorkspaces != null) {
            subMonitor = monitor.newChild(100).setWorkRemaining(parms.deliverWorkspaces.length * 10);
            objectArray = parms.deliverWorkspaces;
            n2 = parms.deliverWorkspaces.length;
            n = 0;
            while (n < n2) {
                Object deliverWorkspaces = objectArray[n];
                IWorkspaceConnection sourceWorkspace2 = ((ParmsDeliverWorkspace)deliverWorkspaces).sourceWorkspace.getWorkspaceConnection((IProgressMonitor)subMonitor.newChild(10));
                IWorkspaceConnection targetWorkspace2 = ((ParmsDeliverWorkspace)deliverWorkspaces).targetWorkspace.getWorkspaceConnection((IProgressMonitor)subMonitor.newChild(10));
                IChangeHistorySyncReport report = syncViewProxy.getCompareReport(sourceWorkspace2, targetWorkspace2, (IProgressMonitor)monitor);
                deliverOperation.deliver(sourceWorkspace2, targetWorkspace2, report);
                ++n;
            }
        }
        RefreshUtil.configureRefresh(parms.preoperationRefresh, deliverOperation);
        CommitUtil.configureCommit(parms.pendingChangesDilemmaHandler, (ICheckinOptions)deliverOperation);
        return deliverOperation;
    }

    public static int getFlowComponentsDilemaValue(ParmsDeliverDilemmaHandler deliverParms) {
        int flowComponents;
        if (deliverParms == null) {
            flowComponents = 0;
        } else if ("continue".equals(deliverParms.flowComponents)) {
            flowComponents = 0;
        } else if (deliverParms.flowComponents == null) {
            flowComponents = 0;
        } else if ("cancel".equals(deliverParms.flowComponents)) {
            flowComponents = 1;
        } else if ("fail".equals(deliverParms.flowComponents)) {
            flowComponents = 2;
        } else if ("no".equals(deliverParms.flowComponents)) {
            flowComponents = 3;
        } else {
            throw new IllegalArgumentException("The value of flowComponents must be one of cancel, continue, no or fail");
        }
        return flowComponents;
    }

    public static int getFlowToNonDefaultTarget(ParmsDeliverDilemmaHandler deliverParms) {
        int flowToNonDefaultTarget;
        if (deliverParms == null) {
            flowToNonDefaultTarget = 0;
        } else if ("continue".equals(deliverParms.flowToNonDefault)) {
            flowToNonDefaultTarget = 0;
        } else if (deliverParms.flowToNonDefault == null) {
            flowToNonDefaultTarget = 0;
        } else if ("cancel".equals(deliverParms.flowToNonDefault)) {
            flowToNonDefaultTarget = 1;
        } else if ("fail".equals(deliverParms.flowToNonDefault)) {
            flowToNonDefaultTarget = 2;
        } else {
            throw new IllegalArgumentException("The value of flowToNonDefault must be one of cancel, continue, no or fail");
        }
        return flowToNonDefaultTarget;
    }
}

