/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.snapshot;

import com.ibm.team.filesystem.client.internal.namespace.ItemLocator;
import com.ibm.team.filesystem.client.internal.snapshot.BaselineSetSnapshot;
import com.ibm.team.filesystem.client.internal.snapshot.ISnapshot;
import com.ibm.team.filesystem.client.internal.snapshot.SnapshotId;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.ISimpleItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.scm.common.IBaselineSet;
import com.ibm.team.scm.common.IBaselineSetHandle;
import org.eclipse.core.runtime.IProgressMonitor;

public class BaselineSetId
extends SnapshotId {
    private ItemLocator<IBaselineSet> id;

    private BaselineSetId(ItemLocator<IBaselineSet> id) {
        this.id = id;
    }

    @Override
    public ISnapshot createSnapshot(IProgressMonitor progress) throws TeamRepositoryException {
        return BaselineSetSnapshot.create(this.id, progress);
    }

    public static BaselineSetId create(ItemLocator<IBaselineSet> baseline) {
        return new BaselineSetId(baseline);
    }

    public static BaselineSetId create(ITeamRepository repository, IBaselineSetHandle baseline) {
        ItemLocator<IBaselineSet> locator = ItemLocator.create(repository, (ISimpleItemHandle)baseline);
        return BaselineSetId.create(locator);
    }

    public ItemLocator<IBaselineSet> getId() {
        return this.id;
    }

    @Override
    public IItemHandle getIdentifyingHandle() {
        return this.id.toHandle();
    }

    @Override
    public ITeamRepository getRepository() {
        return this.id.getRepository();
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BaselineSetId other = (BaselineSetId)obj;
        return !(this.id == null ? other.id != null : !this.id.equals(other.id));
    }
}

